/*
 * Decompiled with CFR 0.152.
 */
package jp.nechiru.advancedelectrictools.Item.Battery;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.item.ElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import jp.nechiru.advancedelectrictools.AdvancedElectricTools;
import jp.nechiru.advancedelectrictools.Util.Access.IC2Access;
import jp.nechiru.advancedelectrictools.api.ItemStackHelper;
import jp.nechiru.advancedelectrictools.api.ItemStackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChargingBattery
extends Item
implements IDamagelessElectricItem {
    protected final double STORAGE;
    protected final double ENERGY_TRFR_Lim;
    protected final int TIER;
    protected final String NAME;
    protected final EnumRarity RARITY;

    public ItemChargingBattery(String name, double maxCharge, double transferLimit, int tier, EnumRarity rarity) {
        this.STORAGE = maxCharge;
        this.ENERGY_TRFR_Lim = transferLimit;
        this.TIER = tier;
        this.NAME = name;
        this.RARITY = rarity;
        this.func_77637_a(AdvancedElectricTools.creativeTab);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("advancedelectrictools", "storage_energy_value"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return (float)(ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack));
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        boolean mode = ItemStackHelper.getOrCreateNbtData(stack).func_74767_n("Mode");
        if (GuiScreen.func_146271_m()) {
            tooltip.add("Item Right Click Actions");
            tooltip.add("Toggle the Auto Charging");
            tooltip.add("Press (" + IC2Access.instance.getKeyName(0) + ") to: Check the Auto Charging Mode");
            tooltip.add("");
        } else {
            tooltip.add("Press" + TextFormatting.GOLD + " Ctrl " + TextFormatting.GRAY + "for Key Usage");
        }
        tooltip.add("Auto Charging : " + (mode ? " : Enabled" : " : Disabled"));
        if (this.RARITY == EnumRarity.EPIC) {
            tooltip.add(TextFormatting.LIGHT_PURPLE + "Damage Invalid");
        }
        tooltip.add("");
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        boolean mode = ItemStackHelper.getOrCreateNbtData(stack).func_74767_n("Mode");
        long resiatance_use_tick = 6 / this.getTier(stack);
        if (entity instanceof EntityPlayerMP && world.func_72820_D() % resiatance_use_tick < (long)this.getTier(stack) && mode) {
            boolean inHand;
            EntityPlayer player = (EntityPlayer)entity;
            NonNullList nonNullList = player.field_71071_by.field_70462_a;
            double limit = this.getTransferLimit(stack);
            int tier = this.getTier(stack);
            boolean bl = inHand = player != null && (player.func_184614_ca() == stack || player.func_184592_cb() == stack);
            if (ElectricItem.manager.getCharge(stack) == 0.0) {
                stack.func_77978_p().func_74757_a("Mode", false);
                IC2Access.messagePlayer(player, TextFormatting.RED, this.NAME + " : Low Battery");
            }
            for (int i = 0; i < 9 && limit > 0.0; ++i) {
                ItemStack toCharge = (ItemStack)nonNullList.get(i);
                if (ItemStackUtil.isEmpty(toCharge) || inHand && i == player.field_71071_by.field_70461_c || toCharge.func_77973_b() instanceof ItemChargingBattery) continue;
                double charge = ElectricItem.manager.charge(toCharge, limit, tier, true, true);
                charge = ElectricItem.manager.discharge(stack, charge, tier, true, false, false);
                ElectricItem.manager.charge(toCharge, charge, tier, true, false);
                limit -= charge;
            }
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (this.RARITY == EnumRarity.EPIC && entityItem.field_70163_u >= 0.0) {
            entityItem.func_70066_B();
            entityItem.func_184224_h(true);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean mode = ItemStackHelper.getOrCreateCompound(stack).func_74767_n("Mode");
        TextFormatting textColor = this.RARITY.getColor();
        if (IC2Access.isSimulating()) {
            if (IC2Access.instance.isKeyDown("Alt", player)) {
                IC2Access.messagePlayer(player, TextFormatting.GOLD, this.NAME + (mode ? " : Enabled" : " : Disabled"));
                IC2Access.messagePlayer(player, TextFormatting.GOLD, "Remaining amount : " + (int)(ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack) * 100.0) + "%");
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            if (ElectricItem.manager.getCharge(stack) > 0.0) {
                mode = !mode;
                stack.func_77978_p().func_74757_a("Mode", mode);
                IC2Access.messagePlayer(player, textColor, this.NAME + (mode ? " : Enabled" : " : Disabled"));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return this.RARITY;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.STORAGE;
    }

    public int getTier(ItemStack stack) {
        return this.TIER;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.ENERGY_TRFR_Lim;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return this.RARITY == EnumRarity.EPIC ? Integer.MAX_VALUE : 6000;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        ItemStack charged = IC2Access.getChargedStack(new ItemStack((Item)this, 1));
        items.add((Object)charged);
    }
}

