/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.IOUtils;
import team.creative.ambientsounds.AmbientCondition;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientSelection;
import team.creative.ambientsounds.AmbientSound;
import team.creative.ambientsounds.AmbientStackType;
import team.creative.ambientsounds.env.AmbientEnviroment;
import team.creative.creativecore.common.config.api.CreativeConfig;

public class AmbientRegion
extends AmbientCondition {
    public String name;
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting = 1.0;
    public AmbientStackType stack = AmbientStackType.overwrite;
    protected transient boolean active;
    public transient LinkedHashMap<String, AmbientSound> sounds = new LinkedHashMap();
    transient List<AmbientSound> playing = new ArrayList<AmbientSound>();
    public transient AmbientDimension dimension;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(AmbientEngine engine, Gson gson, ResourceManager manager) throws IOException {
        this.sounds = new LinkedHashMap();
        for (Resource resource : manager.m_213829_(new ResourceLocation("ambientsounds", engine.name + "/sounds/" + (String)(this.dimension != null ? this.dimension.name + "." : "") + this.name + ".json"))) {
            try (InputStream input = resource.m_215507_();){
                try {
                    AmbientSound[] sounds = (AmbientSound[])gson.fromJson(JsonParser.parseString((String)IOUtils.toString((InputStream)input, (Charset)Charsets.UTF_8)), AmbientSound[].class);
                    for (int j = 0; j < sounds.length; ++j) {
                        AmbientSound sound = sounds[j];
                        this.sounds.put(sound.name, sound);
                    }
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String regionName() {
        return this.name;
    }

    public void apply(AmbientRegion region) {
        for (Field field : this.getClass().getFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
            try {
                region.stack.apply(this, field, region);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void init(AmbientEngine engine) {
        super.init(engine);
        if (this.sounds != null) {
            for (AmbientSound sound : this.sounds.values()) {
                sound.init(engine);
            }
        }
    }

    @Override
    public AmbientSelection value(AmbientEnviroment env) {
        if (this.dimension != null && this.dimension != env.dimension) {
            return null;
        }
        if (this.volumeSetting == 0.0) {
            return null;
        }
        AmbientSelection selection = super.value(env);
        if (selection != null) {
            selection.volume *= this.volumeSetting;
        }
        return selection;
    }

    public boolean fastTick(AmbientEnviroment env) {
        if (!this.playing.isEmpty()) {
            Iterator<AmbientSound> iterator = this.playing.iterator();
            while (iterator.hasNext()) {
                AmbientSound sound = iterator.next();
                if (sound.fastTick(env)) continue;
                sound.deactivate();
                iterator.remove();
            }
        }
        return !this.playing.isEmpty();
    }

    public boolean tick(AmbientEnviroment env) {
        if (this.sounds == null) {
            return false;
        }
        AmbientSelection selection = this.value(env);
        for (AmbientSound sound : this.sounds.values()) {
            if (sound.tick(env, selection)) {
                if (sound.isActive()) continue;
                sound.activate();
                this.playing.add(sound);
                continue;
            }
            if (!sound.isActive()) continue;
            sound.deactivate();
            this.playing.remove(sound);
        }
        return !this.playing.isEmpty();
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
        if (!this.playing.isEmpty()) {
            for (AmbientSound sound : this.playing) {
                sound.deactivate();
            }
            this.playing.clear();
        }
    }

    public String toString() {
        return this.name + ", playing: " + this.playing.size();
    }
}

