/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools.weapons;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.legacy.blue_skies.items.tools.weapons.SkySwordItem;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InfusedArcSwordItem
extends SkySwordItem {
    protected AttributeModifier INFUSED_DAMAGE = new AttributeModifier(f_41374_, "Infused damage modifier", (double)(this.m_43299_() * 0.7f), AttributeModifier.Operation.ADDITION);
    private byte maxInfusedHits = (byte)30;

    public InfusedArcSwordItem(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public static byte getInfusedHits(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt.m_128445_("InfusedHits");
    }

    public static void setInfusedHits(ItemStack stack, byte hitsIn) {
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128344_("InfusedHits", hitsIn);
    }

    public static int getInfusedCooldown(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt.m_128451_("InfusedCooldown");
    }

    public static void setInfusedCooldown(ItemStack stack, int cooldownIn) {
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128405_("InfusedCooldown", cooldownIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entity, int itemSlot, boolean isSelected) {
        if (InfusedArcSwordItem.getInfusedCooldown(stack) > 0 && entity.f_19797_ % 20 == 0) {
            InfusedArcSwordItem.setInfusedCooldown(stack, InfusedArcSwordItem.getInfusedCooldown(stack) - 1);
            if (InfusedArcSwordItem.getInfusedCooldown(stack) == 0) {
                entity.f_19853_.m_6269_((Player)null, entity, SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            if (InfusedArcSwordItem.getInfusedCooldown(stack) > 0) {
                return false;
            }
            if (InfusedArcSwordItem.getInfusedHits(stack) < this.maxInfusedHits) {
                InfusedArcSwordItem.setInfusedHits(stack, (byte)(InfusedArcSwordItem.getInfusedHits(stack) + 1));
            } else {
                attacker.f_19853_.m_6269_(null, (Entity)attacker, SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f);
                InfusedArcSwordItem.setInfusedCooldown(stack, this.maxInfusedHits * 2);
                InfusedArcSwordItem.setInfusedHits(stack, (byte)0);
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            if (InfusedArcSwordItem.getInfusedCooldown(stack) > 0) {
                multimap.put((Object)Attributes.f_22281_, (Object)this.INFUSED_DAMAGE);
            } else {
                multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.m_43299_(), AttributeModifier.Operation.ADDITION));
            }
            multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)ToolUtils.getAttackSpeed(this.attackSpeed, stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> lore, TooltipFlag flagIn) {
        if (InfusedArcSwordItem.getInfusedCooldown(stack) <= 0) {
            lore.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Charged Hits Remaining: " + (this.maxInfusedHits + 1 - InfusedArcSwordItem.getInfusedHits(stack)))));
        } else {
            lore.add((Component)Component.m_237113_((String)(ChatFormatting.AQUA + "Time Remaining: " + InfusedArcSwordItem.getInfusedCooldown(stack))));
        }
        lore.add((Component)StringUtil.UNFINISHED);
    }
}

