/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BossLootBagItem
extends LootBagItem {
    private final Supplier<EntityType<?>> boss;

    public BossLootBagItem(Item.Properties properties, Supplier<EntityType<?>> boss) {
        super(properties);
        this.boss = boss;
    }

    @Override
    public <T extends Item> void fillItemCategoryWithRarity(CreativeModeTab group, NonNullList<ItemStack> stacks, T item) {
        String bossName = ForgeRegistries.ENTITIES.getKey(this.boss.get()).m_135815_();
        for (IRarityItem.SkiesRarity rarity : IRarityItem.SkiesRarity.values()) {
            ItemStack stack = new ItemStack(item);
            ((IRarityItem)item).setRarityTag(stack, rarity);
            this.setLootTable(stack, BlueSkies.locate("loot_bags/" + bossName + "/" + rarity));
            stacks.add((Object)stack);
        }
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (group == CreativeModeTab.f_40754_) {
            this.fillItemCategoryWithRarity(group, stacks, this);
        } else if (this.m_220152_(group)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            String bossName = ForgeRegistries.ENTITIES.getKey(this.boss.get()).m_135815_();
            this.setRarityTag(stack, IRarityItem.SkiesRarity.COMMON);
            this.setLootTable(stack, BlueSkies.locate("loot_bags/" + bossName + "/" + IRarityItem.SkiesRarity.COMMON));
            stacks.add((Object)stack);
        }
    }
}

