/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util.interfaces;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.entities.BossItemEntity;
import com.legacy.blue_skies.entities.SupporterPetEntity;
import com.legacy.blue_skies.entities.util.SkiesDungeonType;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBossMob;
import com.legacy.blue_skies.items.LootBagItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesStats;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public interface ISkyBoss
extends ISkyBossMob {
    public static final Predicate<Mob> IS_BOSS = entity -> entity instanceof ISkyBoss;

    default public Predicate<LivingEntity> canAttackPredicate() {
        return entity -> {
            if (entity == this.getBoss() || entity instanceof Player && !EntitySelector.f_20406_.test(entity) || entity instanceof SupporterPetEntity) {
                return false;
            }
            return !entity.m_20147_() && !this.getBoss().m_7307_((Entity)entity) && entity.m_6084_() && entity.f_19802_ <= 0 && EntitySelector.f_20408_.test(entity);
        };
    }

    default public Predicate<LivingEntity> canSeeAndAttackPredicate() {
        return entity -> this.getBoss().m_21574_().m_148306_((Entity)entity) && this.canAttackPredicate().test((LivingEntity)entity);
    }

    public Monster getBoss();

    public SkiesDungeonType getBossType();

    public int getProgression();

    public boolean isEverbrightBoss();

    public float getHealAmount();

    public double getBossHealth();

    public boolean isBossRespawned();

    default public float getMaxReach() {
        return -1.0f;
    }

    default public int getDamageCap() {
        return 20;
    }

    default public byte getDefaultDifficultyID(Difficulty difficultyIn) {
        return (byte)(difficultyIn == Difficulty.HARD ? 2 : (difficultyIn == Difficulty.NORMAL ? 1 : 0));
    }

    public byte getDifficultyID();

    default public BossLevel getBossDifficulty() {
        return BossLevel.getFromId(this.getDifficultyID());
    }

    default public BlockPos bossSpawnOffset() {
        return BlockPos.f_121853_;
    }

    public static Component getDifficultyDecoration(byte diffID) {
        int color = diffID == BossLevel.SILVER.getId() ? 0xB6B6B6 : (diffID == BossLevel.GOLD.getId() ? 14463509 : (diffID == BossLevel.PLATINUM.getId() ? 10336465 : 13467442));
        return Component.m_237113_((String)" \u2b50").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)color)));
    }

    public LootBagItem getLootBag();

    @Nullable
    default public TrophyBlock getTrophy() {
        return null;
    }

    public BlockPos getHome();

    public BossEvent.BossBarColor getBossBarColor();

    public boolean isDungeonSpawned();

    default public BossItemEntity dropLootBag(Player player) {
        Monster entity = this.getBoss();
        ItemStack stack = new ItemStack((ItemLike)this.getLootBag());
        IRarityItem.SkiesRarity rarity = this.getBossDifficulty().getBagRarity(entity.f_19853_.f_46441_);
        this.getLootBag().setLootTable(stack, BlueSkies.locate("loot_bags/" + ForgeRegistries.ENTITIES.getKey((Object)entity.m_6095_()).m_135815_() + "/" + rarity));
        this.getLootBag().setRarityTag(stack, rarity);
        if (stack.m_41619_()) {
            return null;
        }
        if (entity.f_19853_.f_46443_) {
            return null;
        }
        BossItemEntity itementity = new BossItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
        itementity.setVisiblePlayerId(player.m_20148_());
        itementity.m_32060_();
        entity.f_19853_.m_7967_((Entity)itementity);
        return itementity;
    }

    default public BossItemEntity dropTrophy(Player player) {
        if (this.getTrophy() == null) {
            return null;
        }
        Monster entity = this.getBoss();
        ItemStack stack = BossLevel.getTier(this.getBossDifficulty()).getItem(this.getTrophy());
        if (stack.m_41619_()) {
            return null;
        }
        if (entity.f_19853_.f_46443_) {
            return null;
        }
        BossItemEntity itementity = new BossItemEntity(entity.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
        itementity.setVisiblePlayerId(player.m_20148_());
        itementity.m_32060_();
        entity.f_19853_.m_7967_((Entity)itementity);
        return itementity;
    }

    default public List<Player> getAllPlayersInDungeonArea() {
        return this.getPlayersInDungeonArea(15.0, true);
    }

    default public List<Player> getPlayersInDungeonArea() {
        return this.getPlayersInDungeonArea(15.0, false);
    }

    default public List<Player> getPlayersInDungeonArea(double distance, boolean creative) {
        if (this.getBoss().f_19853_.f_46443_) {
            return this.getBoss().f_19853_.m_6443_(Player.class, this.getBoss().m_20191_().m_82400_(distance), EntitySelector.f_20406_);
        }
        if (!this.getBoss().f_19853_.f_46443_ && this.getHome() != null && this.getHome() != BlockPos.f_121853_) {
            return this.getBoss().f_19853_.m_6443_(Player.class, new AABB((double)this.getHome().m_123341_() - distance, (double)this.getHome().m_123342_() - 1.0, (double)this.getHome().m_123343_() - distance, (double)this.getHome().m_123341_() + distance, (double)this.getHome().m_123342_() + 10.0, (double)this.getHome().m_123343_() + distance), creative ? EntitySelector.f_20403_.and(EntitySelector.f_20408_) : EntitySelector.f_20406_);
        }
        return ImmutableList.of();
    }

    default public List<Cow> getCowsInDungeonArea(double distance) {
        if (this.getBoss().f_19853_.f_46443_) {
            return Lists.newArrayList();
        }
        return this.getBoss().f_19853_.m_45976_(Cow.class, new AABB((double)this.getHome().m_123341_() - distance, (double)this.getHome().m_123342_() - 1.0, (double)this.getHome().m_123343_() - distance, (double)this.getHome().m_123343_() + distance, (double)this.getHome().m_123342_() + 10.0, (double)this.getHome().m_123343_() + distance));
    }

    default public void randomizeAttackTarget(boolean extraChance) {
        List<Player> playersInDungeon = this.getPlayersInDungeonArea();
        playersInDungeon.forEach(players -> {
            if (extraChance && players != this.getBoss().m_5448_() && playersInDungeon.size() > 1 && !players.m_7500_() && !players.m_5833_()) {
                this.getBoss().m_6710_((LivingEntity)players);
            }
        });
    }

    default public ServerBossEvent getNewBossInfo() {
        return (ServerBossEvent)new ServerBossEvent((Component)this.getBoss().m_5446_().m_6879_().m_7220_(ISkyBoss.getDifficultyDecoration(this.getDifficultyID())), this.getBossBarColor(), BossEvent.BossBarOverlay.PROGRESS).m_7003_(false).m_7005_(true);
    }

    default public void spawnParticles(ParticleOptions particleType) {
        if (!this.getBoss().f_19853_.f_46443_) {
            return;
        }
        double dx = this.getBoss().f_19853_.f_46441_.m_188583_() * 0.02;
        double dy = this.getBoss().f_19853_.f_46441_.m_188583_() * 0.02;
        double dz = this.getBoss().f_19853_.f_46441_.m_188583_() * 0.02;
        this.getBoss().f_19853_.m_7106_(particleType, this.getBoss().m_20185_() + (double)(this.getBoss().f_19853_.f_46441_.m_188501_() * this.getBoss().m_20205_() * 2.0f) - (double)this.getBoss().m_20205_(), this.getBoss().m_20186_() + (double)(this.getBoss().f_19853_.f_46441_.m_188501_() * this.getBoss().m_20206_()), this.getBoss().m_20189_() + (double)(this.getBoss().f_19853_.f_46441_.m_188501_() * this.getBoss().m_20205_() * 2.0f) - (double)this.getBoss().m_20205_(), dx, dy, dz);
    }

    public ServerBossEvent getBossInfo();

    default public void bossTick() {
        this.getBossInfo().m_142711_(this.getBoss().m_21223_() / this.getBoss().m_21233_());
        if (this.getInvulTime() > 0) {
            int j1 = this.getInvulTime() - 1;
            this.setInvulTime(j1);
            if (j1 <= 0) {
                this.getBoss().f_19853_.m_6263_(null, this.getBoss().m_20185_(), this.getBoss().m_20186_(), this.getBoss().m_20189_(), SkiesSounds.ENTITY_BOSS_SPAWNED, SoundSource.HOSTILE, 2.0f, 1.0f);
            }
            this.invulnerableTick();
        }
    }

    default public void invulnerableTick() {
    }

    default public void readDefaultBossNBT(CompoundTag compound) {
        this.setDungeonSpawned(compound.m_128471_("DungeonSpawned"));
        this.setInvulTime(compound.m_128451_("Invul"));
        this.setBossRespawned(compound.m_128471_("BossRespawned"));
        this.setDifficultyID(compound.m_128445_("DifficultyID"));
        this.getBossInfo().m_6456_((Component)this.getBoss().m_5446_().m_6879_().m_7220_(ISkyBoss.getDifficultyDecoration(compound.m_128445_("DifficultyID"))));
        if (compound.m_128441_("HomeX") && compound.m_128441_("HomeY") && compound.m_128441_("HomeZ")) {
            this.setHome(new BlockPos(compound.m_128459_("HomeX"), compound.m_128459_("HomeY"), compound.m_128459_("HomeZ")));
        }
        if (compound.m_128441_("BossHomePos")) {
            this.setHome(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("BossHomePos")));
        }
    }

    default public void writeDefaultBossNBT(CompoundTag compound) {
        compound.m_128405_("Invul", this.getInvulTime());
        compound.m_128379_("DungeonSpawned", this.isDungeonSpawned());
        compound.m_128379_("BossRespawned", this.isBossRespawned());
        compound.m_128344_("DifficultyID", this.getDifficultyID());
        if (this.getHome() != null) {
            compound.m_128365_("BossHomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.getHome()));
        }
    }

    default public void defaultSpawningRoutine(DifficultyInstance difficultyIn) {
        byte diffId = (byte)(this.getDefaultDifficultyID(difficultyIn.m_19048_()) + (this.isBossRespawned() ? (byte)1 : 0));
        this.setDifficultyID(diffId);
        this.getBossInfo().m_6456_((Component)this.getBoss().m_5446_().m_6879_().m_7220_(ISkyBoss.getDifficultyDecoration(diffId)));
        if (this.getHome() == null || this.getHome() != null && this.getHome().equals((Object)BlockPos.f_121853_)) {
            this.setHome(this.getBoss().m_20183_());
        }
        this.getBoss().m_21051_(Attributes.f_22276_).m_22100_(this.getBossHealth());
        this.getBoss().m_21153_(this.getBoss().m_21233_());
        BlueSkies.LOGGER.info("Spawned a(n) " + this.getBoss().m_5446_().getString() + " scaled to " + (1 + this.getExtraPlayers()) + " player(s). The difficulty ID is " + BossLevel.getFromId(diffId) + ". The position is " + this.getBoss().m_20183_());
    }

    default public void onBossDeath(DamageSource source) {
        if (!this.getAllPlayersInDungeonArea().isEmpty()) {
            this.getAllPlayersInDungeonArea().forEach(players -> {
                if (this.getBoss().f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    this.dropLootBag((Player)players);
                    this.dropTrophy((Player)players);
                }
                if (source.m_7639_() instanceof Player && players instanceof ServerPlayer) {
                    CriteriaTriggers.f_10568_.m_48104_((ServerPlayer)players, (Entity)this.getBoss(), source);
                }
                if (!players.m_7500_() && !players.m_5833_()) {
                    if (!this.isBossRespawned()) {
                        players.m_36220_(SkiesStats.DUNGEONS_CONQUERED);
                    }
                    players.m_36220_(SkiesStats.BOSSES_DEFEATED);
                }
            });
        }
    }

    default public boolean isSecondPhase() {
        return this.getBoss().m_21223_() <= this.getBoss().m_21233_() / 2.0f;
    }

    default public boolean hasAttackTarget() {
        return this.getBoss().m_5448_() != null;
    }

    default public int getExtraPlayers() {
        return Math.max(0, this.getPlayersInDungeonArea().size() - 1);
    }

    default public boolean isBossInvul() {
        return this.getInvulTime() > 0;
    }

    public void setHome(BlockPos var1);

    public void setDungeonSpawned(boolean var1);

    public void setBossRespawned(boolean var1);

    public int getInvulTime();

    public void setInvulTime(int var1);

    public void setDifficultyID(byte var1);

    default public int lowerCooldown(int cooldown) {
        if (cooldown > 0) {
            --cooldown;
        }
        return cooldown;
    }

    public static enum BossLevel {
        BRONZE(0, 70, 25, 5),
        SILVER(1, 60, 30, 10),
        GOLD(2, 50, 30, 20),
        PLATINUM(3, 0, 60, 40);

        private final int id;
        private final List<IRarityItem.WeightedSkiesRarity> weights = new ArrayList<IRarityItem.WeightedSkiesRarity>();

        private BossLevel(int id, int commonBagChance, int uncommonBagChance, int rareBagChance) {
            this.id = id;
            if (commonBagChance > 0) {
                this.weights.add(new IRarityItem.WeightedSkiesRarity(commonBagChance, IRarityItem.SkiesRarity.COMMON));
            }
            if (uncommonBagChance > 0) {
                this.weights.add(new IRarityItem.WeightedSkiesRarity(uncommonBagChance, IRarityItem.SkiesRarity.UNCOMMON));
            }
            if (rareBagChance > 0) {
                this.weights.add(new IRarityItem.WeightedSkiesRarity(rareBagChance, IRarityItem.SkiesRarity.RARE));
            }
        }

        public IRarityItem.SkiesRarity getBagRarity(RandomSource rand) {
            return ((IRarityItem.WeightedSkiesRarity)WeightedRandomList.m_146328_(this.weights).m_216829_(rand).get()).getRarity();
        }

        public static BossLevel getFromId(int id) {
            for (BossLevel type : BossLevel.values()) {
                if (id != type.id) continue;
                return type;
            }
            return BRONZE;
        }

        public int getId() {
            return this.id;
        }

        public static TrophyBlock.Tier getTier(BossLevel level) {
            switch (level) {
                case PLATINUM: {
                    return TrophyBlock.Tier.PLATINUM;
                }
                case GOLD: {
                    return TrophyBlock.Tier.GOLD;
                }
                case SILVER: {
                    return TrophyBlock.Tier.SILVER;
                }
            }
            return TrophyBlock.Tier.BRONZE;
        }
    }
}

