/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.util.base;

import com.legacy.blue_skies.client.gui.menu.MountInventoryMenu;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public abstract class SkiesMountEntity
extends SkiesAnimalEntity
implements ContainerListener {
    private static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(SkiesMountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(SkiesMountEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected boolean mountJumping;
    protected SimpleContainer mountInventory;

    public SkiesMountEntity(EntityType<? extends SkiesMountEntity> type, Level worldIn) {
        super(type, worldIn);
        this.initMountInventory();
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, this.m_21525_() ? Vec3.f_82478_ : pos);
    }

    public boolean useTraditionalTravel() {
        return false;
    }

    public abstract int getMaxInventorySlots();

    public abstract Item getSaddleItem();

    public abstract Item getTameItem();

    public SimpleContainer getMountInventory() {
        return this.mountInventory;
    }

    protected void initMountInventory() {
        SimpleContainer inventory = this.mountInventory;
        this.mountInventory = new SimpleContainer(this.getMaxInventorySlots());
        if (inventory != null) {
            inventory.m_19181_((ContainerListener)this);
            int i = Math.min(inventory.m_6643_(), this.mountInventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventory.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.mountInventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.mountInventory.m_19164_((ContainerListener)this);
    }

    public void m_5757_(Container invBasic) {
        boolean prevSaddled = this.isSaddled();
        if (invBasic.m_8020_(0).m_41720_() == this.getSaddleItem() && !prevSaddled) {
            this.m_5496_(SoundEvents.f_12034_, 0.5f, 1.0f);
            this.setSaddled(true);
        } else if (invBasic.m_8020_(0).m_41720_() != this.getSaddleItem()) {
            this.setSaddled(false);
        }
    }

    public void m_7023_(Vec3 travelVectorIn) {
        if (this.useTraditionalTravel()) {
            super.m_7023_(travelVectorIn);
            return;
        }
        if (this.isSaddled() && this.m_6084_()) {
            Entity entity;
            Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.m_146922_(entity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(entity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
                this.f_19793_ = 1.0f;
                this.f_20887_ = this.m_6113_() * 0.1f;
                float forward = player.f_20902_;
                float strafe = player.f_20900_;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (this.m_6109_()) {
                    float f = (float)this.m_21051_(Attributes.f_22279_).m_22135_() * 0.225f;
                    this.m_7910_(f);
                    if (player.f_20899_ && this.f_19861_) {
                        Vec3 look = this.m_20252_(1.0f);
                        float jumpTravel = (this.m_6113_() <= 2.0f ? 0.1f : 0.4f) * forward;
                        this.m_20256_(this.m_20184_().m_82520_(look.f_82479_ * (double)jumpTravel, (double)this.m_6118_(), look.f_82481_ * (double)jumpTravel));
                    }
                    super.m_7023_(new Vec3((double)(strafe * 0.4f), 0.0, (double)forward));
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.f_20923_ = this.f_20924_;
                double d1 = this.m_20185_() - this.f_19854_;
                double d0 = this.m_20189_() - this.f_19856_;
                float f1 = Mth.m_14116_((float)((float)(d1 * d1 + d0 * d0))) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.f_20924_ += (f1 - this.f_20924_) * 0.4f;
                this.f_20925_ += this.f_20924_;
            } else {
                this.f_19793_ = 0.5f;
                this.f_20887_ = 0.02f;
                super.m_7023_(travelVectorIn);
            }
        } else {
            super.m_7023_(travelVectorIn);
        }
    }

    public Entity m_6688_() {
        Entity entity = this.m_146895_();
        return entity != null && this.isSaddled() ? entity : null;
    }

    protected float m_6118_() {
        return this.m_20160_() ? 0.7f : super.m_6118_();
    }

    public float m_6113_() {
        return this.m_20160_() ? 0.25f : 0.3f;
    }

    @Override
    public Item getMainBreedingItem() {
        return this.getTameItem();
    }

    @Override
    public AgeableMob createChild(AgeableMob ageable) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TAMED, (Object)false);
        this.f_19804_.m_135372_(SADDLED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Saddle", this.isSaddled());
        compound.m_128379_("Tame", this.isTamed());
        if (!this.getMountInventory().m_8020_(0).m_41619_()) {
            compound.m_128365_("SaddleItem", (Tag)this.getMountInventory().m_8020_(0).m_41739_(new CompoundTag()));
        }
    }

    public void m_20258_(CompoundTag compound) {
        ItemStack itemstack;
        super.m_20258_(compound);
        this.setSaddled(compound.m_128471_("Saddle"));
        this.setTamed(compound.m_128471_("Tame"));
        if (this.isSaddled() && (itemstack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("SaddleItem"))).m_41720_() == this.getSaddleItem()) {
            this.getMountInventory().m_6836_(0, itemstack);
        }
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.f_19804_.m_135381_(TAMED, (Object)tamed);
    }

    protected void playTameEffect(boolean play) {
        SimpleParticleType enumparticletypes = !play ? ParticleTypes.f_123762_ : ParticleTypes.f_123750_;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)enumparticletypes, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 7) {
            this.playTameEffect(true);
        } else if (id == 6) {
            this.playTameEffect(false);
        } else {
            super.m_7822_(id);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!super.m_6071_(player, hand).m_19077_()) {
            ItemStack itemstack = player.m_21120_(hand);
            if (itemstack.m_41720_() == Items.f_42656_) {
                itemstack.m_41647_(player, (LivingEntity)this, hand);
                return InteractionResult.SUCCESS;
            }
            if (!player.m_6047_() && !this.m_20160_() && this.isTamed()) {
                if (!this.f_19853_.f_46443_) {
                    player.m_20329_((Entity)this);
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.m_6162_() && this.isTamed() && (itemstack.m_41720_() == this.getSaddleItem() || player.m_6047_())) {
                if (player instanceof ServerPlayer) {
                    SkiesMountEntity.openMountContainer((ServerPlayer)player, this);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.getMountInventory() != null) {
            for (int i = 0; i < this.getMountInventory().m_6643_(); ++i) {
                ItemStack itemstack = this.getMountInventory().m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    public static void openMountContainer(ServerPlayer player, SkiesMountEntity enderHorse) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new SimpleMenuProvider((id, inventory, playerIn) -> new MountInventoryMenu(id, inventory, enderHorse), enderHorse.m_7755_()), buffer -> buffer.writeInt(enderHorse.m_19879_()));
    }
}

