/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class StardustRamEntity
extends Sheep {
    private EatSkyGrassGoal eatGrassGoal;

    public StardustRamEntity(EntityType<? extends StardustRamEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.eatGrassGoal = new EatSkyGrassGoal((Mob)this);
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{SkiesItems.pine_fruit}), false));
        this.f_21345_.m_25352_(5, (Goal)this.eatGrassGoal);
    }

    protected void m_8024_() {
        this.f_29802_ = this.eatGrassGoal.getEatAnimationTick();
        super.m_8024_();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.23);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_29880_(float partialTicks) {
        return super.m_29880_(partialTicks);
    }

    public int getSheepTimer() {
        return this.f_29802_;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == SkiesItems.pine_fruit;
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_STARDUST_RAM_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_STARDUST_RAM_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_STARDUST_RAM_DEATH;
    }

    public float m_6100_() {
        return this.m_6162_() ? (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.3f : (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 0.8f;
    }

    public StardustRamEntity getBreedOffspring(ServerLevel worldIn, AgeableMob ageable) {
        return (StardustRamEntity)SkiesEntityTypes.STARDUST_RAM.m_20615_(this.f_19853_);
    }

    public ResourceLocation m_7582_() {
        if (this.m_29875_()) {
            return this.m_6095_().m_20677_();
        }
        return BlueSkies.locate("entities/stardust_ram/" + this.m_29874_().toString());
    }

    static class EatSkyGrassGoal
    extends Goal {
        private static final Predicate<BlockState> IS_TALL_GRASS = BlockStatePredicate.m_61287_((Block)SkiesBlocks.turquoise_grass);
        private final Mob mob;
        private final Level level;
        private int eatAnimationTick;

        public EatSkyGrassGoal(Mob ram) {
            this.mob = ram;
            this.level = ram.f_19853_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (this.mob.m_217043_().m_188503_(this.mob.m_6162_() ? 50 : 1000) != 0) {
                return false;
            }
            BlockPos blockpos = this.mob.m_20183_();
            if (IS_TALL_GRASS.test(this.level.m_8055_(blockpos))) {
                return true;
            }
            return this.level.m_8055_(blockpos.m_7495_()).m_60713_(SkiesBlocks.turquoise_grass_block);
        }

        public void m_8056_() {
            this.eatAnimationTick = 40;
            this.level.m_7605_((Entity)this.mob, (byte)10);
            this.mob.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.eatAnimationTick = 0;
        }

        public boolean m_8045_() {
            return this.eatAnimationTick > 0;
        }

        public int getEatAnimationTick() {
            return this.eatAnimationTick;
        }

        public void m_8037_() {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
            if (this.eatAnimationTick == 4) {
                BlockPos blockpos = this.mob.m_20183_();
                if (IS_TALL_GRASS.test(this.level.m_8055_(blockpos))) {
                    if (ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
                        this.level.m_46961_(blockpos, false);
                    }
                    this.mob.m_8035_();
                } else {
                    BlockPos blockpos1 = blockpos.m_7495_();
                    if (this.level.m_8055_(blockpos1).m_60713_(SkiesBlocks.turquoise_grass_block)) {
                        if (ForgeEventFactory.getMobGriefingEvent((Level)this.level, (Entity)this.mob)) {
                            this.level.m_46796_(2001, blockpos1, Block.m_49956_((BlockState)SkiesBlocks.turquoise_grass_block.m_49966_()));
                            this.level.m_7731_(blockpos1, SkiesBlocks.turquoise_dirt.m_49966_(), 2);
                        }
                        this.mob.m_8035_();
                    }
                }
            }
        }
    }
}

