/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SeclamEntity
extends SkiesMonsterEntity {
    private static final UUID SHELL_ARMOR_BONUS_ID = UUID.fromString("bdf8660c-ccee-43fd-bbf2-40e7d4ddbea2");
    private static final AttributeModifier SHELL_ARMOR_BONUS_MODIFIER = new AttributeModifier(SHELL_ARMOR_BONUS_ID, "Shell armor bonus", 20.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> OPEN = SynchedEntityData.m_135353_(SeclamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> TIMES_HIT_SINCE_OPEN = SynchedEntityData.m_135353_(SeclamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> HAS_PEARL = SynchedEntityData.m_135353_(SeclamEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float prevOpenAnim;
    private float openAnim;
    public int timeSinceOpened;

    public SeclamEntity(EntityType<? extends SeclamEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22278_, (double)0.9f).m_22268_(Attributes.f_22281_, 8.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OPEN, (Object)true);
        this.f_19804_.m_135372_(TIMES_HIT_SINCE_OPEN, (Object)0);
        this.f_19804_.m_135372_(HAS_PEARL, (Object)true);
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        int height = worldIn.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)this.m_20185_(), (int)this.m_20189_());
        BlockPos newPos = new BlockPos(this.m_20185_(), (double)height, this.m_20189_());
        if (reason == MobSpawnType.NATURAL && worldIn.m_46801_(this.m_20183_().m_7495_()) && !worldIn.m_46801_(this.m_20183_())) {
            this.m_6021_(newPos.m_123341_(), worldIn.m_45772_(this.m_20191_()) ? (double)newPos.m_123342_() : (double)(newPos.m_123342_() + 5), newPos.m_123343_());
        }
        return spawnDataIn;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.prevOpenAnim = this.openAnim;
            this.openAnim = this.isOpen() ? Mth.m_14036_((float)(this.openAnim + (this.getTimesHitSinceOpen() < 3 ? 0.3f : 1.5f)), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.openAnim - 1.5f), (float)0.0f, (float)6.0f);
            if (this.m_204029_(FluidTags.f_13131_) && (this.isOpen() && this.openAnim >= 2.0f && this.openAnim <= 4.0f || this.isOpen() && this.openAnim >= 6.0f && this.f_19796_.m_188503_(10) == 0)) {
                for (int i = 0; i < (this.openAnim >= 6.0f ? 2 : 10); ++i) {
                    double dx = this.f_19796_.m_188583_() * 0.02;
                    double dy = (double)(this.f_19796_.m_188501_() * 0.5f) + this.f_19796_.m_188583_() * 0.04;
                    double dz = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)0.8f + this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_()) - (double)this.m_20205_(), this.m_20186_() + 0.5, (double)0.9f + this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_()) - (double)this.m_20205_(), dx, dy, dz);
                }
            }
        } else {
            if (this.timeSinceOpened > 0) {
                --this.timeSinceOpened;
            }
            if (this.f_19853_.m_45930_((Entity)this, 8.0) != null && this.getTimesHitSinceOpen() < 3 && this.timeSinceOpened <= 0) {
                if (this.isOpen()) {
                    this.hurtSurroundingMobs();
                }
                this.setOpen(false);
            } else {
                this.setOpen(true);
            }
            if (this.getTimesHitSinceOpen() >= 3 && this.timeSinceOpened <= 0 && this.isOpen()) {
                this.hurtSurroundingMobs();
                this.setOpen(false);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_20916_ <= 0 && this.getTimesHitSinceOpen() < 3) {
            this.setTimesHitSinceOpen((byte)(this.getTimesHitSinceOpen() + 1));
            if (this.getTimesHitSinceOpen() == 3) {
                this.timeSinceOpened = 80;
            }
        }
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.hasPearl() && this.isOpen()) {
            if (!this.f_19853_.f_46443_) {
                this.setHasPearl(false);
                this.m_19983_(new ItemStack((ItemLike)SkiesItems.pearl));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Open", this.isOpen());
        compound.m_128344_("TimeHitSinceOpen", this.getTimesHitSinceOpen());
        compound.m_128379_("HasPearl", this.hasPearl());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setOpen(compound.m_128471_("Open"));
        this.setTimesHitSinceOpen(compound.m_128445_("TimeHitSinceOpen"));
        this.setHasPearl(compound.m_128471_("HasPearl"));
    }

    public boolean isOpen() {
        return (Boolean)this.f_19804_.m_135370_(OPEN);
    }

    public void setOpen(boolean open) {
        if (this.isOpen() != open) {
            if (open) {
                if (this.m_21051_(Attributes.f_22284_).m_22109_(SHELL_ARMOR_BONUS_MODIFIER)) {
                    this.m_21051_(Attributes.f_22284_).m_22130_(SHELL_ARMOR_BONUS_MODIFIER);
                }
            } else {
                this.m_5496_(SoundEvents.f_11680_, 1.0f, this.m_6100_());
                this.setTimesHitSinceOpen((byte)0);
                if (!this.m_21051_(Attributes.f_22284_).m_22109_(SHELL_ARMOR_BONUS_MODIFIER)) {
                    this.m_21051_(Attributes.f_22284_).m_22125_(SHELL_ARMOR_BONUS_MODIFIER);
                }
            }
            this.f_19804_.m_135381_(OPEN, (Object)open);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getOpenAnimationScale(float pctIn) {
        return Mth.m_14179_((float)pctIn, (float)this.prevOpenAnim, (float)this.openAnim) / 6.0f;
    }

    public byte getTimesHitSinceOpen() {
        return (Byte)this.f_19804_.m_135370_(TIMES_HIT_SINCE_OPEN);
    }

    public void setTimesHitSinceOpen(byte times) {
        this.f_19804_.m_135381_(TIMES_HIT_SINCE_OPEN, (Object)times);
    }

    public boolean hasPearl() {
        return (Boolean)this.f_19804_.m_135370_(HAS_PEARL);
    }

    public void setHasPearl(boolean pearl) {
        this.f_19804_.m_135381_(HAS_PEARL, (Object)pearl);
    }

    private void hurtSurroundingMobs() {
        List entities = this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0));
        if (!entities.isEmpty()) {
            entities.forEach(entity -> {
                if (entity != this) {
                    this.m_7327_((Entity)entity);
                }
            });
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.hasPearl()) {
            this.m_19998_((ItemLike)SkiesItems.pearl);
        }
    }
}

