/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.construction.BagOfSpoilsBlock;
import com.legacy.blue_skies.blocks.misc.SkyWebbingBlock;
import com.legacy.blue_skies.blocks.misc.TrophyBlock;
import com.legacy.blue_skies.blocks.natural.BrewberryBushBlock;
import com.legacy.blue_skies.blocks.natural.FruitLeavesBlock;
import com.legacy.blue_skies.blocks.natural.LargeLilyPadBlock;
import com.legacy.blue_skies.blocks.natural.SkyCropBlock;
import com.legacy.blue_skies.blocks.natural.SkyDoubleCropBlock;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.loot_functions.SetArcRarity;
import com.legacy.blue_skies.data.objects.tags.SkiesItemTags;
import com.legacy.blue_skies.items.arcs.DuskArcItem;
import com.legacy.blue_skies.items.arcs.EtherealArcItem;
import com.legacy.blue_skies.items.arcs.NatureArcItem;
import com.legacy.blue_skies.items.arcs.PoisonArcItem;
import com.legacy.blue_skies.items.util.IRarityItem;
import com.legacy.blue_skies.registries.SkiesBlockEntityTypes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageProfessions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetContainerContents;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;

public class SkiesLootProv
extends LootTableProvider {
    public static final ResourceLocation GATEKEEPER_BOOK = BlueSkies.locate("chests/gatekeeper_house/book");
    public static final ResourceLocation GATEKEEPER_MOUNTAIN = BlueSkies.locate("chests/gatekeeper_house/mountain");
    public static final ResourceLocation GATEKEEPER_PLAINS = BlueSkies.locate("chests/gatekeeper_house/plains");
    public static final ResourceLocation GATEKEEPER_SNOWY = BlueSkies.locate("chests/gatekeeper_house/snowy");
    public static final ResourceLocation[] GATEKEEPER_LOOT = new ResourceLocation[]{GATEKEEPER_BOOK, GATEKEEPER_MOUNTAIN, GATEKEEPER_PLAINS, GATEKEEPER_SNOWY};
    public static final ResourceLocation BUNKER = BlueSkies.locate("chests/bunker/common");
    public static final ResourceLocation BUNKER_RARE = BlueSkies.locate("chests/bunker/rare");
    public static final ResourceLocation BLINDING_STUDY = BlueSkies.locate("chests/blinding_dungeon/study_chest");
    public static final ResourceLocation BLINDING_LIBRARY = BlueSkies.locate("chests/blinding_dungeon/library_chest");
    public static final ResourceLocation BLINDING_LIBRARY_KEY = BlueSkies.locate("chests/blinding_dungeon/library_chest_key");
    public static final ResourceLocation BLINDING_PRISON_EVERBRIGHT = BlueSkies.locate("chests/blinding_dungeon/prison_chest_everbright");
    public static final ResourceLocation BLINDING_PRISON_EVERDAWN = BlueSkies.locate("chests/blinding_dungeon/prison_chest_everdawn");
    public static final Map<String, ResourceLocation> BLINDING_LOOT = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put("study", BLINDING_STUDY);
        map.put("lib", BLINDING_LIBRARY);
        map.put("lib_key", BLINDING_LIBRARY_KEY);
        map.put("prison_eb", BLINDING_PRISON_EVERBRIGHT);
        map.put("prison_ed", BLINDING_PRISON_EVERDAWN);
    });
    public static final ResourceLocation NATURE_CHEST = BlueSkies.locate("chests/nature_dungeon/chest");
    public static final ResourceLocation NATURE_CHEST_KEY = BlueSkies.locate("chests/nature_dungeon/chest_key");
    public static final ResourceLocation POISON_CHEST = BlueSkies.locate("chests/poison_dungeon/chest");
    public static final ResourceLocation POISON_CHEST_KEY = BlueSkies.locate("chests/poison_dungeon/chest_key");
    public static final EnumMap<SkiesVillageBiomes, ResourceLocation> VILLAGE_BIOME_CHESTS = (EnumMap)Util.m_137469_(new EnumMap(SkiesVillageBiomes.class), map -> {
        for (SkiesVillageBiomes name : SkiesVillageBiomes.values()) {
            map.put(name, BlueSkies.locate("chests/village/" + name.toString()));
        }
    });
    public static final EnumMap<SkiesVillageProfessions, ResourceLocation> VILLAGE_EVERBRIGHT_PROFESSIONS = (EnumMap)Util.m_137469_(new EnumMap(SkiesVillageProfessions.class), map -> {
        for (SkiesVillageProfessions name : SkiesVillageProfessions.values()) {
            map.put(name, BlueSkies.locate("chests/village/profession/everbright/" + name.toString()));
        }
    });
    public static final EnumMap<SkiesVillageProfessions, ResourceLocation> VILLAGE_EVERDAWN_PROFESSIONS = (EnumMap)Util.m_137469_(new EnumMap(SkiesVillageProfessions.class), map -> {
        for (SkiesVillageProfessions name : SkiesVillageProfessions.values()) {
            map.put(name, BlueSkies.locate("chests/village/profession/everdawn/" + name.toString()));
        }
    });
    public static final ResourceLocation EVERBRIGHT_CAVE_SPAWNER = BlueSkies.locate("chests/cave_spawner/chest_everbright");
    public static final ResourceLocation EVERDAWN_CAVE_SPAWNER = BlueSkies.locate("chests/cave_spawner/chest_everdawn");
    public static final ResourceLocation STARGAZER_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/stargazer_gift");
    public static final ResourceLocation WRANGLER_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/wrangler_gift");
    public static final ResourceLocation SHOVELER_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/shoveler_gift");
    public static final ResourceLocation SUMMONER_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/summoner_gift");
    public static final ResourceLocation ALCHEMIST_GIFTS = BlueSkies.locate("gameplay/hero_of_the_village/alchemist_gift");
    public static final ResourceLocation SUMMONER_BAG_COMMON = BlueSkies.locate("loot_bags/summoner/common");
    public static final ResourceLocation SUMMONER_BAG_UNCOMMON = BlueSkies.locate("loot_bags/summoner/uncommon");
    public static final ResourceLocation SUMMONER_BAG_RARE = BlueSkies.locate("loot_bags/summoner/rare");
    public static final ResourceLocation ALCHEMIST_BAG_COMMON = BlueSkies.locate("loot_bags/alchemist/common");
    public static final ResourceLocation ALCHEMIST_BAG_UNCOMMON = BlueSkies.locate("loot_bags/alchemist/uncommon");
    public static final ResourceLocation ALCHEMIST_BAG_RARE = BlueSkies.locate("loot_bags/alchemist/rare");
    public static final ResourceLocation STARLIT_CRUSHER_BAG_COMMON = BlueSkies.locate("loot_bags/starlit_crusher/common");
    public static final ResourceLocation STARLIT_CRUSHER_BAG_UNCOMMON = BlueSkies.locate("loot_bags/starlit_crusher/uncommon");
    public static final ResourceLocation STARLIT_CRUSHER_BAG_RARE = BlueSkies.locate("loot_bags/starlit_crusher/rare");
    public static final ResourceLocation ARACHNARCH_BAG_COMMON = BlueSkies.locate("loot_bags/arachnarch/common");
    public static final ResourceLocation ARACHNARCH_BAG_UNCOMMON = BlueSkies.locate("loot_bags/arachnarch/uncommon");
    public static final ResourceLocation ARACHNARCH_BAG_RARE = BlueSkies.locate("loot_bags/arachnarch/rare");

    public SkiesLootProv(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new SkyBlockLoot(), (Object)LootContextParamSets.f_81421_), (Object)Pair.of(() -> new SkyEntityLoot(), (Object)LootContextParamSets.f_81415_), (Object)Pair.of(() -> new SkyChestLoot(), (Object)LootContextParamSets.f_81411_), (Object)Pair.of(LootBagLoot::new, (Object)LootContextParamSets.f_81411_), (Object)Pair.of(SkyGiftLoot::new, (Object)LootContextParamSets.f_81416_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((location, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)location, (LootTable)table));
    }

    public String m_6055_() {
        return "Blue Skies Loot Tables";
    }

    private class SkyChestLoot
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>,
    LootPoolUtil {
        private SkyChestLoot() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.gatekeeperHouse(consumer);
            this.village(consumer);
            this.frozenBunker(consumer);
            this.caveSpawner(consumer);
            this.blindingDungeon(consumer);
            this.natureDungeon(consumer);
            this.poisonDungeon(consumer);
        }

        private void gatekeeperHouse(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(GATEKEEPER_BOOK, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.basicPool((ItemLike)Items.f_42517_), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42516_, 1, 4).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42406_, 1, 2).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42676_).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.moonstone_shard, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 2).m_79707_(1))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            consumer.accept(GATEKEEPER_MOUNTAIN, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42405_, 1, 3).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42398_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42406_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Blocks.f_50000_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.cooked_monitor_tail, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42463_).m_79707_(1))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            consumer.accept(GATEKEEPER_PLAINS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42674_, 1, 3).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_41938_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42406_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_41939_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.ventium_ingot).m_79707_(1))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            consumer.accept(GATEKEEPER_SNOWY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42405_, 1, 3).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42414_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42406_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42780_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesBlocks.snowcap_pinhead, 2, 5).m_79707_(2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
        }

        private void village(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.CALMING_SKIES), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.brewberry, 1, 7).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesBlocks.polar_posy, 1, 2).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesBlocks.bluebright_sapling, 1, 2).m_79707_(5))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.BRIGHTLANDS), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.pine_fruit, 1, 7).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42452_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)SkiesBlocks.starlit_sapling, 1, 2).m_79707_(5))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.SLUSHLANDS), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42400_).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.cooked_carabeef, 1, 6).m_79707_(4), (Object)this.basicEntry((ItemLike)SkiesBlocks.snowcap_pinhead, 1, 2).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesBlocks.snowcap_mushroom_block, 1, 2).m_79707_(3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.SHADED_WOODLANDS), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.crescent_fruit, 1, 7).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesBlocks.baneful_mushroom, 1, 2).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesBlocks.dusk_sapling, 1, 2).m_79707_(5))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.SUNSET_MAPLE_FOREST), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.cooked_monitor_tail, 1, 7).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesBlocks.blaze_bud, 1, 2).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesBlocks.maple_sapling, 1, 2).m_79707_(5))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            consumer.accept(VILLAGE_BIOME_CHESTS.get((Object)SkiesVillageBiomes.CRYSTAL_DUNES), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.scalefruit, 1, 6).m_79707_(4), (Object)this.basicEntry((ItemLike)SkiesBlocks.crystal_flower, 1, 2).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesBlocks.crystallized_planks, 1, 2).m_79707_(3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            for (Pair pair : Arrays.asList(Pair.of((Object)true, VILLAGE_EVERBRIGHT_PROFESSIONS), Pair.of((Object)false, VILLAGE_EVERDAWN_PROFESSIONS))) {
                boolean everbright = (Boolean)pair.getFirst();
                EnumMap map = (EnumMap)pair.getSecond();
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.LIBRARY), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42516_, 1, 4).m_79707_(5), (Object)this.basicEntry((ItemLike)Items.f_42402_).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42498_).m_79707_(2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.TANNERY), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42408_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42463_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42407_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42462_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42450_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.FARM), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 3).m_79707_(1), (Object)this.basicEntry((ItemLike)(everbright ? SkiesItems.winter_leaf_seeds : SkiesItems.fiery_bean_seeds)).m_79707_(6), (Object)this.basicEntry((ItemLike)Items.f_42499_, 1, 4).m_79707_(4), (Object)this.basicEntry((ItemLike)(everbright ? SkiesItems.bluebright_hoe : SkiesItems.lunar_hoe)).m_79078_(this.setStick(everbright ? SkiesItems.starlit_stick : SkiesItems.dusk_stick)).m_79707_(1))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.SHEPHERD), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50041_).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50109_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50101_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50106_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50102_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.ventium_shears).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.pine_fruit : Items.f_42405_)).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)6.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.FISHER), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.municipal_monkfish : SkiesItems.horizofin_tunid)).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.grittle_flatfish : SkiesItems.charscale_moki)).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.ventium_water_bucket).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42768_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.winter_leaf_seeds : SkiesItems.fiery_bean_seeds)).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42414_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.BUTCHER), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.carabeef : SkiesItems.monitor_tail)).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.brewberry : SkiesItems.crescent_fruit)).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.venison : Items.f_42527_)).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42414_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.ARMORER), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.brewberry : SkiesItems.crescent_fruit)).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_helmet).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.CARTOGRAPHER), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42676_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42516_).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42522_).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.bluebright_stick : SkiesItems.lunar_stick)).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.FLETCHER), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42412_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42402_).m_79707_(8).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42484_).m_79707_(8).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.bluebright_stick : SkiesItems.lunar_stick)).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.WEAPONSMITH), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.diopside_gem).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.falsite_ingot : SkiesItems.horizonite_ingot)).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.brewberry : SkiesItems.crescent_fruit)).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_axe).m_79078_(this.setStick(everbright ? SkiesItems.starlit_stick : SkiesItems.dusk_stick)).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_sword).m_79078_(this.setStick(everbright ? SkiesItems.starlit_stick : SkiesItems.dusk_stick)).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_chestplate).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_helmet).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_leggings).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_boots).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Blocks.f_50080_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesBlocks.starlit_sapling : SkiesBlocks.dusk_sapling)).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? Items.f_42450_ : SkiesItems.camel_saddle)).m_79707_(3))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.TOOLSMITH), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.diopside_gem).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.falsite_ingot : SkiesItems.horizonite_ingot)).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_pickaxe).m_79078_(this.setStick(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick)).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42414_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick)).m_79707_(20).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.aquite_shovel).m_79078_(this.setStick(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick)).m_79707_(5))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.MASON), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42461_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42618_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesBlocks.turquoise_stone : SkiesBlocks.lunar_stone)).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesBlocks.turquoise_stonebrick : SkiesBlocks.lunar_stonebrick)).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? Items.f_42535_ : Items.f_42497_)).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesBlocks.taratite : SkiesBlocks.umber)).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.TEMPLE), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42451_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit)).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.soul_fragment).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.ventium_ingot).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.falsite_ingot).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.STARGAZER), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesBlocks.star_flare, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42516_, 1, 4).m_79707_(6), (Object)this.basicEntry((ItemLike)Blocks.f_50058_, 1, 2).m_79707_(4), (Object)this.basicEntry((ItemLike)SkiesItems.falsite_ingot).m_79707_(1))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.WRANGLER), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)Items.f_42655_).m_79707_(3), (Object)this.basicEntry((ItemLike)(everbright ? SkiesItems.azulfo_horn : SkiesItems.fox_pelt)).m_79707_(4), (Object)this.basicEntry((ItemLike)(everbright ? SkiesItems.pine_fruit : SkiesItems.scalefruit), 1, 2).m_79707_(6), (Object)this.basicEntry((ItemLike)Items.f_42414_).m_79707_(3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.SHOVELER), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 1, 4).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesItems.aquite_shovel).m_79078_(this.setStick(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick)).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.falsite_ingot).m_79707_(1), (Object)this.basicEntry((ItemLike)(everbright ? SkiesItems.frostbright_stick : SkiesItems.maple_stick), 1, 2).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42452_, 1, 2).m_79707_(6))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
                consumer.accept((ResourceLocation)map.get((Object)SkiesVillageProfessions.NIGHTWATCHER), this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42616_, 2, 5).m_79707_(1), (Object)this.basicEntry((ItemLike)(everbright ? SkiesItems.azulfo_horn : SkiesItems.fox_pelt)).m_79707_(3), (Object)this.basicEntry((ItemLike)SkiesItems.fox_pelt).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42401_, 1, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42414_, 1, 2).m_79707_(3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)))));
            }
        }

        private void frozenBunker(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPoolSingletonContainer.Builder<?> cabbageSeeds = this.basicEntry((ItemLike)SkiesItems.winter_leaf_seeds);
            LootPoolSingletonContainer.Builder<?> cryoRoot = this.basicEntry((ItemLike)SkiesItems.cryo_root, 1, 2);
            LootPoolSingletonContainer.Builder enchantedBook = this.basicEntry((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)12.0f)));
            LootPoolSingletonContainer.Builder<?> string = this.basicEntry((ItemLike)Items.f_42401_, 3, 5);
            consumer.accept(BUNKER, this.tableOf(this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(cabbageSeeds, cryoRoot, (Object)enchantedBook, string)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            LootPoolSingletonContainer.Builder<?> falsite = this.basicEntry((ItemLike)SkiesItems.falsite_ingot);
            LootPoolSingletonContainer.Builder<?> turquoiseGem = this.basicEntry((ItemLike)SkiesItems.aquite, 1, 3);
            LootPoolSingletonContainer.Builder<?> pyropeChestplate = this.basicEntry((ItemLike)SkiesItems.pyrope_chestplate);
            LootPoolSingletonContainer.Builder<?> packedIce = this.basicEntry((ItemLike)Items.f_42201_, 1, 4);
            LootPoolSingletonContainer.Builder enchantedBookRare = this.basicEntry((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)15.0f)));
            consumer.accept(BUNKER_RARE, this.tableOf(this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(falsite, turquoiseGem, pyropeChestplate, packedIce, (Object)enchantedBookRare)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
        }

        private void caveSpawner(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPoolSingletonContainer.Builder<?> aquite = this.basicEntry((ItemLike)SkiesItems.aquite, 1, 2);
            LootPoolSingletonContainer.Builder enchantedBook = this.basicEntry((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f)));
            LootPoolSingletonContainer.Builder<?> string = this.basicEntry((ItemLike)Items.f_42401_, 3, 5);
            LootPoolSingletonContainer.Builder<?> nameTag = this.basicEntry((ItemLike)Items.f_42656_);
            LootPoolSingletonContainer.Builder<?> saddle = this.basicEntry((ItemLike)Items.f_42450_, 0, 1);
            LootPoolSingletonContainer.Builder<?> ventium = this.basicEntry((ItemLike)SkiesItems.ventium_ingot);
            LootPoolSingletonContainer.Builder pyropePickaxeFrostbright = this.basicEntry((ItemLike)SkiesItems.pyrope_pickaxe).m_79078_(this.setStick(SkiesItems.frostbright_stick)).m_79078_(this.setDamage(45, 90));
            LootPoolSingletonContainer.Builder<?> ice = this.basicEntry((ItemLike)Blocks.f_50354_, 2, 3);
            LootPoolSingletonContainer.Builder<?> pinhead = this.basicEntry((ItemLike)SkiesBlocks.snowcap_pinhead, 3, 5);
            LootPoolSingletonContainer.Builder<?> cryoRoot = this.basicEntry((ItemLike)SkiesItems.cryo_root, 2, 3);
            consumer.accept(EVERBRIGHT_CAVE_SPAWNER, this.tableOf(this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(ventium, aquite, (Object)pyropePickaxeFrostbright, string, ice, pinhead, cryoRoot, (Object)enchantedBook, nameTag, saddle)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
            LootPoolSingletonContainer.Builder<?> horizonite = this.basicEntry((ItemLike)SkiesItems.horizonite_ingot);
            LootPoolSingletonContainer.Builder pyropePickaxeMaple = this.basicEntry((ItemLike)SkiesItems.pyrope_pickaxe).m_79078_(this.setStick(SkiesItems.maple_stick)).m_79078_(this.setDamage(45, 90));
            LootPoolSingletonContainer.Builder<?> webbing = this.basicEntry((ItemLike)SkiesBlocks.spider_webbing, 2, 3);
            LootPoolSingletonContainer.Builder<?> scalefruitSeeds = this.basicEntry((ItemLike)SkiesItems.scalefruit_seeds, 3, 5);
            consumer.accept(EVERDAWN_CAVE_SPAWNER, this.tableOf(this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(horizonite, aquite, (Object)pyropePickaxeMaple, string, webbing, scalefruitSeeds, (Object)enchantedBook, nameTag, saddle)).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)9.0f))));
        }

        private void blindingDungeon(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder blindingKey = this.basicPool((ItemLike)SkiesItems.blinding_key);
            LootPool.Builder gems = this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42517_, 2, 4).m_79707_(5), (Object)this.basicEntry((ItemLike)SkiesItems.cherry, 2, 3).m_79707_(4), (Object)this.basicEntry((ItemLike)SkiesBlocks.blinding_stone, 3, 5).m_79707_(3), (Object)this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.aquite, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.diopside_gem, 1, 2).m_79707_(1), (Object)this.basicEntry((ItemLike)SkiesItems.population_record).m_79707_(1))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f));
            consumer.accept(BLINDING_STUDY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)blindingKey, (Object)gems)));
            LootPool.Builder paper = this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42516_, 1, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(3))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)11.0f));
            LootPool.Builder book = this.basicPool((ItemLike)Items.f_42517_).m_79078_((LootItemFunction.Builder)EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)16.0f))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f));
            consumer.accept(BLINDING_LIBRARY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)paper, (Object)book)));
            LootPool.Builder libraryChest = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BLINDING_LIBRARY));
            consumer.accept(BLINDING_LIBRARY_KEY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)blindingKey, (Object)libraryChest)));
            LootPool.Builder brightBreadAndAxe = this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42406_, 1, 2).m_79707_(4), (Object)this.basicEntry((ItemLike)SkiesItems.pine_fruit, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)SkiesItems.aquite_axe).m_79078_(this.setStick(SkiesItems.bluebright_stick)).m_79078_(this.setDamage(83, 92)))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f));
            consumer.accept(BLINDING_PRISON_EVERBRIGHT, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)blindingKey, (Object)brightBreadAndAxe)));
            LootPool.Builder dawnBreadAndAxe = this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42406_, 3, 6).m_79707_(4), (Object)this.basicEntry((ItemLike)SkiesItems.scalefruit, 2, 7).m_79707_(3), (Object)this.basicEntry((ItemLike)SkiesItems.aquite_axe).m_79078_(this.setStick(SkiesItems.lunar_stick)).m_79078_(this.setDamage(84, 91)).m_79707_(2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)5.0f));
            consumer.accept(BLINDING_PRISON_EVERDAWN, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)blindingKey, (Object)dawnBreadAndAxe)));
        }

        private void natureDungeon(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(NATURE_CHEST, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesBlocks.starlit_sapling, 2, 4), this.basicEntry((ItemLike)SkiesBlocks.blush_blossom, 1, 2), this.basicEntry((ItemLike)SkiesBlocks.nature_stone, 2, 4), this.basicEntry((ItemLike)SkiesBlocks.glowing_nature_stone, 1, 2), this.basicEntry((ItemLike)SkiesItems.brewberry, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)1.0f)), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.black_brewberry, 1, 2), this.basicEntry((ItemLike)SkiesItems.pink_brewberry, 0, 1), this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2), this.basicEntry((ItemLike)SkiesItems.aquite, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.4f)), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.diopside_gem), (Object)this.basicEntry((ItemLike)SkiesItems.aquite_axe, 1, 1).m_79078_(this.setStick(SkiesItems.starlit_stick)).m_79078_(this.setDamage(85, 90)), (Object)this.basicEntry((ItemLike)SkiesItems.starlit_spear, 1, 1).m_79078_(this.setDamage(80, 85)), (Object)this.basicEntry((ItemLike)Items.f_42517_, 0, 2).m_79078_(this.enchant(15, 20)))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.1f)), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)SkiesItems.starlit_spear).m_79078_(this.enchant(15, 20)).m_79078_(this.setDamage(80, 85)), this.basicEntry((ItemLike)Items.f_42450_), this.basicEntry((ItemLike)SkiesItems.charoite))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f)))));
            consumer.accept(NATURE_CHEST_KEY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.basicPool((ItemLike)SkiesItems.nature_key), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.black_brewberry, 1, 2), this.basicEntry((ItemLike)SkiesItems.pink_brewberry, 0, 1), this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2), this.basicEntry((ItemLike)SkiesItems.aquite, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))));
        }

        private void poisonDungeon(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(POISON_CHEST, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)Items.f_42401_, 2, 3), this.basicEntry((ItemLike)SkiesBlocks.moonstone, 2, 5), this.basicEntry((ItemLike)SkiesBlocks.poison_stone, 2, 4), this.basicEntry((ItemLike)SkiesBlocks.glowing_poison_stone, 1, 2), this.basicEntry((ItemLike)SkiesItems.crescent_fruit, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)1.0f)), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)Items.f_42591_, 1, 2), this.basicEntry((ItemLike)SkiesBlocks.spider_webbing, 1, 2), this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2), this.basicEntry((ItemLike)SkiesItems.aquite, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.4f)), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.diopside_gem), this.basicEntry((ItemLike)SkiesItems.horizonite_ingot, 1, 1), (Object)this.basicEntry((ItemLike)SkiesItems.moonstone_shield, 1, 1).m_79078_(this.setDamage(65, 80)), (Object)this.basicEntry((ItemLike)Items.f_42517_, 0, 2).m_79078_(this.enchant(15, 20)))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.1f)), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)SkiesItems.aquite_sword).m_79078_(this.setStick(SkiesItems.maple_stick)).m_79078_(this.enchant(Enchantments.f_44979_)).m_79078_(this.setDamage(25, 55)), this.basicEntry((ItemLike)SkiesItems.camel_saddle), this.basicEntry((ItemLike)SkiesItems.charoite))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f)))));
            consumer.accept(POISON_CHEST_KEY, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.basicPool((ItemLike)SkiesItems.poison_key), (Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)Items.f_42591_, 1, 2), this.basicEntry((ItemLike)SkiesBlocks.spider_webbing, 1, 2), this.basicEntry((ItemLike)SkiesItems.pyrope_gem, 1, 2), this.basicEntry((ItemLike)SkiesItems.aquite, 1, 2))).m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))));
        }
    }

    private class SkyEntityLoot
    extends EntityLoot
    implements LootPoolUtil {
        private SkyEntityLoot() {
        }

        protected void addTables() {
            this.m_124371_(SkiesEntityTypes.GATEKEEPER, LootTable.m_79147_());
            this.m_124371_(SkiesEntityTypes.SUMMONER, LootTable.m_79147_());
            this.m_124371_(SkiesEntityTypes.ALCHEMIST, LootTable.m_79147_());
            this.m_124371_(SkiesEntityTypes.ARACHNARCH, LootTable.m_79147_());
            this.m_124371_(SkiesEntityTypes.STARLIT_CRUSHER, LootTable.m_79147_());
            LootPool.Builder azulfoBeef = this.lootingPool((ItemLike)SkiesItems.carabeef, 2, 3, 0, 1).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            LootPool.Builder auzlfoHorn = this.lootingPool((ItemLike)SkiesItems.azulfo_horn, -1, 2, 0, 1).m_79080_(LootItemKilledByPlayerCondition.m_81901_());
            this.m_124371_(SkiesEntityTypes.AZULFO, this.tableOf((List)ImmutableList.of((Object)azulfoBeef, (Object)auzlfoHorn)));
            LootPool.Builder rawVenison = this.lootingPool((ItemLike)SkiesItems.venison, 1, 2, 0, 1).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.REINDEER, this.tableOf(rawVenison));
            LootPool.Builder mutton = this.lootingPool((ItemLike)Items.f_42658_, 1, 2, 0, 1).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.STARDUST_RAM, this.tableOf(mutton));
            Arrays.asList(DyeColor.values()).forEach(c -> this.m_124380_(BlueSkies.locate("entities/" + this.entityName(SkiesEntityTypes.STARDUST_RAM) + "/" + c), this.ramLootTable((ItemLike)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(c + "_wool")))));
            LootPool.Builder starFlare = this.lootingPool((ItemLike)SkiesBlocks.star_flare, 0, 2, 0, 1).m_79080_(LootItemKilledByPlayerCondition.m_81901_());
            LootPool.Builder soulFragment = this.lootingPool((ItemLike)SkiesItems.soul_fragment, 0, 2, 0, 1).m_79080_(LootItemKilledByPlayerCondition.m_81901_());
            this.m_124371_(SkiesEntityTypes.FROST_SPIRIT, this.tableOf((List)ImmutableList.of((Object)starFlare, (Object)soulFragment)));
            LootPool.Builder ice = this.lootingPool((ItemLike)Items.f_41980_, 0, 2, 0, 1);
            LootPool.Builder packedIce = this.lootingPool((ItemLike)Items.f_42201_, 0, 2, 0, 1);
            this.m_124371_(SkiesEntityTypes.ARMORED_FROST_SPIRIT, this.tableOf(ice));
            this.m_124380_(BlueSkies.locate("entities/" + this.entityName(SkiesEntityTypes.ARMORED_FROST_SPIRIT) + "_packed"), this.tableOf(packedIce));
            this.m_124371_(SkiesEntityTypes.CRYNOCEROUS, this.tableOf(ice.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))));
            this.m_124380_(BlueSkies.locate("entities/" + this.entityName(SkiesEntityTypes.CRYNOCEROUS) + "_packed"), this.tableOf(packedIce.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))));
            this.m_124371_(SkiesEntityTypes.JELLY_DRIFTER, LootTable.m_79147_());
            LootPool.Builder feather = this.lootingPool((ItemLike)Items.f_42402_, 1, 2, 0, 1);
            this.m_124371_(SkiesEntityTypes.SNOW_OWL, this.tableOf(feather));
            this.m_124371_(SkiesEntityTypes.POLARGEIST, this.tableOf(soulFragment));
            LootPool.Builder glowstoneDust = this.lootingPool((ItemLike)Items.f_42525_, 0, 1, 0, 1);
            this.m_124371_(SkiesEntityTypes.FIREFLY, this.tableOf(glowstoneDust));
            LootPool.Builder bugGuts = this.lootingPool((ItemLike)SkiesItems.bug_guts, 0, 2, 0, 1);
            LootPool.Builder slimeBall = this.lootingPool((ItemLike)Items.f_42518_, 0, 1, 0, 1);
            this.m_124371_(SkiesEntityTypes.NYCTOFLY, this.tableOf((List)ImmutableList.of((Object)bugGuts, (Object)slimeBall)));
            LootPool.Builder string = this.lootingPool((ItemLike)Items.f_42401_, 0, 2, 0, 1);
            LootPool.Builder spiderEye = this.lootingPool((ItemLike)Items.f_42591_, -1, 1, 0, 1).m_79080_(LootItemKilledByPlayerCondition.m_81901_());
            this.m_124371_(SkiesEntityTypes.VENOM_SPIDER, this.tableOf((List)ImmutableList.of((Object)string, (Object)spiderEye, (Object)bugGuts)));
            LootPool.Builder fur = this.lootingPool((ItemLike)SkiesItems.fox_pelt, 1, 2, 0, 1);
            LootPool.Builder salmon = this.lootingPool((ItemLike)Items.f_42527_, -1, 1, 0, 1).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.COSMIC_FOX, this.tableOf((List)ImmutableList.of((Object)fur, (Object)salmon)));
            LootPool.Builder rawMoonstone = this.lootingPool((ItemLike)SkiesBlocks.vitreous_moonstone, 0, 2, 0, 1);
            LootPool.Builder bone = this.lootingPool((ItemLike)Items.f_42500_, 0, 2, 0, 1).m_79080_(LootItemKilledByPlayerCondition.m_81901_());
            this.m_124371_(SkiesEntityTypes.CRYSTAL_CAMEL, this.tableOf((List)ImmutableList.of((Object)rawMoonstone, (Object)bone)));
            this.m_124371_(SkiesEntityTypes.EMBERBACK, this.tableOf(bugGuts));
            LootPool.Builder monitorTail = this.lootingPool((ItemLike)SkiesItems.monitor_tail, 1, 3, 0, 1).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.SHADE_MONITOR, this.tableOf(monitorTail));
            this.m_124371_(SkiesEntityTypes.SLIV, LootTable.m_79147_());
            this.m_124371_(SkiesEntityTypes.ARTIFICIAL_GOLEM, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(SkiesItemTags.BLINDING_STONES)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))));
            this.m_124371_(SkiesEntityTypes.NESTED_SPIDER, LootTable.m_79147_());
            LootPool.Builder natureStone = this.lootingPool((ItemLike)SkiesBlocks.nature_stone, 0, 1, 0, 1);
            LootPool.Builder starlitVines = this.lootingPool((ItemLike)SkiesBlocks.starlit_vine, 0, 1, 0, 1);
            this.m_124371_(SkiesEntityTypes.STONELET, this.tableOf((List)ImmutableList.of((Object)natureStone, (Object)starlitVines)));
            this.m_124371_(SkiesEntityTypes.SPEWTER, this.tableOf(slimeBall));
            LootPool.Builder pinhead = this.lootingPool((ItemLike)SkiesBlocks.snowcap_pinhead, 0, 2, 0, 1);
            this.m_124371_(SkiesEntityTypes.SHRUMPTY, this.tableOf(pinhead));
            LootPool.Builder leather = this.lootingPool((ItemLike)Items.f_42454_, 0, 1, 0, 1);
            LootPool.Builder prowlerFish = this.lootingPool((ItemLike)SkiesItems.municipal_monkfish, 0, 1, 0, 1).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.DIOPHYDE_PROWLER, this.tableOf((List)ImmutableList.of((Object)leather, (Object)prowlerFish)));
            this.m_124371_(SkiesEntityTypes.WHISTLESHELL_CRAB, LootTable.m_79147_());
            this.m_124371_(SkiesEntityTypes.SUPPORTER_PET, LootTable.m_79147_());
            LootPool.Builder crogreBugGuts = this.lootingPool((ItemLike)SkiesItems.bug_guts, 0, 1, 0, 1);
            this.m_124371_(SkiesEntityTypes.CROGRE, this.tableOf(crogreBugGuts));
            LootPool.Builder fishBoneMeal = this.basicPool((ItemLike)Items.f_42499_).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f));
            LootPool.Builder monkfish = this.lootingPool((ItemLike)SkiesItems.municipal_monkfish, 1, 1, 0, 0).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.MUNICIPAL_MONKFISH, this.tableOf((List)ImmutableList.of((Object)monkfish, (Object)fishBoneMeal)));
            LootPool.Builder flatfish = this.lootingPool((ItemLike)SkiesItems.grittle_flatfish, 1, 1, 0, 0).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.GRITTLE_FLATFISH, this.tableOf((List)ImmutableList.of((Object)flatfish, (Object)fishBoneMeal)));
            LootPool.Builder moki = this.lootingPool((ItemLike)SkiesItems.charscale_moki, 1, 1, 0, 0).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.CHARSCALE_MOKI, this.tableOf((List)ImmutableList.of((Object)moki, (Object)fishBoneMeal)));
            this.m_124371_(SkiesEntityTypes.INFESTED_SWARMER, this.tableOf(bugGuts));
            LootPool.Builder tunid = this.lootingPool((ItemLike)SkiesItems.horizofin_tunid, 1, 1, 0, 0).m_79078_((LootItemFunction.Builder)this.smeltItem(f_124366_));
            this.m_124371_(SkiesEntityTypes.HORIZOFIN_TUNID, this.tableOf((List)ImmutableList.of((Object)tunid, (Object)fishBoneMeal)));
            this.m_124371_(SkiesEntityTypes.SECLAM, LootTable.m_79147_());
        }

        private LootTable.Builder ramLootTable(ItemLike wool) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)wool))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)SkiesEntityTypes.STARDUST_RAM.m_20677_())));
        }

        private LootPool.Builder lootingPool(ItemLike item, int min, int max, int minLooting, int maxLooting) {
            return this.basicPool(item, min, max).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)minLooting, (float)maxLooting)));
        }

        private String entityName(EntityType<?> entity) {
            return ForgeRegistries.ENTITIES.getKey(entity).m_135815_();
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(e -> ForgeRegistries.ENTITIES.getKey(e).m_135827_().contains("blue_skies"))::iterator;
        }
    }

    private class SkyBlockLoot
    extends BlockLoot
    implements LootPoolUtil {
        private final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        private final LootItemCondition.Builder SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
        private final LootItemCondition.Builder SILK_TOUCH_OR_SHEARS = this.SHEARS.m_7818_(this.SILK_TOUCH);
        private final LootItemCondition.Builder NOT_SILK_TOUCH_OR_SHEARS = this.SILK_TOUCH_OR_SHEARS.m_81807_();
        private float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        private SkyBlockLoot() {
        }

        protected void addTables() {
            this.blocks().forEach(block -> {
                if (block == SkiesBlocks.turquoise_grass) {
                    this.droppingSeedTag((Block)block, SkiesItemTags.TURQUOISE_GRASS_DROPS);
                } else if (block == SkiesBlocks.tall_turquoise_grass) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124267_((Block)SkiesBlocks.turquoise_grass, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SkyBlockLoot.m_236224_((ItemLike)b, (ConditionUserBuilder)TagEntry.m_205095_(SkiesItemTags.TURQUOISE_GRASS_DROPS))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.125f))));
                } else if (block == SkiesBlocks.lunar_grass) {
                    this.droppingSeedTag((Block)block, SkiesItemTags.LUNAR_GRASS_DROPS);
                } else if (block == SkiesBlocks.tall_lunar_grass) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124267_((Block)SkiesBlocks.lunar_grass, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)SkyBlockLoot.m_236224_((ItemLike)b, (ConditionUserBuilder)TagEntry.m_205095_(SkiesItemTags.LUNAR_GRASS_DROPS))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)b).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)))).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.125f))));
                } else if (block == SkiesBlocks.cherry_grass) {
                    this.droppingSeedTag((Block)block, SkiesItemTags.CHERRY_GRASS_DROPS);
                } else if (block == SkiesBlocks.turquoise_grass_block || block == SkiesBlocks.turquoise_cherry_grass_block) {
                    this.silkOrElse((Block)block, (ItemLike)SkiesBlocks.turquoise_dirt);
                } else if (block == SkiesBlocks.lunar_grass_block || block == SkiesBlocks.lunar_cherry_grass_block) {
                    this.silkOrElse((Block)block, (ItemLike)SkiesBlocks.lunar_dirt);
                } else if (block == SkiesBlocks.turquoise_farmland.get()) {
                    this.m_124147_((Block)block, (ItemLike)SkiesBlocks.turquoise_dirt);
                } else if (block == SkiesBlocks.lunar_farmland.get()) {
                    this.m_124147_((Block)block, (ItemLike)SkiesBlocks.lunar_dirt);
                } else if (block == SkiesBlocks.turquoise_stone) {
                    this.silkOrElse((Block)block, (ItemLike)SkiesBlocks.turquoise_cobblestone);
                } else if (block == SkiesBlocks.lunar_stone) {
                    this.silkOrElse((Block)block, (ItemLike)SkiesBlocks.lunar_cobblestone);
                } else if (block instanceof VineBlock || block == SkiesBlocks.muckweed || block == SkiesBlocks.brittlebush || block == SkiesBlocks.chillweed || block == SkiesBlocks.sea_moss || block == SkiesBlocks.crystallized_grass) {
                    this.m_124165_((Block)block, BlockLoot.m_124286_((ItemLike)block));
                } else if (block == SkiesBlocks.brumble_vine_top || block == SkiesBlocks.brumble_vine) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124126_((ItemLike)SkiesBlocks.brumble_vine_top));
                } else if (block == SkiesBlocks.bluebright_leaves) {
                    this.m_124175_((Block)block, b -> this.leaves((Block)b, (ItemLike)SkiesBlocks.bluebright_sapling, (ItemLike)SkiesItems.bluebright_stick));
                } else if (block == SkiesBlocks.starlit_leaves) {
                    this.m_124175_((Block)block, b -> this.leaves((Block)b, (ItemLike)SkiesBlocks.starlit_sapling, (ItemLike)SkiesItems.starlit_stick));
                } else if (block == SkiesBlocks.frostbright_leaves) {
                    this.m_124175_((Block)block, b -> this.leaves((Block)b, (ItemLike)SkiesBlocks.frostbright_sapling, (ItemLike)SkiesItems.frostbright_stick));
                } else if (block == SkiesBlocks.lunar_leaves) {
                    this.m_124175_((Block)block, b -> this.leaves((Block)b, (ItemLike)SkiesBlocks.lunar_sapling, (ItemLike)SkiesItems.lunar_stick));
                } else if (block == SkiesBlocks.dusk_leaves) {
                    this.m_124175_((Block)block, b -> this.leaves((Block)b, (ItemLike)SkiesBlocks.dusk_sapling, (ItemLike)SkiesItems.dusk_stick));
                } else if (block == SkiesBlocks.maple_leaves) {
                    this.m_124175_((Block)block, b -> this.leaves((Block)b, (ItemLike)SkiesBlocks.maple_sapling, (ItemLike)SkiesItems.maple_stick));
                } else if (block == SkiesBlocks.cherry_leaves) {
                    this.m_124175_((Block)block, b -> this.leavesFruit((Block)b, (ItemLike)SkiesBlocks.cherry_sapling, (ItemLike)SkiesItems.cherry_stick, (ItemLike)SkiesItems.cherry));
                } else if (block == SkiesBlocks.crescent_fruit_leaves) {
                    this.m_124175_((Block)block, b -> this.leaves((Block)SkiesBlocks.lunar_leaves, (ItemLike)SkiesBlocks.crescent_fruit_sapling, (ItemLike)SkiesItems.lunar_stick));
                } else if (block == SkiesBlocks.snowcap_mushroom) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124161_((Block)b, (Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER));
                } else if (block == SkiesBlocks.snowcap_mushroom_block) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_176042_((Block)b, (ItemLike)SkiesBlocks.snowcap_pinhead, (NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)));
                } else if (block == SkiesBlocks.snowcap_mushroom_stem) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_176042_((Block)b, (ItemLike)SkiesBlocks.snowcap_pinhead, (NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)));
                } else if (block == SkiesBlocks.brewberry_bush) {
                    this.m_124175_((Block)block, b -> (LootTable.Builder)SkyBlockLoot.m_236221_((ItemLike)b, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)SkiesBlocks.brewberry_bush).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)BrewberryBushBlock.MATURE, true))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesItems.brewberry).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)SkiesBlocks.brewberry_bush)))));
                } else if (block instanceof SkyWebbingBlock) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124283_((Block)b, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)SkyBlockLoot.m_236224_((ItemLike)b, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42401_)))));
                } else if (block instanceof ChestBlock) {
                    this.m_124165_((Block)block, BlockLoot.m_124292_((Block)block));
                } else if (block instanceof SlabBlock) {
                    this.m_124165_((Block)block, BlockLoot.m_124290_((Block)block));
                } else if (block == SkiesBlocks.crystal_glass || block == SkiesBlocks.midnight_glass || block == SkiesBlocks.crystal_glass_pane || block == SkiesBlocks.midnight_glass_pane || block == SkiesBlocks.crystallized_leaves) {
                    this.m_124272_((Block)block);
                } else if (block == SkiesBlocks.everbright_moonstone_ore || block == SkiesBlocks.everdawn_moonstone_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124168_((Block)b, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)SkyBlockLoot.m_236221_((ItemLike)b, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)SkiesItems.moonstone_shard).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))))));
                } else if (block == SkiesBlocks.everbright_pyrope_ore || block == SkiesBlocks.everdawn_pyrope_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124139_((Block)b, (Item)SkiesItems.pyrope_gem));
                } else if (block == SkiesBlocks.everbright_diopside_ore || block == SkiesBlocks.everdawn_diopside_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124139_((Block)b, (Item)SkiesItems.diopside_gem));
                } else if (block == SkiesBlocks.everbright_aquite_ore || block == SkiesBlocks.everdawn_aquite_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124139_((Block)b, (Item)SkiesItems.raw_aquite));
                } else if (block == SkiesBlocks.everbright_charoite_ore || block == SkiesBlocks.everdawn_charoite_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124139_((Block)b, (Item)SkiesItems.raw_charoite));
                } else if (block == SkiesBlocks.ventium_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124139_((Block)b, (Item)SkiesItems.raw_ventium));
                } else if (block == SkiesBlocks.falsite_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124139_((Block)b, (Item)SkiesItems.raw_falsite));
                } else if (block == SkiesBlocks.horizonite_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124139_((Block)b, (Item)SkiesItems.raw_horizonite));
                } else if (block == SkiesBlocks.everbright_emerald_ore || block == SkiesBlocks.everdawn_emerald_ore) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124139_((Block)b, (Item)Items.f_42616_));
                } else if (block == SkiesBlocks.decaying_spike) {
                    this.m_124147_((Block)block, (ItemLike)SkiesBlocks.lunar_cobblestone);
                } else if (block == SkiesBlocks.crescent_fruit) {
                    this.m_124147_((Block)block, (ItemLike)SkiesItems.crescent_fruit);
                } else if (block == SkiesBlocks.cherry_pie) {
                    this.m_124165_((Block)block, SkyBlockLoot.m_124125_());
                } else if (block instanceof DoorBlock) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124161_((Block)b, (Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
                } else if (ImmutableList.of((Object)SkiesBlocks.bluebright_bookshelf, (Object)SkiesBlocks.starlit_bookshelf, (Object)SkiesBlocks.frostbright_bookshelf, (Object)SkiesBlocks.lunar_bookshelf, (Object)SkiesBlocks.dusk_bookshelf, (Object)SkiesBlocks.maple_bookshelf, (Object)SkiesBlocks.cherry_bookshelf).contains(block)) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_176042_((Block)b, (ItemLike)Items.f_42517_, (NumberProvider)ConstantValue.m_165692_((float)3.0f)));
                } else if (block instanceof FlowerPotBlock) {
                    this.m_124252_((Block)block);
                } else if (block instanceof SkyCropBlock) {
                    LootItemBlockStatePropertyCondition.Builder growthCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)SkyCropBlock.AGE, ((SkyCropBlock)((Object)block)).m_7419_()));
                    if (block == SkiesBlocks.solnuts) {
                        this.m_124175_((Block)block, arg_0 -> this.lambda$addTables$27((LootItemCondition.Builder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.cryo_roots) {
                        this.m_124175_((Block)block, arg_0 -> this.lambda$addTables$28((LootItemCondition.Builder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.winter_leaves) {
                        this.m_124175_((Block)block, arg_0 -> this.lambda$addTables$29((LootItemCondition.Builder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.fiery_beans) {
                        this.m_124175_((Block)block, arg_0 -> this.lambda$addTables$30((LootItemCondition.Builder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.scalefruits) {
                        this.m_124175_((Block)block, arg_0 -> this.lambda$addTables$31((LootItemCondition.Builder)growthCondition, arg_0));
                    } else if (block == SkiesBlocks.pine_fruits) {
                        this.m_124175_((Block)block, arg_0 -> this.lambda$addTables$32((LootItemCondition.Builder)growthCondition, arg_0));
                    }
                } else if (block == SkiesBlocks.spider_nest) {
                    this.m_124147_((Block)block, (ItemLike)SkiesBlocks.poison_stone);
                } else if (block == SkiesBlocks.moonlit_water_lily) {
                    this.m_124175_((Block)block, b -> SkyBlockLoot.m_124161_((Block)b, LargeLilyPadBlock.CORNER, (Comparable)((Object)LargeLilyPadBlock.Corner.BOTTOM_L)));
                } else if (block instanceof TrophyBlock) {
                    this.m_124175_((Block)block, b -> this.trophy((Block)b));
                } else if (block instanceof BagOfSpoilsBlock) {
                    this.m_124175_((Block)block, b -> this.createBagOfSpoilsDrop((Block)b));
                } else {
                    this.m_124288_((Block)block);
                }
            });
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks()::iterator;
        }

        private Stream<Block> blocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> ForgeRegistries.BLOCKS.getKey(b).m_135827_().equals("blue_skies") && !b.m_60589_().equals((Object)BuiltInLootTables.f_78712_));
        }

        private void droppingSeedTag(Block block, TagKey<Item> tag) {
            this.m_124165_(block, SkyBlockLoot.m_124267_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)SkyBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)TagEntry.m_205095_(tag).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.125f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2))))));
        }

        private void silkOrElse(Block withSilk, ItemLike without) {
            this.m_124175_(withSilk, b -> SkyBlockLoot.m_124257_((Block)b, (ItemLike)without));
        }

        private LootTable.Builder leaves(Block block, ItemLike sapling, ItemLike stick) {
            return SkyBlockLoot.m_124283_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)SkyBlockLoot.m_236224_((ItemLike)block, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)sapling))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])this.DEFAULT_SAPLING_DROP_RATES))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(this.NOT_SILK_TOUCH_OR_SHEARS).m_79076_(((LootPoolSingletonContainer.Builder)SkyBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)stick).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }

        private LootTable.Builder leavesFruit(Block block, ItemLike sapling, ItemLike stick, ItemLike fruit) {
            return this.leaves(block, sapling, stick).m_79161_(this.poolOf(List.of(this.basicEntry((ItemLike)SkiesItems.cherry))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(FruitLeavesBlock.GROWTH, (Comparable)((Object)FruitLeavesBlock.Growth.GROWN)))));
        }

        private LootTable.Builder crop(LootItemCondition.Builder growthCondition, Block block, ItemLike food) {
            return this.crop(growthCondition, block, food, food);
        }

        private LootTable.Builder crop(LootItemCondition.Builder growthCondition, Block block, ItemLike food, ItemLike seed) {
            LootPool.Builder seedPool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seed).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)3).m_79080_(growthCondition)));
            LootPool.Builder foodPool = LootPool.m_79043_().m_79080_(growthCondition).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)food).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.5714286f, (int)1)));
            return (LootTable.Builder)SkyBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(seedPool).m_79161_(foodPool));
        }

        private LootTable.Builder doubleCrop(LootItemCondition.Builder growthCondition, Block block, ItemLike food, ItemLike seed) {
            LootItemBlockStatePropertyCondition.Builder topHalf = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(SkyDoubleCropBlock.HALF, (Comparable)DoubleBlockHalf.UPPER));
            LootItemBlockStatePropertyCondition.Builder lowerHalf = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(SkyDoubleCropBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            LootPool.Builder seedPool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)seed).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.2f, (int)2).m_79080_(growthCondition)));
            LootPool.Builder topPool = LootPool.m_79043_().m_79080_(growthCondition).m_79080_((LootItemCondition.Builder)topHalf).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)food).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.4f, (int)1)));
            LootPool.Builder lowerPool = LootPool.m_79043_().m_79080_(growthCondition).m_79080_((LootItemCondition.Builder)lowerHalf).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)food).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79917_((Enchantment)Enchantments.f_44987_, (float)0.2f, (int)1)));
            return (LootTable.Builder)SkyBlockLoot.m_236221_((ItemLike)block, (FunctionUserBuilder)LootTable.m_79147_().m_79161_(seedPool).m_79161_(topPool).m_79161_(lowerPool));
        }

        private LootTable.Builder trophy(Block block) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyBlockState.m_80062_((Block)block).m_80084_(TrophyBlock.TIER)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Label", "display.Name"))));
        }

        private LootTable.Builder createBagOfSpoilsDrop(Block block) {
            return LootTable.m_79147_().m_79161_((LootPool.Builder)SkyBlockLoot.m_236224_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("Lock", "BlockEntityTag.Lock").m_80279_("LootTable", "BlockEntityTag.LootTable").m_80279_("LootTableSeed", "BlockEntityTag.LootTableSeed")).m_79078_((LootItemFunction.Builder)SetContainerContents.m_193036_(SkiesBlockEntityTypes.BAG_OF_SPOILS).m_80930_((LootPoolEntryContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)BagOfSpoilsBlock.CONTENTS))))));
        }

        private /* synthetic */ LootTable.Builder lambda$addTables$32(LootItemCondition.Builder growthCondition, Block b) {
            return this.doubleCrop(growthCondition, b, (ItemLike)SkiesItems.pine_fruit, (ItemLike)SkiesItems.pine_fruit_seeds);
        }

        private /* synthetic */ LootTable.Builder lambda$addTables$31(LootItemCondition.Builder growthCondition, Block b) {
            return this.doubleCrop(growthCondition, b, (ItemLike)SkiesItems.scalefruit, (ItemLike)SkiesItems.scalefruit_seeds);
        }

        private /* synthetic */ LootTable.Builder lambda$addTables$30(LootItemCondition.Builder growthCondition, Block b) {
            return this.crop(growthCondition, b, (ItemLike)SkiesItems.fiery_beans, (ItemLike)SkiesItems.fiery_bean_seeds);
        }

        private /* synthetic */ LootTable.Builder lambda$addTables$29(LootItemCondition.Builder growthCondition, Block b) {
            return this.crop(growthCondition, b, (ItemLike)SkiesItems.winter_leaves, (ItemLike)SkiesItems.winter_leaf_seeds);
        }

        private /* synthetic */ LootTable.Builder lambda$addTables$28(LootItemCondition.Builder growthCondition, Block b) {
            return this.crop(growthCondition, b, (ItemLike)SkiesItems.cryo_root);
        }

        private /* synthetic */ LootTable.Builder lambda$addTables$27(LootItemCondition.Builder growthCondition, Block b) {
            return this.crop(growthCondition, b, (ItemLike)SkiesItems.solnut);
        }
    }

    public static interface LootPoolUtil {
        default public LootTable.Builder tableOf(List<LootPool.Builder> pools) {
            LootTable.Builder table = LootTable.m_79147_();
            pools.forEach(pool -> table.m_79161_(pool));
            return table;
        }

        default public LootTable.Builder tableOf(LootPool.Builder pool) {
            return LootTable.m_79147_().m_79161_(pool);
        }

        default public LootPool.Builder basicPool(ItemLike item, int min, int max) {
            return LootPool.m_79043_().m_79076_(this.basicEntry(item, min, max));
        }

        default public LootPool.Builder basicPool(ItemLike item) {
            return LootPool.m_79043_().m_79076_(this.basicEntry(item));
        }

        default public LootPool.Builder randItemPool(List<ItemLike> items) {
            return this.poolOf(items.stream().map(i -> this.basicEntry((ItemLike)i)).collect(Collectors.toList()));
        }

        default public LootPool.Builder poolOf(List<LootPoolEntryContainer.Builder<?>> lootEntries) {
            LootPool.Builder pool = LootPool.m_79043_();
            lootEntries.forEach(entry -> pool.m_79076_(entry));
            return pool;
        }

        default public LootPoolSingletonContainer.Builder<?> basicEntry(ItemLike item, int min, int max) {
            return this.basicEntry(item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)));
        }

        default public LootPoolSingletonContainer.Builder<?> basicEntry(ItemLike item) {
            return LootItem.m_79579_((ItemLike)item);
        }

        default public LootItemConditionalFunction.Builder<?> setStick(Item stick) {
            return this.setNbt(nbt -> nbt.m_128359_("Stick", BlueSkiesData.TOOL_HANDLE_TYPES.getHandle(stick).getName()));
        }

        default public LootItemConditionalFunction.Builder<?> setDamage(int min, int max) {
            return SetItemDamageFunction.m_165430_((NumberProvider)UniformGenerator.m_165780_((float)((float)min / 100.0f), (float)((float)max / 100.0f)));
        }

        default public LootItemConditionalFunction.Builder<?> smeltItem(EntityPredicate.Builder predicate) {
            return SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)predicate));
        }

        default public LootItemConditionalFunction.Builder<?> enchant(int minLevel, int maxLevel) {
            return EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)minLevel, (float)maxLevel));
        }

        default public LootItemConditionalFunction.Builder<?> enchant(Enchantment ... enchantments) {
            EnchantRandomlyFunction.Builder func = new EnchantRandomlyFunction.Builder();
            for (Enchantment enchantment : enchantments) {
                func.m_80444_(enchantment);
            }
            return func;
        }

        default public LootItemConditionalFunction.Builder<?> setNbt(Consumer<CompoundTag> nbt) {
            return SetNbtFunction.m_81187_((CompoundTag)((CompoundTag)Util.m_137469_((Object)new CompoundTag(), nbt)));
        }
    }

    public static class SkyGiftLoot
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>,
    LootPoolUtil {
        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(STARGAZER_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)SkiesBlocks.star_flare, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)Blocks.f_50058_, 1, 2).m_79707_(3), (Object)this.basicEntry((ItemLike)SkiesItems.falsite_ingot).m_79707_(1))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))));
            consumer.accept(WRANGLER_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)SkiesItems.brewberry, 3, 4).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.crescent_fruit, 2, 3).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.azulfo_horn, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.fox_pelt, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)Items.f_42655_, 1, 3).m_79707_(1))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))));
            consumer.accept(SHOVELER_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42452_, 4, 6).m_79707_(3), (Object)this.basicEntry((ItemLike)SkiesItems.falsite_ingot, 1, 2).m_79707_(2), (Object)this.basicEntry((ItemLike)SkiesItems.aquite_shovel).m_79078_(this.setStick(SkiesItems.bluebright_stick)).m_79707_(1))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))));
            consumer.accept(SUMMONER_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)SkiesItems.soul_fragment, 2, 3).m_79707_(3), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79707_(2))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))));
            consumer.accept(ALCHEMIST_GIFTS, this.tableOf((List<LootPool.Builder>)ImmutableList.of((Object)this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42587_, 2, 4).m_79707_(6), (Object)this.basicEntry((ItemLike)Items.f_42593_, 1, 2).m_79707_(4), (Object)this.basicEntry((ItemLike)Items.f_42417_).m_79707_(1))).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))));
        }
    }

    public static class LootBagLoot
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>,
    LootPoolUtil {
        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            this.summoner(consumer);
            this.alchemist(consumer);
            this.starlitCrusher(consumer);
            this.arachnarch(consumer);
        }

        private void summoner(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            EtherealArcItem arc = SkiesItems.ethereal_arc;
            Supplier<LootPool.Builder> common = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)Items.f_42616_, 1, 2), this.basicEntry((ItemLike)SkiesItems.soul_fragment, 1, 2), this.basicEntry((ItemLike)SkiesItems.moonstone_shard, 2, 4), this.basicEntry((ItemLike)SkiesItems.aquite, 1, 2)));
            Supplier<LootPool.Builder> uncommon = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesBlocks.summoning_table), this.basicEntry((ItemLike)SkiesBlocks.star_flare, 1, 2), this.basicEntry((ItemLike)SkiesItems.blinding_rage_record), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79078_(this.enchant(15, 20))));
            Supplier<LootPool.Builder> rare = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.summoning_tome), this.basicEntry((ItemLike)SkiesItems.falsite_ingot, 1, 4), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79078_(this.enchant(Enchantments.f_44961_))));
            consumer.accept(SUMMONER_BAG_COMMON, this.makeBagTable(IRarityItem.SkiesRarity.COMMON, arc, common, uncommon, rare, new ItemLike[]{SkiesItems.soulbound_spear}));
            consumer.accept(SUMMONER_BAG_UNCOMMON, this.makeBagTable(IRarityItem.SkiesRarity.UNCOMMON, arc, common, uncommon, rare, new ItemLike[]{SkiesItems.soulbound_spear}));
            consumer.accept(SUMMONER_BAG_RARE, this.makeBagTable(IRarityItem.SkiesRarity.RARE, arc, common, uncommon, rare, new ItemLike[]{SkiesItems.soulbound_spear}));
        }

        private void alchemist(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            DuskArcItem arc = SkiesItems.dusk_arc;
            Supplier<LootPool.Builder> common = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)Items.f_42616_, 1, 2), this.basicEntry((ItemLike)SkiesItems.ventium_ingot, 1, 2), this.basicEntry((ItemLike)SkiesItems.moonstone_shard, 2, 4), this.basicEntry((ItemLike)SkiesItems.aquite, 1, 2)));
            Supplier<LootPool.Builder> uncommon = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesBlocks.alchemy_table), this.basicEntry((ItemLike)SkiesBlocks.star_flare, 1, 2), this.basicEntry((ItemLike)SkiesItems.blinding_rage_record), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79078_(this.enchant(15, 20))));
            Supplier<LootPool.Builder> rare = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.alchemy_scroll), this.basicEntry((ItemLike)SkiesItems.horizonite_ingot, 1, 4), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79078_(this.enchant(Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_))));
            consumer.accept(ALCHEMIST_BAG_COMMON, this.makeBagTable(IRarityItem.SkiesRarity.COMMON, arc, common, uncommon, rare, new ItemLike[]{SkiesItems.spike_shield}));
            consumer.accept(ALCHEMIST_BAG_UNCOMMON, this.makeBagTable(IRarityItem.SkiesRarity.UNCOMMON, arc, common, uncommon, rare, new ItemLike[]{SkiesItems.spike_shield}));
            consumer.accept(ALCHEMIST_BAG_RARE, this.makeBagTable(IRarityItem.SkiesRarity.RARE, arc, common, uncommon, rare, new ItemLike[]{SkiesItems.spike_shield}));
        }

        private void starlitCrusher(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            NatureArcItem arc = SkiesItems.nature_arc;
            Supplier<LootPool.Builder> common = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesBlocks.starlit_log, 5, 10), this.basicEntry((ItemLike)SkiesItems.winter_leaves, 2, 5), this.basicEntry((ItemLike)SkiesBlocks.cherry_sapling, 2, 4), this.basicEntry((ItemLike)SkiesItems.aquite, 2, 4)));
            Supplier<LootPool.Builder> uncommon = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.cryo_root, 1, 3), this.basicEntry((ItemLike)SkiesItems.falsite_ingot, 2, 5), this.basicEntry((ItemLike)SkiesItems.defying_starlight_record), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79078_(this.enchant(20, 28))));
            Supplier<LootPool.Builder> rare = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.crushing_hammer), this.basicEntry((ItemLike)SkiesItems.diopside_gem, 2, 3), this.basicEntry((ItemLike)Items.f_42450_)));
            consumer.accept(STARLIT_CRUSHER_BAG_COMMON, this.makeBagTable(IRarityItem.SkiesRarity.COMMON, arc, common, uncommon, rare, new ItemLike[0]));
            consumer.accept(STARLIT_CRUSHER_BAG_UNCOMMON, this.makeBagTable(IRarityItem.SkiesRarity.UNCOMMON, arc, common, uncommon, rare, new ItemLike[0]));
            consumer.accept(STARLIT_CRUSHER_BAG_RARE, this.makeBagTable(IRarityItem.SkiesRarity.RARE, arc, common, uncommon, rare, new ItemLike[0]));
        }

        private void arachnarch(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            PoisonArcItem arc = SkiesItems.poison_arc;
            Supplier<LootPool.Builder> common = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)Items.f_42401_, 5, 10), this.basicEntry((ItemLike)SkiesBlocks.spider_webbing, 2, 5), this.basicEntry((ItemLike)Items.f_42591_, 2, 4), this.basicEntry((ItemLike)SkiesItems.aquite, 2, 4)));
            Supplier<LootPool.Builder> uncommon = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)Items.f_42736_).m_79078_(this.setNbt(nbt -> nbt.m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)Potions.f_43585_).toString()))), this.basicEntry((ItemLike)SkiesItems.horizonite_ingot, 2, 3), this.basicEntry((ItemLike)SkiesItems.venomous_encounter_record), (Object)this.basicEntry((ItemLike)Items.f_42517_).m_79078_(this.enchant(20, 28))));
            Supplier<LootPool.Builder> rare = () -> this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of(this.basicEntry((ItemLike)SkiesItems.venom_sac), this.basicEntry((ItemLike)SkiesItems.diopside_gem, 2, 3), this.basicEntry((ItemLike)SkiesItems.different_sword)));
            consumer.accept(ARACHNARCH_BAG_COMMON, this.makeBagTable(IRarityItem.SkiesRarity.COMMON, arc, common, uncommon, rare, new ItemLike[0]));
            consumer.accept(ARACHNARCH_BAG_UNCOMMON, this.makeBagTable(IRarityItem.SkiesRarity.UNCOMMON, arc, common, uncommon, rare, new ItemLike[0]));
            consumer.accept(ARACHNARCH_BAG_RARE, this.makeBagTable(IRarityItem.SkiesRarity.RARE, arc, common, uncommon, rare, new ItemLike[0]));
        }

        private LootTable.Builder makeBagTable(IRarityItem.SkiesRarity rarity, Item arc, Supplier<LootPool.Builder> common, Supplier<LootPool.Builder> uncommon, Supplier<LootPool.Builder> rare, ItemLike ... guaranteedItems) {
            float uncommonChance;
            int maxUncommonRolls;
            boolean minUncommonRolls;
            int maxCommonRolls;
            int minCommonRolls;
            float rareChance = switch (rarity) {
                case IRarityItem.SkiesRarity.COMMON -> {
                    minCommonRolls = 3;
                    maxCommonRolls = 6;
                    minUncommonRolls = false;
                    maxUncommonRolls = 2;
                    uncommonChance = 0.6f;
                    yield 0.0f;
                }
                case IRarityItem.SkiesRarity.UNCOMMON -> {
                    minCommonRolls = 2;
                    maxCommonRolls = 5;
                    minUncommonRolls = true;
                    maxUncommonRolls = 3;
                    uncommonChance = 0.85f;
                    yield 0.25f;
                }
                default -> {
                    minCommonRolls = 1;
                    maxCommonRolls = 4;
                    minUncommonRolls = true;
                    maxUncommonRolls = 3;
                    uncommonChance = 1.0f;
                    yield 0.5f;
                }
            };
            ArrayList<LootPool.Builder> pools = new ArrayList<LootPool.Builder>();
            pools.add(this.poolOf((List<LootPoolEntryContainer.Builder<?>>)ImmutableList.of((Object)this.basicEntry((ItemLike)arc).m_79078_(SetArcRarity.setRarity(rarity)))));
            for (ItemLike item : guaranteedItems) {
                pools.add(this.basicPool(item));
            }
            if (maxCommonRolls > 0) {
                pools.add(common.get().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)minCommonRolls, (float)maxCommonRolls)));
            }
            if (maxUncommonRolls > 0) {
                pools.add(uncommon.get().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)((float)minUncommonRolls), (float)maxUncommonRolls)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)uncommonChance)));
            }
            if (rareChance > 0.0f) {
                pools.add(rare.get().m_79080_(LootItemRandomChanceCondition.m_81927_((float)rareChance)));
            }
            return this.tableOf(pools);
        }
    }
}

