/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.alchemy.AlchemyRecipe;
import com.legacy.blue_skies.data.objects.alchemy.CatylistRecipe;
import com.legacy.blue_skies.data.objects.alchemy.TransmuteRecipe;
import com.legacy.blue_skies.data.objects.tags.SkiesItemTags;
import com.legacy.blue_skies.data.providers.SkiesDataProvider;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class AlchemyRecipeProv
extends SkiesDataProvider<AlchemyRecipe> {
    public AlchemyRecipeProv(DataGenerator generator) {
        super(generator, AlchemyRecipe.getDirectory());
    }

    @Override
    protected Map<ResourceLocation, AlchemyRecipe> gatherData() {
        HashMap<ResourceLocation, AlchemyRecipe> registry = new HashMap<ResourceLocation, AlchemyRecipe>();
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("banner").withTag((TagKey<Item>)ItemTags.f_13191_));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("bed").withTag((TagKey<Item>)ItemTags.f_13146_).resultBlacklist("good_nights_sleep", "luxurious_bed", "wretched_bed", "strange_bed"));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("carpet").withTag((TagKey<Item>)ItemTags.f_215867_));
        AlchemyRecipeProv.colored(registry, "concrete");
        AlchemyRecipeProv.colored(registry, "concrete_powder");
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("dye").withTag((TagKey<Item>)Tags.Items.DYES));
        AlchemyRecipeProv.colored(registry, "glazed_terracotta");
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("stained_glass").withTag((TagKey<Item>)Tags.Items.STAINED_GLASS));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("stained_glass_pane").withTag((TagKey<Item>)Tags.Items.STAINED_GLASS_PANES));
        AlchemyRecipeProv.colored(registry, "terracotta");
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("wool").withTag((TagKey<Item>)ItemTags.f_13167_));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("candle").withTag((TagKey<Item>)ItemTags.f_144319_));
        AlchemyRecipeProv.coral(registry, "coral_block", "%s_coral_block");
        AlchemyRecipeProv.coral(registry, "coral", "%s_coral");
        AlchemyRecipeProv.coral(registry, "coral_fan", "%s_coral_fan");
        AlchemyRecipeProv.coral(registry, "dead_coral_block", "dead_%s_coral_block");
        AlchemyRecipeProv.coral(registry, "dead_coral", "dead_%s_coral");
        AlchemyRecipeProv.coral(registry, "dead_coral_fan", "dead_%s_coral_fan");
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("log").withTag((TagKey<Item>)ItemTags.f_13181_).resultBlacklist("botania", "livingwood_log", "stripped_livingwood_log", "glimmering_livingwood_log", "glimmering_stripped_livingwood_log", "livingwood", "stripped_livingwood", "glimmering_livingwood", "glimmering_stripped_livingwood", "dreamwood_log", "stripped_dreamwood_log", "glimmering_dreamwood_log", "glimmering_stripped_dreamwood_log", "dreamwood", "stripped_dreamwood", "glimmering_dreamwood", "glimmering_stripped_dreamwood"));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("planks").withTag((TagKey<Item>)ItemTags.f_13168_).resultBlacklist("botania", "livingwood_planks", "mossy_livingwood_planks", "dreamwood_planks", "mossy_dreamwood_planks"));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("sapling").withTag((TagKey<Item>)ItemTags.f_13180_));
        AlchemyRecipeProv.netherWood(registry, "stem", "%s_stem");
        AlchemyRecipeProv.netherWood(registry, "hyphae", "%s_hyphae");
        AlchemyRecipeProv.netherWood(registry, "stripped_stem", "stripped_%s_stem");
        AlchemyRecipeProv.netherWood(registry, "stripped_hyphae", "stripped_%s_hyphae");
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("iron").items(new ItemLike[]{Items.f_42416_, SkiesItems.ventium_ingot}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("dust").items(new ItemLike[]{Items.f_42451_, Items.f_42525_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("stone").items(new ItemLike[]{Items.f_41905_, Items.f_41958_, Items.f_42170_, Items.f_42064_, SkiesBlocks.turquoise_stone, SkiesBlocks.lunar_stone, SkiesBlocks.taratite, SkiesBlocks.umber, SkiesBlocks.rimestone, SkiesBlocks.cinderstone}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("cobblestone").items(new ItemLike[]{Items.f_42594_, SkiesBlocks.turquoise_cobblestone, SkiesBlocks.lunar_cobblestone}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("nether_stone").items(new ItemLike[]{Items.f_42048_, Items.f_42755_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("dirt").items(new ItemLike[]{Items.f_42329_, Items.f_42382_, SkiesBlocks.turquoise_dirt, SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.coarse_lunar_dirt}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("grass_block").items(new ItemLike[]{Items.f_42276_, SkiesBlocks.turquoise_grass_block, SkiesBlocks.lunar_grass_block, SkiesBlocks.turquoise_cherry_grass_block, SkiesBlocks.lunar_cherry_grass_block}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("grass").items(new ItemLike[]{Items.f_41864_, SkiesBlocks.turquoise_grass, SkiesBlocks.lunar_grass, SkiesBlocks.cherry_grass}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("sand").withTag((TagKey<Item>)Tags.Items.SAND).items(new ItemLike[]{SkiesBlocks.midnight_sand, SkiesBlocks.crystal_sand}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("glass").withTag((TagKey<Item>)Tags.Items.GLASS_COLORLESS).items(new ItemLike[]{SkiesBlocks.midnight_glass, SkiesBlocks.crystal_glass}).resultBlacklist(new ItemLike[]{Items.f_151011_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("glass_pane").withTag((TagKey<Item>)Tags.Items.GLASS_PANES_COLORLESS).items(new ItemLike[]{SkiesBlocks.midnight_glass_pane, SkiesBlocks.crystal_glass_pane}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("soul_sand").items(new ItemLike[]{Items.f_42049_, Items.f_42050_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("gourd").items(new ItemLike[]{Items.f_42028_, Items.f_42046_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("coal").withTag((TagKey<Item>)ItemTags.f_13160_));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("cobweb").items(new ItemLike[]{Items.f_41863_, SkiesBlocks.spider_webbing}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("vine").withTag(SkiesItemTags.VINES).items(new ItemLike[]{Items.f_42029_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("nether_vine").items(new ItemLike[]{Items.f_41907_, Items.f_41908_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("lily_pad").items(new ItemLike[]{Items.f_42094_, SkiesBlocks.chilled_lily_pad, SkiesBlocks.moonlit_water_lily}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("mushroom").items(new ItemLike[]{Items.f_41953_, Items.f_41952_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("brick").items(new ItemLike[]{Items.f_42460_, Items.f_42691_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("bricks").items(new ItemLike[]{Items.f_41995_, Items.f_42095_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("dripstone").items(new ItemLike[]{SkiesBlocks.turquoise_dripstone, SkiesBlocks.lunar_dripstone}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("crystal").items(new ItemLike[]{SkiesBlocks.moonstone_crystal, SkiesBlocks.sunstone_crystal}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("nether_fungus").items(new ItemLike[]{Items.f_41954_, Items.f_41955_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("nether_roots").items(new ItemLike[]{Items.f_41956_, Items.f_41957_, Items.f_41906_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("nylium").items(new ItemLike[]{Items.f_42488_, Items.f_42541_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("wart_block").items(new ItemLike[]{Items.f_42259_, Items.f_42260_}));
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder("dungeon_stone").items(new ItemLike[]{SkiesBlocks.blinding_stone, SkiesBlocks.nature_stone, SkiesBlocks.poison_stone}));
        AlchemyRecipeProv.catylist(registry, "horizonite_from_iron", (ItemLike)Items.f_42416_, (ItemLike)Items.f_42585_, new ItemLike[]{SkiesItems.horizonite_ingot});
        AlchemyRecipeProv.catylist(registry, "falsite_from_iron", (ItemLike)Items.f_42416_, (ItemLike)SkiesItems.soul_fragment, new ItemLike[]{SkiesItems.falsite_ingot});
        AlchemyRecipeProv.catylist(registry, "netherrack_from_stone", (ItemLike)Items.f_41905_, (ItemLike)Items.f_42588_, new ItemLike[]{Items.f_42048_});
        AlchemyRecipeProv.catylist(registry, "end_stone_from_stone", (ItemLike)Items.f_41905_, (ItemLike)Items.f_42730_, new ItemLike[]{Items.f_42102_});
        AlchemyRecipeProv.catylist(registry, "grass_block_from_dirt", (ItemLike)Items.f_42329_, (ItemLike)Items.f_42499_, new ItemLike[]{Items.f_42276_});
        AlchemyRecipeProv.catylist(registry, "turquoise_grass_block_from_dirt", (ItemLike)SkiesBlocks.turquoise_dirt, (ItemLike)Items.f_42499_, new ItemLike[]{SkiesBlocks.turquoise_grass_block});
        AlchemyRecipeProv.catylist(registry, "lunar_grass_block_from_dirt", (ItemLike)SkiesBlocks.lunar_dirt, (ItemLike)Items.f_42499_, new ItemLike[]{SkiesBlocks.lunar_grass_block});
        AlchemyRecipeProv.catylist(registry, "crimson_nylium_from_netherrack", (ItemLike)Items.f_42048_, (ItemLike)Items.f_41954_, new ItemLike[]{Items.f_42488_});
        AlchemyRecipeProv.catylist(registry, "warped_nylium_from_netherrack", (ItemLike)Items.f_42048_, (ItemLike)Items.f_41955_, new ItemLike[]{Items.f_42541_});
        AlchemyRecipeProv.catylist(registry, "lunar_mud_from_dirt", (ItemLike)SkiesBlocks.lunar_dirt, (ItemLike)Items.f_42518_, new ItemLike[]{SkiesBlocks.lunar_mud});
        AlchemyRecipeProv.catylist(registry, "soul_sand_from_sand", (ItemLike)Items.f_41830_, (ItemLike)SkiesItems.soul_fragment, new ItemLike[]{Items.f_42049_});
        AlchemyRecipeProv.catylist(registry, "soul_soil_from_dirt", (ItemLike)Items.f_42329_, (ItemLike)SkiesItems.soul_fragment, new ItemLike[]{Items.f_42050_});
        AlchemyRecipeProv.catylist(registry, "blinding_stone_from_ethereal_arc", (ItemLike)SkiesBlocks.turquoise_stone, (ItemLike)SkiesItems.ethereal_arc, new ItemLike[]{SkiesBlocks.blinding_stone});
        AlchemyRecipeProv.catylist(registry, "blinding_stone_from_dusk_arc", (ItemLike)SkiesBlocks.lunar_stone, (ItemLike)SkiesItems.dusk_arc, new ItemLike[]{SkiesBlocks.blinding_stone});
        AlchemyRecipeProv.catylist(registry, "nature_stone_from_arc", (ItemLike)SkiesBlocks.turquoise_stone, (ItemLike)SkiesItems.nature_arc, new ItemLike[]{SkiesBlocks.nature_stone});
        AlchemyRecipeProv.catylist(registry, "poison_stone_from_arc", (ItemLike)SkiesBlocks.lunar_stone, (ItemLike)SkiesItems.poison_arc, new ItemLike[]{SkiesBlocks.poison_stone});
        AlchemyRecipeProv.catylist(registry, "gold_lol", (ItemLike)Items.f_42418_, (ItemLike)Items.f_42589_, new ItemLike[]{Items.f_42417_});
        return registry;
    }

    private static void transmute(Map<ResourceLocation, AlchemyRecipe> registry, TransmuteRecipe.Builder builder) {
        registry.put(BlueSkies.locate(builder.getName()), builder.build());
    }

    private static void catylist(Map<ResourceLocation, AlchemyRecipe> registry, String name, ItemLike input, ItemLike catylist, ItemLike ... outputs) {
        registry.put(BlueSkies.locate(name), new CatylistRecipe(input.m_5456_(), catylist.m_5456_(), Arrays.stream(outputs).map(ItemLike::m_5456_).collect(Collectors.toList()), false));
    }

    private static void colored(Map<ResourceLocation, AlchemyRecipe> registry, String name) {
        ArrayList<ItemLike> items = new ArrayList<ItemLike>();
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation itemName = new ResourceLocation(color.m_7912_() + "_" + name);
            if (ForgeRegistries.ITEMS.containsKey(itemName)) {
                items.add((ItemLike)ForgeRegistries.ITEMS.getValue(itemName));
                continue;
            }
            LOGGER.warn("No item exists for {}", (Object)itemName.toString());
        }
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder(name).items(items));
    }

    private static void coral(Map<ResourceLocation, AlchemyRecipe> registry, String name, String format) {
        ArrayList<ItemLike> items = new ArrayList<ItemLike>();
        for (String coral : Arrays.asList("tube", "brain", "bubble", "fire", "horn")) {
            ResourceLocation itemName = new ResourceLocation(String.format(format, coral));
            if (ForgeRegistries.ITEMS.containsKey(itemName)) {
                items.add((ItemLike)ForgeRegistries.ITEMS.getValue(itemName));
                continue;
            }
            LOGGER.warn("No item exists for {}", (Object)itemName.toString());
        }
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder(name).items(items));
    }

    private static void netherWood(Map<ResourceLocation, AlchemyRecipe> registry, String name, String format) {
        ArrayList<ItemLike> items = new ArrayList<ItemLike>();
        for (String coral : Arrays.asList("crimson", "warped")) {
            ResourceLocation itemName = new ResourceLocation(String.format(format, coral));
            if (ForgeRegistries.ITEMS.containsKey(itemName)) {
                items.add((ItemLike)ForgeRegistries.ITEMS.getValue(itemName));
                continue;
            }
            LOGGER.warn("No item exists for {}", (Object)itemName.toString());
        }
        AlchemyRecipeProv.transmute(registry, TransmuteRecipe.builder(name).items(items));
    }
}

