/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.entities.hostile.boss;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.client.init.SkiesRenderRefs;
import com.legacy.blue_skies.client.models.entities.hostile.boss.StarlitCrusherModel;
import com.legacy.blue_skies.client.renders.entities.layers.EmissiveRenderLayer;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarlitCrusherRenderer<T extends StarlitCrusherEntity>
extends MobRenderer<T, StarlitCrusherModel<T>> {
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/entity/starlit_crusher/starlit_crusher.png");
    private static final ResourceLocation TEXTURE_XMAS = BlueSkies.locate("textures/entity/starlit_crusher/starlit_crusher_xmas.png");
    private static final ResourceLocation TEXTURE_XMAS_GLOW = BlueSkies.locate("textures/entity/starlit_crusher/starlit_crusher_xmas_glow.png");

    public StarlitCrusherRenderer(EntityRendererProvider.Context context) {
        super(context, new StarlitCrusherModel(context.m_174023_(SkiesRenderRefs.STARLIT_CRUSHER)), 1.6f);
        this.m_115326_(new EmissiveRenderLayer<T, StarlitCrusherModel<T>>((RenderLayerParent)this, TEXTURE_XMAS_GLOW){

            @Override
            protected boolean shouldRenderOverlay(T entity) {
                return BlueSkiesConfig.COMMON.isChristmas();
            }
        });
    }

    public Vec3 getRenderOffset(T entityIn, float partialTicks) {
        if (((StarlitCrusherEntity)entityIn).getDeathTicks() > 0) {
            return new Vec3(((StarlitCrusherEntity)entityIn).f_19853_.f_46441_.m_188583_() * 0.02, (double)(-((float)((StarlitCrusherEntity)entityIn).getDeathTicks() * 0.04f)), ((StarlitCrusherEntity)entityIn).f_19853_.f_46441_.m_188583_() * 0.02);
        }
        return super.m_7860_(entityIn, partialTicks);
    }

    protected void scale(T entitylivingbaseIn, PoseStack matrixStackIn, float partialTicks) {
        matrixStackIn.m_85841_(1.4f, 1.4f, 1.4f);
    }

    protected float getFlipDegrees(T entityLivingBaseIn) {
        return 0.0f;
    }

    protected void setupRotations(T entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        if (((StarlitCrusherEntity)entityLiving).isSpinning()) {
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(((float)((StarlitCrusherEntity)entityLiving).f_19797_ + partialTicks) * -60.0f));
        }
    }

    public ResourceLocation getTextureLocation(StarlitCrusherEntity entity) {
        return BlueSkiesConfig.COMMON.isChristmas() ? TEXTURE_XMAS : TEXTURE;
    }
}

