/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.client.gui.screen.journal.BlueJournalStartScreen;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalBackButton;
import com.legacy.blue_skies.client.gui.screen.journal.widgets.JournalPageButton;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.c_to_s.OpenInventoryPacket;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;

public abstract class BlueJournalScreen
extends Screen {
    public static final ResourceLocation PAGE_LEFT = BlueSkies.locate("textures/gui/journal/page_left.png");
    public static final ResourceLocation PAGE_RIGHT = BlueSkies.locate("textures/gui/journal/page_right.png");
    public static final ResourceLocation WIDGETS = BlueSkies.locate("textures/gui/journal/widgets.png");
    public static final ResourceLocation DISPLAY_FRAME = BlueSkies.locate("textures/gui/journal/display_frame.png");
    private static final Component SCREEN_NAME = Component.m_237119_();
    private static final int[] CODE = new int[]{265, 265, 264, 264, 263, 262, 263, 262, 66, 65};
    private int codeIndex = 0;
    private boolean showCode = false;
    private static int codeX = 0;
    private static int codeY = 0;
    public static int translateX = 0;
    public static int translateY = 0;
    private static int codeMotionX = 1;
    private static int codeMotionY = 1;
    public static BlueJournalScreen savedScreen = null;
    private static boolean openInventoryOnBackButton = false;
    protected final BlueJournalScreen previousScreen;
    protected int totalPages = 0;
    protected int page = 0;
    protected JournalBackButton backButton;
    protected JournalPageButton prevPageButton;
    protected JournalPageButton nextPageButton;

    public BlueJournalScreen(@Nullable BlueJournalScreen previousScreen) {
        super(SCREEN_NAME);
        this.previousScreen = previousScreen;
        this.codeIndex = previousScreen != null ? previousScreen.codeIndex : 0;
        this.showCode = previousScreen != null ? previousScreen.showCode : false;
    }

    protected void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        super.m_7856_();
        int middleX = this.f_96543_ / 2;
        int middleY = this.f_96544_ / 2;
        this.loadData();
        this.backButton = (JournalBackButton)this.m_142416_((GuiEventListener)new JournalBackButton(middleX - 30, middleY + 86, button -> this.goBack()));
        this.prevPageButton = (JournalPageButton)this.m_142416_((GuiEventListener)new JournalPageButton(middleX - 155, middleY + 86, false, button -> {
            if (this.page - 2 >= 0) {
                this.setPage(this.page - 2);
            }
        }));
        this.nextPageButton = (JournalPageButton)this.m_142416_((GuiEventListener)new JournalPageButton(middleX + 113, middleY + 86, true, button -> {
            if (this.page + 2 < this.totalPages) {
                this.setPage(this.page + 2);
            }
        }));
        this.onPageChange();
        NarratorChatListener.f_93311_.m_93328_();
    }

    protected void loadData() {
    }

    protected void m_142228_(NarrationElementOutput narration) {
        if (this.shouldSayUsageMessage()) {
            super.m_142228_(narration);
            return;
        }
        this.m_142227_(narration);
    }

    protected boolean shouldSayUsageMessage() {
        return false;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.showCode) {
            mouseX = this.offsetMouseX(mouseX);
            mouseY = this.offsetMouseY(mouseY);
        }
        return super.m_5953_(-mouseX, -mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        if (this.showCode) {
            mouseX = this.offsetMouseX(mouseX);
            mouseY = this.offsetMouseY(mouseY);
        }
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        AbstractWidget widget;
        this.m_7333_(matrix);
        if (this.showCode) {
            matrix.m_85836_();
            translateX = codeX - this.f_96543_ / 2 + 163;
            translateY = codeY - this.f_96544_ / 2 + 110;
            matrix.m_85837_((double)translateX, (double)translateY, 0.0);
            mouseX = (int)this.offsetMouseX(mouseX);
            mouseY = (int)this.offsetMouseY(mouseY);
        } else {
            translateX = 0;
            translateY = 0;
        }
        int bookHeight = 220;
        int yOffset = (this.f_96544_ - bookHeight) / 2;
        SkiesClientUtil.bind(PAGE_LEFT);
        this.m_93228_(matrix, this.f_96543_ / 2 - 163, yOffset, 0, 0, 163, bookHeight);
        SkiesClientUtil.bind(PAGE_RIGHT);
        this.m_93228_(matrix, this.f_96543_ / 2, yOffset, 0, 0, 153, bookHeight);
        this.renderExtra(matrix, mouseX, mouseY, partialTicks);
        for (Widget renderable : this.f_169369_) {
            if (!(renderable instanceof AbstractWidget) || (widget = (AbstractWidget)renderable).m_198029_()) continue;
            widget.m_6305_(matrix, mouseX, mouseY, partialTicks);
        }
        for (Widget renderable : this.f_169369_) {
            if (!(renderable instanceof AbstractWidget) || !(widget = (AbstractWidget)renderable).m_198029_()) continue;
            widget.m_6305_(matrix, mouseX, mouseY, partialTicks);
        }
        if (this.showCode) {
            matrix.m_85849_();
        }
    }

    protected void renderExtra(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    protected void setPage(int page) {
        this.page = page;
        this.onPageChange();
    }

    protected void onPageChange() {
        this.nextPageButton.f_93624_ = this.page < this.totalPages - 2;
        this.prevPageButton.f_93624_ = this.page > 0;
    }

    public static void open(boolean openInventoryOnBackButton) {
        Minecraft.m_91087_().m_91152_((Screen)(savedScreen == null ? new BlueJournalStartScreen() : savedScreen));
        BlueJournalScreen.openInventoryOnBackButton = openInventoryOnBackButton;
    }

    public void m_7379_() {
        savedScreen = this;
        this.showCode = false;
        NarratorChatListener.f_93311_.m_93328_();
        super.m_7379_();
    }

    protected void goBack() {
        LocalPlayer player = this.f_96541_.f_91074_;
        if (this.previousScreen == null) {
            savedScreen = null;
            if (openInventoryOnBackButton) {
                this.f_96541_.m_91152_((Screen)new InventoryScreen((Player)player));
                PacketHandler.sendToServer(new OpenInventoryPacket.Vanilla());
            } else {
                this.f_96541_.m_91152_(null);
            }
        } else {
            this.f_96541_.m_91152_((Screen)this.previousScreen);
            this.previousScreen.showCode = this.showCode;
        }
    }

    public boolean m_7933_(int key, int scancode, int modifier) {
        if (key == CODE[this.codeIndex]) {
            ++this.codeIndex;
            if (this.codeIndex >= CODE.length) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SkiesSounds.ENTITY_FLUCTUANT_SPHERE_DISAPPEAR, (float)0.7f));
                this.showCode = !this.showCode;
                this.setCodeData();
                this.codeIndex = 0;
            }
        } else {
            this.codeIndex = 0;
        }
        switch (key) {
            case 259: {
                this.backButton.m_6375_(this.backButton.f_93620_, this.backButton.f_93621_, 0);
                return true;
            }
            case 263: {
                this.prevPageButton.m_6375_(this.prevPageButton.f_93620_, this.prevPageButton.f_93621_, 0);
                return true;
            }
            case 262: {
                this.nextPageButton.m_6375_(this.nextPageButton.f_93620_, this.nextPageButton.f_93621_, 0);
                return true;
            }
        }
        InputConstants.Key input = InputConstants.m_84827_((int)key, (int)scancode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(input)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(key, scancode, modifier);
    }

    public void m_86600_() {
        if (this.showCode) {
            if (codeX <= 0 || codeX + 316 >= this.f_96543_) {
                codeMotionX *= -1;
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12208_, (float)1.0f));
            }
            if (codeY <= 0 || codeY + 220 >= this.f_96544_) {
                codeMotionY *= -1;
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12208_, (float)1.0f));
            }
            if (!(codeX > 0 && codeX + 316 < this.f_96543_ || codeY > 0 && codeY + 220 < this.f_96544_)) {
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12275_, (float)1.0f));
            }
            codeX += codeMotionX;
            codeY += codeMotionY;
        }
    }

    public void m_6574_(Minecraft minecraft, int newWidth, int newHeight) {
        super.m_6574_(minecraft, newWidth, newHeight);
        this.setCodeData();
    }

    public boolean m_7043_() {
        return false;
    }

    private final void setCodeData() {
        codeMotionX = Math.random() < 0.5 ? 1 : -1;
        codeMotionY = Math.random() < 0.5 ? 1 : -1;
        codeX = this.f_96543_ / 2 - 163;
        codeY = this.f_96544_ / 2 - 110;
    }

    private final double offsetMouseX(double mouseX) {
        return mouseX - (double)(codeX - this.f_96543_ / 2 + 163);
    }

    private final double offsetMouseY(double mouseY) {
        return mouseY - (double)(codeY - this.f_96544_ / 2 + 110);
    }
}

