/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.asm_hooks;

import com.legacy.blue_skies.client.renders.world.StarrySkyRenderer;
import com.legacy.blue_skies.registries.SkiesEmissives;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.MinecraftForgeClient;

public class LevelRendererHooks {
    private static final Direction[] SEARCH_ORDER = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.DOWN};

    public static boolean isEmissive(BlockState state) {
        return SkiesEmissives.EMISSIVES.containsKey(state.m_60734_());
    }

    public static int getLight(BlockAndTintGetter level, BlockState state, BlockPos pos) {
        RenderType renderType = MinecraftForgeClient.getRenderType();
        if (renderType != null && renderType != RenderType.m_110463_()) {
            int skyLight = level.m_45517_(LightLayer.SKY, pos);
            int blockLight = level.m_45517_(LightLayer.BLOCK, pos);
            for (Direction dir : SEARCH_ORDER) {
                BlockPos offsetPos = pos.m_121945_(dir);
                skyLight = Math.max(skyLight, level.m_45517_(LightLayer.SKY, offsetPos));
                blockLight = Math.max(blockLight, level.m_45517_(LightLayer.BLOCK, offsetPos) - 1);
            }
            int stateLight = state.getLightEmission((BlockGetter)level, pos);
            if (blockLight < stateLight) {
                blockLight = stateLight;
            }
            return skyLight << 20 | blockLight << 4;
        }
        return 0xF000F0;
    }

    public static boolean shouldRenderSky(int ticks, float partialTicks, PoseStack pose, ClientLevel level, Minecraft mc, Matrix4f matrix, Runnable fog) {
        StarrySkyRenderer sky = StarrySkyRenderer.getSkyForDim((ResourceKey<Level>)level.m_46472_());
        if (sky != null) {
            sky.render(ticks, partialTicks, pose, level, mc, matrix, fog);
            return true;
        }
        return false;
    }
}

