/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.core.util.AbstractConfigUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class BlueSkiesConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final CommonConfig COMMON;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)((Object)pair.getLeft());
        CLIENT_SPEC = (ForgeConfigSpec)pair.getRight();
        pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)((Object)pair.getLeft());
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    public static class ClientConfig
    extends AbstractConfigUtil {
        private final ClientData data = new ClientData();
        private final ForgeConfigSpec.ConfigValue<Boolean> customPanorama;
        private final ForgeConfigSpec.ConfigValue<Boolean> limitBrightness;
        private final ForgeConfigSpec.ConfigValue<Boolean> useSimpleInventoryTabs;
        private final ForgeConfigSpec.ConfigValue<Boolean> invTabLeftAlign;
        private final ForgeConfigSpec.ConfigValue<Integer> invTabSimpleX;
        private final ForgeConfigSpec.ConfigValue<Integer> invTabSimpleY;
        private final ForgeConfigSpec.ConfigValue<Boolean> invTabIsVertical;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            super("blue_skies", () -> CLIENT_SPEC);
            builder.push("Visuals");
            this.customPanorama = builder.comment("\n Should blue skies override the title screen panorama.\n Default: true").define("custom_panorama", true);
            this.limitBrightness = builder.comment("\n Whether or not brightness should be capped when inside the dimensions for aesthetic purposes.\n Default: true").define("limit_brightness", true);
            builder.pop();
            builder.push("Inventory Tabs");
            this.useSimpleInventoryTabs = builder.comment("\n If set to true, inventory tabs will use simple buttons that can be placed anywhere on the screen.\n Default: false").define("use_simple_inventory_tabs", false);
            builder.push("Sliding Tabs");
            this.invTabLeftAlign = builder.comment("\n If set to true, inventory tabs appear on the bottom left corner instead of the bottom right.\n Default: false").define("left_align", false);
            builder.pop();
            builder.push("Buttons");
            this.invTabSimpleX = builder.comment("\n The x position of the inventory tabs.\n Default: -88").define("x", (Object)-88);
            this.invTabSimpleY = builder.comment("\n The y position of the inventory tabs.\n Default: -83").define("y", (Object)-83);
            this.invTabIsVertical = builder.comment("\n If set to true, inventory tabs are sorted vertically. If set to false, they are sorted horizontally.\n Default: false").define("is_vertical", false);
            builder.pop();
            builder.pop();
        }

        public boolean isPanoramaCustom() {
            return this.data.customPanorama;
        }

        public boolean shouldLimitBrightness() {
            return this.data.limitBrightness;
        }

        public boolean useSimpleInventoryTabs() {
            return this.data.useSimpleInventoryTabs;
        }

        public boolean leftAlignInventoryTabs() {
            return this.data.invTabLeftAlign;
        }

        public int getInventoryTabX() {
            return this.data.invTabSimpleX;
        }

        public int getInventoryTabY() {
            return this.data.invTabSimpleY;
        }

        public boolean areInventoryTabsVertical() {
            return this.data.invTabIsVertical;
        }

        protected void reload() {
            this.data.load();
        }

        private static class ClientData {
            private boolean customPanorama = true;
            private boolean limitBrightness = true;
            private boolean useSimpleInventoryTabs = false;
            private boolean invTabLeftAlign = false;
            private int invTabSimpleX = -88;
            private int invTabSimpleY = -83;
            private boolean invTabIsVertical = true;

            private ClientData() {
            }

            protected void load() {
                this.customPanorama = (Boolean)BlueSkiesConfig.CLIENT.customPanorama.get();
                this.limitBrightness = (Boolean)BlueSkiesConfig.CLIENT.limitBrightness.get();
                this.useSimpleInventoryTabs = (Boolean)BlueSkiesConfig.CLIENT.useSimpleInventoryTabs.get();
                this.invTabLeftAlign = (Boolean)BlueSkiesConfig.CLIENT.invTabLeftAlign.get();
                this.invTabSimpleX = (Integer)BlueSkiesConfig.CLIENT.invTabSimpleX.get();
                this.invTabSimpleY = (Integer)BlueSkiesConfig.CLIENT.invTabSimpleY.get();
                this.invTabIsVertical = (Boolean)BlueSkiesConfig.CLIENT.invTabIsVertical.get();
            }
        }
    }

    public static class CommonConfig
    extends AbstractConfigUtil {
        private final CommonData data = new CommonData();
        private final ForgeConfigSpec.ConfigValue<Boolean> logMissingRegistryObjectForDatapack;
        private final ForgeConfigSpec.ConfigValue<Boolean> allowHalloweenContent;
        private final ForgeConfigSpec.ConfigValue<Boolean> allowChristmasContent;
        private final ForgeConfigSpec.ConfigValue<Integer> zealLighterCost;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedModsForFeatureGen;
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedMobsForSpawning;
        private final StructureConfig gatekeeperStructure;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            super("blue_skies", () -> COMMON_SPEC);
            builder.push("Debug");
            this.logMissingRegistryObjectForDatapack = builder.comment("\n When loading files from datapacks, set this to true to log missing registry data for things like items.\n Default: false").define("log_missing_registry_data_for_datapacks", false);
            builder.pop();
            builder.push("Holiday Content");
            this.allowHalloweenContent = builder.comment("\n Determines if Halloween cosmetic effects should happen.\n Default: true").define("allow_halloween_content", true);
            this.allowChristmasContent = builder.comment("\n Determines if Christmas cosmetic effects should happen.\n Default: true").define("allow_christmas_content", true);
            builder.pop();
            builder.push("Gatekeeper");
            this.zealLighterCost = builder.comment("\n The emerald cost for the Zeal Lighter sold by the Gatekeeper.\n Default: 8").define("zeal_lighter_cost", (Object)8);
            this.gatekeeperStructure = StructureConfig.builder((ForgeConfigSpec.Builder)builder, (String)"Gatekeeper House").pushPlacement().probability(75).popPlacement().build();
            builder.pop();
            builder.push("Mod Compatibility");
            this.allowedModsForFeatureGen = builder.comment("\n A list of mods that are allowed to generate features in the Everbright and Everdawn.\n This does not make them generate, it just allows them to pass the filter. \n Default: []\n Example: [\"minecraft\", \"farlanders\", \"botania\"]").defineList("allowed_mods_for_feature_gen", new ArrayList(), o -> true);
            this.allowedMobsForSpawning = builder.comment("\n A list of mobs that are allowed to spawn in the Everbright and Everdawn.\n This does not make them spawn, it just allows them to pass the filter. \n Default: []\n Example: [\"minecraft:bee\", \"moolands:awful_cow\", \"alexs_mobs:grizzly_bear\"]").defineList("allowed_mobs_for_spawning", new ArrayList(), o -> true);
            builder.pop();
        }

        public boolean shouldLogMissingRegistryObjectForDatapack() {
            return this.data.logMissingRegistryObjectForDatapack;
        }

        public boolean isHalloween() {
            return this.data.allowHalloweenContent && BlueSkies.isHalloween;
        }

        public boolean isChristmas() {
            return this.data.allowChristmasContent && BlueSkies.isChristmas;
        }

        public int getZealLighterCost() {
            return this.data.zealLighterCost;
        }

        public StructureConfig getGatekeeperHouseConfig() {
            return this.gatekeeperStructure;
        }

        public boolean isModAllowedForFeatureGen(String mod) {
            return "blue_skies".equals(mod) || "minecraft".equals(mod) || this.data.allowedModsForFeatureGen.contains(mod);
        }

        public boolean isEntityAllowedToSpawn(EntityType<?> entityType) {
            ResourceLocation id = ForgeRegistries.ENTITIES.getKey(entityType);
            return id != null && ("blue_skies".equals(id.m_135827_()) || this.data.allowedMobsForSpawning.contains(entityType));
        }

        protected void reload() {
            this.data.load();
        }

        private static class CommonData {
            private static final ImmutableSet<EntityType<?>> defaultAllowedMobs = ImmutableSet.of((Object)EntityType.f_20492_, (Object)EntityType.f_20460_, (Object)EntityType.f_20553_, (Object)EntityType.f_20554_, (Object)EntityType.f_20556_, (Object)EntityType.f_20519_, (Object[])new EntityType[0]);
            private boolean logMissingRegistryObjectForDatapack = false;
            private boolean allowHalloweenContent = true;
            private boolean allowChristmasContent = true;
            private int zealLighterCost = 8;
            private Set<? extends String> allowedModsForFeatureGen = new HashSet<String>();
            private Set<EntityType<?>> allowedMobsForSpawning = Set.copyOf(defaultAllowedMobs);

            private CommonData() {
            }

            protected void load() {
                this.logMissingRegistryObjectForDatapack = (Boolean)BlueSkiesConfig.COMMON.logMissingRegistryObjectForDatapack.get();
                this.allowHalloweenContent = (Boolean)BlueSkiesConfig.COMMON.allowHalloweenContent.get();
                this.allowChristmasContent = (Boolean)BlueSkiesConfig.COMMON.allowChristmasContent.get();
                this.zealLighterCost = (Integer)BlueSkiesConfig.COMMON.zealLighterCost.get();
                this.allowedModsForFeatureGen = new HashSet<String>((Collection)BlueSkiesConfig.COMMON.allowedModsForFeatureGen.get());
                this.allowedMobsForSpawning = ((List)BlueSkiesConfig.COMMON.allowedMobsForSpawning.get()).stream().map(s -> {
                    try {
                        return new ResourceLocation(s);
                    }
                    catch (ResourceLocationException e) {
                        BlueSkies.LOGGER.warn("A mob spawn ID added to the blue skies config file contained improper characters ", (Throwable)e);
                        return new ResourceLocation("minecraft:empty");
                    }
                }).filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).containsKey(arg_0)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITIES).getValue(arg_0)).collect(Collectors.toCollection(HashSet::new));
                this.allowedMobsForSpawning.addAll((Collection<EntityType<?>>)defaultAllowedMobs);
            }
        }
    }
}

