/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.LootTableAlias;
import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.GelCapability;
import com.legacy.structure_gel.core.capability.entity.GelEntityProvider;
import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Internal
public class SGCommonEvents {

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.FORGE)
    protected static class ForgeBus {
        protected ForgeBus() {
        }

        @SubscribeEvent
        protected static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            event.addCapability(StructureGelMod.locate("gel_entity"), (ICapabilityProvider)new GelEntityProvider());
        }

        @SubscribeEvent
        protected static void onEntityJoinLevel(EntityJoinWorldEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                GelCapability.ifPresent(serverPlayer, gelPlayer -> gelPlayer.sendToClient(serverPlayer));
            }
        }

        @SubscribeEvent
        protected static void registerCommands(RegisterCommandsEvent event) {
            StructureGelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        protected static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            ActionHistory.clearHistory();
        }

        @SubscribeEvent
        protected static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            if (event.getItemStack().m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    protected static class ModBus {
        protected ModBus() {
        }

        @SubscribeEvent
        protected static void registerCapability(RegisterCapabilitiesEvent event) {
            event.register(IGelEntity.class);
        }

        @SubscribeEvent
        protected static void commonSetup(FMLCommonSetupEvent event) {
            PacketHandler.register();
            event.enqueueWork(() -> {
                LootTableAlias.REGISTRY.init();
                DataHandlerType.REGISTRY.init();
                DynamicSpawnerType.REGISTRY.init();
            });
        }
    }
}

