/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.GelEntity;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.client.models.BuildingToolModel;
import com.legacy.structure_gel.core.client.renderers.block_entity.DataHandlerRenderer;
import com.legacy.structure_gel.core.client.renderers.block_entity.DynamicSpawnerRenderer;
import com.legacy.structure_gel.core.client.renderers.block_entity.GelJigsawRenderer;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.Internal;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Internal
public class SGClientEvents {

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    protected static class ForgeBus {
        protected ForgeBus() {
        }

        @SubscribeEvent
        protected static void skipExperimentalBackupScreen(ScreenEvent.DrawScreenEvent.Post event) {
            if (SGConfig.CLIENT.skipExperimentalScreen()) {
                Screen screen = event.getScreen();
                if (screen instanceof BackupConfirmScreen) {
                    BackupConfirmScreen gui = (BackupConfirmScreen)screen;
                    if (ForgeBus.doesTitleMatch(gui.m_96636_(), "selectWorld.backupQuestion.experimental") && ForgeBus.hasButton(gui.f_169369_, 1)) {
                        StructureGelMod.LOGGER.log("Skipped backup request screen for world that uses experimental settings. You can disable this via config.", new Object[0]);
                        ((AbstractButton)gui.f_169369_.get(1)).m_5691_();
                    }
                } else {
                    ConfirmScreen gui;
                    screen = event.getScreen();
                    if (screen instanceof ConfirmScreen && ForgeBus.doesTitleMatch((gui = (ConfirmScreen)screen).m_96636_(), "selectWorld.backupQuestion.experimental") && ForgeBus.hasButton(gui.f_169369_, 0)) {
                        StructureGelMod.LOGGER.log("Skipped world load warning screen for world that uses experimental settings. You can disable this via config.", new Object[0]);
                        ((AbstractButton)gui.f_169369_.get(0)).m_5691_();
                    }
                }
            }
        }

        private static boolean hasButton(List<Widget> buttons, int index) {
            return buttons.size() > index && buttons.get(index) instanceof AbstractButton;
        }

        private static boolean doesTitleMatch(Component title, String compare) {
            ComponentContents contents = title.m_214077_();
            return contents instanceof TranslatableContents && ((TranslatableContents)contents).m_237508_().equals(compare);
        }

        @SubscribeEvent
        protected static void onPlaySound(PlaySoundEvent event) {
            SoundInstance originalSound = event.getOriginalSound();
            if (originalSound != null) {
                ResourceLocation name = originalSound.m_7904_();
                GelPortalBlock portal = GelEntity.getPortalClient();
                if (portal != null && name != null) {
                    SoundInstance newSound = null;
                    if (name.equals((Object)SoundEvents.f_12287_.m_11660_())) {
                        newSound = portal.getTravelSound();
                    } else if (name.equals((Object)SoundEvents.f_12288_.m_11660_())) {
                        newSound = portal.getTriggerSound();
                    }
                    if (newSound != null) {
                        event.setSound(newSound);
                    }
                }
            }
        }

        @SubscribeEvent
        protected static void clientPlayerTick(TickEvent.PlayerTickEvent event) {
            if (event.phase == TickEvent.Phase.END && event.side == LogicalSide.CLIENT) {
                GelEntity.clientTick();
            }
        }

        @SubscribeEvent
        protected static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
            StructureGelMod.proxy.setViewBounds(false);
            StructureGelMod.proxy.clearToolRenderCache();
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    protected static class ModBus {
        protected ModBus() {
        }

        @SubscribeEvent
        protected static void clientInit(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                List.of(SGRegistry.Blocks.RED_GEL, SGRegistry.Blocks.BLUE_GEL, SGRegistry.Blocks.GREEN_GEL, SGRegistry.Blocks.CYAN_GEL, SGRegistry.Blocks.ORANGE_GEL, SGRegistry.Blocks.YELLOW_GEL).forEach(b -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.m_110466_()));
                ItemBlockRenderTypes.setRenderLayer((Block)SGRegistry.Blocks.DATA_HANDLER.get(), (RenderType)RenderType.m_110463_());
                ItemBlockRenderTypes.setRenderLayer((Block)((Block)SGRegistry.Blocks.DYNAMIC_SPAWNER.get()), (RenderType)RenderType.m_110463_());
                ItemProperties.register((Item)Items.f_42352_, (ResourceLocation)StructureGelMod.locate("mode"), (stack, level, entity, layer) -> {
                    CompoundTag blockEntityTag;
                    CompoundTag tag = stack.m_41783_();
                    if (tag != null && tag.m_128425_("BlockEntityTag", 10) && (blockEntityTag = tag.m_128469_("BlockEntityTag")).m_128425_("mode", 8)) {
                        return StructureMode.valueOf((String)blockEntityTag.m_128461_("mode")).ordinal();
                    }
                    return -1.0f;
                });
                ClientRegistry.registerKeyBinding((KeyMapping)((KeyMapping)ClientProxy.UNDO_KEY.get()));
                ClientRegistry.registerKeyBinding((KeyMapping)((KeyMapping)ClientProxy.REDO_KEY.get()));
            });
        }

        @SubscribeEvent
        protected static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(BlockEntityType.f_58910_, GelJigsawRenderer::new);
            event.registerBlockEntityRenderer(SGRegistry.BlockEntities.DATA_HANDLER.get(), DataHandlerRenderer::new);
            event.registerBlockEntityRenderer(SGRegistry.BlockEntities.DYNAMIC_SPAWNER.get(), DynamicSpawnerRenderer::new);
        }

        @SubscribeEvent
        public static void modelRegistry(ModelRegistryEvent event) {
            for (BuildingToolMode mode : BuildingToolMode.REGISTRY.getValues()) {
                ForgeModelBakery.addSpecialModel((ResourceLocation)mode.getModel());
            }
        }

        @SubscribeEvent
        protected static void setupModels(ModelBakeEvent event) {
            ModelResourceLocation modelName = new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)SGRegistry.Items.BUILDING_TOOL.get()), "inventory");
            BakedModel oldModel = (BakedModel)event.getModelRegistry().get(modelName);
            if (oldModel != null) {
                event.getModelRegistry().put(modelName, new BuildingToolModel(oldModel, (ModelBakery)event.getModelLoader()));
            }
        }
    }
}

