/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class BuildingToolCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"building_tool").requires(source -> source.m_6761_(2));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"undo").executes(context -> BuildingToolCommand.undo((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_().m_36316_().getName(), 1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)new PlayerNameArgument()).executes(context -> BuildingToolCommand.undo((CommandContext<CommandSourceStack>)context, (String)context.getArgument("player", String.class), 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> BuildingToolCommand.undo((CommandContext<CommandSourceStack>)context, (String)context.getArgument("player", String.class), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"redo").executes(context -> BuildingToolCommand.redo((CommandContext<CommandSourceStack>)context, ((CommandSourceStack)context.getSource()).m_81375_().m_36316_().getName(), 1))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)new PlayerNameArgument()).executes(context -> BuildingToolCommand.redo((CommandContext<CommandSourceStack>)context, (String)context.getArgument("player", String.class), 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> BuildingToolCommand.redo((CommandContext<CommandSourceStack>)context, (String)context.getArgument("player", String.class), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))));
        return command;
    }

    private static int undo(CommandContext<CommandSourceStack> context, String playerName, int amount) {
        return BuildingToolCommand.undoOrRedo(context, playerName, amount, true);
    }

    private static int redo(CommandContext<CommandSourceStack> context, String playerName, int amount) {
        return BuildingToolCommand.undoOrRedo(context, playerName, amount, false);
    }

    private static int undoOrRedo(CommandContext<CommandSourceStack> context, String playerName, int amount, boolean undo) {
        Consumer<ServerPlayer> action;
        String doing;
        ActionHistory history = ActionHistory.getHistory(playerName);
        if (history.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)(playerName + " has no action history.")));
            return 0;
        }
        String string = doing = undo ? "undo" : "redo";
        Consumer<ServerPlayer> consumer = undo ? history::undo : (action = history::redo);
        if (amount > 1) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Attempting to " + doing + " " + amount + " actions from " + playerName)), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Attempting to " + doing + " " + playerName + "'s last action")), true);
        }
        try {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            for (int i = 0; i < amount; ++i) {
                action.accept(player);
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"This command must be ran by a player since they need to be in the dimension of the action."));
            return 0;
        }
    }

    private static class PlayerNameArgument
    implements ArgumentType<String> {
        private PlayerNameArgument() {
        }

        public String parse(StringReader reader) throws CommandSyntaxException {
            return reader.readUnquotedString();
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return SharedSuggestionProvider.m_82970_(ActionHistory.getHistoryOwners(), (SuggestionsBuilder)builder);
        }
    }
}

