/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core;

import com.legacy.structure_gel.core.util.AbstractConfigUtil;
import com.legacy.structure_gel.core.util.Internal;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

@Internal
public class SGConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    protected static final ForgeConfigSpec COMMON_SPEC;
    protected static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPairCommon = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Common
    extends AbstractConfigUtil {
        private final Storage storage = new Storage();
        private final ForgeConfigSpec.IntValue buildingToolPermission;
        private final ForgeConfigSpec.IntValue buildingToolMaxUndos;
        private final ForgeConfigSpec.BooleanValue exceedFillLimit;
        private final ForgeConfigSpec.BooleanValue consoleDebug;
        private final ForgeConfigSpec.BooleanValue advancedGelBehavior;

        public Common(ForgeConfigSpec.Builder builder) {
            super("structure_gel common", () -> COMMON_SPEC);
            builder.push("building_tool");
            this.buildingToolPermission = builder.comment(this.configComment("The required permission level of a player needed to use the Building Tool.", this.storage.buildingToolPermission)).defineInRange("required_permission", this.storage.buildingToolPermission, 0, 4);
            this.buildingToolMaxUndos = builder.comment(this.configComment("The amount of undo operations saved by the Building Tool.", this.storage.buildingToolMaxUndos)).defineInRange("max_undos", this.storage.buildingToolMaxUndos, 8, 256);
            builder.pop();
            builder.push("vanilla_enhancements");
            this.exceedFillLimit = builder.comment(this.configComment("When true, removes the size limit from the fill and clone commands.", this.storage.exceedFillLimit)).define("exceed_fill_and_clone_limit", this.storage.exceedFillLimit);
            builder.pop();
            builder.push("debug");
            this.consoleDebug = builder.comment(this.configComment("When true, allows extra debug logging to be printed to the console.", this.storage.consoleDebug)).define("console_debug", this.storage.consoleDebug);
            this.advancedGelBehavior = builder.comment(this.configComment("When true:\n - Gel blocks can be clicked through like air when holding items that don't interact with them.\n - Gel blocks can be replaced like air when not holding gel or crouching.\n - Gel blocks automatically replace destroyed neighboring blocks.", this.storage.advancedGelBehavior)).define("advanced_gel_behavior", this.storage.advancedGelBehavior);
            builder.pop();
        }

        public int getBuildingToolRequiredPermission() {
            return this.storage.buildingToolPermission;
        }

        public int getBuildingToolMaxUndos() {
            return this.storage.buildingToolMaxUndos;
        }

        public boolean shouldExceedFillLimit() {
            return this.storage.exceedFillLimit;
        }

        public boolean consoleDebug() {
            return this.storage.consoleDebug;
        }

        public boolean advancedGelBehavior() {
            return this.storage.advancedGelBehavior;
        }

        @Override
        protected void reload() {
            this.storage.buildingToolPermission = (Integer)this.buildingToolPermission.get();
            this.storage.buildingToolMaxUndos = (Integer)this.buildingToolMaxUndos.get();
            this.storage.exceedFillLimit = (Boolean)this.exceedFillLimit.get();
            this.storage.consoleDebug = (Boolean)this.consoleDebug.get();
            this.storage.advancedGelBehavior = (Boolean)this.advancedGelBehavior.get();
        }

        private static class Storage {
            private int buildingToolPermission = 4;
            private int buildingToolMaxUndos = 32;
            private boolean exceedFillLimit = true;
            private boolean consoleDebug = false;
            private boolean advancedGelBehavior = true;

            private Storage() {
            }
        }
    }

    public static class Client
    extends AbstractConfigUtil {
        private final Storage storage = new Storage();
        private final ForgeConfigSpec.BooleanValue skipExperimentalBackupScreen;
        private final ForgeConfigSpec.BooleanValue showStructureBlockInfo;

        public Client(ForgeConfigSpec.Builder builder) {
            super("structure_gel client", () -> CLIENT_SPEC);
            builder.push("gui");
            this.skipExperimentalBackupScreen = builder.comment(this.configComment("Skips the screen that tells you that a world uses experimental settings.", this.storage.skipExperimentalBackupScreen)).define("skip_experimental_backup_screen", this.storage.skipExperimentalBackupScreen);
            builder.pop();
            builder.push("rendering");
            this.showStructureBlockInfo = builder.comment(this.configComment("Displays info on top of Structure Blocks and Jigsaws in world.", this.storage.showStructureBlockInfo)).define("show_structure_block_info", this.storage.showStructureBlockInfo);
            builder.pop();
        }

        public boolean skipExperimentalScreen() {
            return this.storage.skipExperimentalBackupScreen;
        }

        public boolean showStructureBlockInfo() {
            return this.storage.showStructureBlockInfo;
        }

        @Override
        protected void reload() {
            this.storage.skipExperimentalBackupScreen = (Boolean)this.skipExperimentalBackupScreen.get();
            this.storage.showStructureBlockInfo = (Boolean)this.showStructureBlockInfo.get();
        }

        private static class Storage {
            private boolean skipExperimentalBackupScreen = true;
            private boolean showStructureBlockInfo = true;

            private Storage() {
            }
        }
    }
}

