/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.biome_dictionary.IBiomeFilter;
import com.legacy.structure_gel.api.util.GelCollectors;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.AbstractConfigUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.SimpleMapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraftforge.common.ForgeConfigSpec;

public final class StructureConfig
extends AbstractConfigUtil {
    private static final String DEFAULT_STRUCTURE_CONFIG_KEY = "structure";
    private final PlacementConfig placement = new PlacementConfig();
    private final Map<String, SettingsConfig> settings = new HashMap<String, SettingsConfig>();

    private StructureConfig(Builder builder) {
        super(builder.structureName, () -> null);
        ForgeConfigSpec.Builder configBuilder = builder.builder;
        configBuilder.push(builder.structureName);
        Builder.PlacementBuilder placementBuilder = builder.placementBuilder;
        if (placementBuilder != null) {
            configBuilder.push("placement");
            if (placementBuilder.spacing != null) {
                this.placement.spacing = configBuilder.comment(this.configComment("The average distance between structures of this type, measured in chunks.", placementBuilder.spacing)).defineInRange("spacing", placementBuilder.spacing.intValue(), 1, Integer.MAX_VALUE);
            }
            if (placementBuilder.offset != null) {
                this.placement.offset = configBuilder.comment(this.configComment("A random offset applied to spacing. Values closer to 0 produce a grid effect while values closer to spacing are more random.", placementBuilder.offset)).defineInRange("offset", placementBuilder.offset.intValue(), 0, Integer.MAX_VALUE);
            }
            if (placementBuilder.probability != null) {
                this.placement.probability = configBuilder.comment(this.configComment("Percent chance of generating in an allowed chunk.", placementBuilder.probability)).defineInRange("probability", placementBuilder.probability.intValue(), 0, 100);
            }
            if (placementBuilder.allowedNearSpawn != null) {
                this.placement.allowedNearSpawn = configBuilder.comment(this.configComment("Determines if the structure can generate near (0, 0).", placementBuilder.allowedNearSpawn)).define("allowed_near_spawn", () -> placementBuilder.allowedNearSpawn);
            }
            configBuilder.pop();
        }
        if (!builder.settingsBuilders.isEmpty()) {
            configBuilder.push("structures");
            for (Map.Entry<String, Builder.SettingsBuilder> entry : builder.settingsBuilders.entrySet()) {
                String key = entry.getKey();
                configBuilder.push(key);
                SettingsConfig settingsConfig = new SettingsConfig();
                this.settings.put(key, settingsConfig);
                Builder.SettingsBuilder settingsBuilder = entry.getValue();
                if (settingsBuilder.biomes != null) {
                    configBuilder.push("biomes");
                    settingsConfig.biomes = configBuilder.comment(this.configComment("A filter for which biomes this structure should generate in. Entries are formatted as follows:\n - Biome: \"minecraft:plains\"\n - Tag: \"#minecraft:is_forest\"\n - Prefix an entry with ! to exclude it: \"!#minecraft:is_ocean\"", settingsBuilder.biomes, "[\"#minecraft:is_forest\", \"!minecraft:flower_forest\"] This will include all biomes tagged as forests except for flower forests.")).defineList("biomes", settingsBuilder.biomes, o -> true);
                    configBuilder.pop();
                }
                if (!settingsBuilder.spawns.isEmpty()) {
                    configBuilder.push("spawns");
                    JsonElement spawnsJson = (JsonElement)SettingsConfig.SPAWNS_CODEC.encode(settingsBuilder.spawns, (DynamicOps)JsonOps.INSTANCE, JsonOps.INSTANCE.mapBuilder()).build((Object)new JsonObject()).getOrThrow(false, s -> {});
                    String spawnsString = spawnsJson.toString().replace("\"", "'");
                    settingsConfig.spawns = configBuilder.comment(this.configComment("The mob spawns for this structure, formatted in json the same way that structures have their data formatted in datapacks.", "\"" + spawnsString + "\"\n")).define("spawns", (Object)spawnsString);
                    configBuilder.pop();
                }
                if (settingsBuilder.dimensions != null) {
                    configBuilder.push("dimensions");
                    settingsConfig.dimensions = configBuilder.comment(this.configComment("What dimensions this structure should generate in. Leave empty to allow all dimensions.", settingsBuilder.dimensions, List.of("minecraft:overworld", "minecraft:the_nether"))).defineList("dimensions", settingsBuilder.dimensions, o -> true);
                    configBuilder.pop();
                }
                configBuilder.pop();
            }
            configBuilder.pop();
        }
        configBuilder.pop();
    }

    public static Builder builder(ForgeConfigSpec.Builder builder, String structureName) {
        return new Builder(builder, structureName);
    }

    public PlacementConfig getPlacement() {
        return this.placement;
    }

    public SettingsConfig getStructure(String key) {
        SettingsConfig settings = this.settings.get(key);
        if (settings == null) {
            throw new NullPointerException("[Structure Gel] Attempted to get a SettingsConfig under a key that does not exist: \"" + key + "\"");
        }
        return settings;
    }

    public SettingsConfig getStructure() {
        return this.getStructure(DEFAULT_STRUCTURE_CONFIG_KEY);
    }

    @Override
    protected void reload() {
    }

    @Override
    protected void handleLoad() {
    }

    public static final class Builder {
        private final ForgeConfigSpec.Builder builder;
        private final String structureName;
        @Nullable
        private PlacementBuilder placementBuilder = null;
        private final Map<String, SettingsBuilder> settingsBuilders = new HashMap<String, SettingsBuilder>();

        private Builder(ForgeConfigSpec.Builder builder, String structureName) {
            this.builder = builder;
            this.structureName = structureName;
        }

        public PlacementBuilder pushPlacement() {
            this.placementBuilder = new PlacementBuilder();
            return this.placementBuilder;
        }

        public Builder placement(int spacing, int offset, int probability) {
            this.pushPlacement().spacing(spacing).offset(offset).probability(probability).popPlacement();
            return this;
        }

        public SettingsBuilder pushStructure(String key) throws IllegalArgumentException {
            if (this.settingsBuilders.containsKey(key)) {
                throw new IllegalArgumentException("[Structure Gel] A SettingsBuilder already exists under the name \"" + key + "\"");
            }
            SettingsBuilder settingsBuilder = new SettingsBuilder();
            this.settingsBuilders.put(key, settingsBuilder);
            return settingsBuilder;
        }

        public SettingsBuilder pushStructure() throws IllegalArgumentException {
            return this.pushStructure(StructureConfig.DEFAULT_STRUCTURE_CONFIG_KEY);
        }

        public StructureConfig build() {
            return new StructureConfig(this);
        }

        public final class PlacementBuilder {
            @Nullable
            private Integer spacing = null;
            @Nullable
            private Integer offset = null;
            @Nullable
            private Integer probability = null;
            @Nullable
            private Boolean lakeProof = null;
            @Nullable
            private Boolean allowedNearSpawn = null;

            private PlacementBuilder() {
            }

            public PlacementBuilder spacing(int spacing) {
                this.spacing = spacing;
                return this;
            }

            public PlacementBuilder offset(int offset) {
                this.offset = offset;
                return this;
            }

            public PlacementBuilder probability(int probability) {
                this.probability = probability;
                return this;
            }

            public PlacementBuilder lakeProof(boolean lakeProof) {
                this.lakeProof = lakeProof;
                return this;
            }

            public PlacementBuilder allowedNearSpawn(boolean allowedNearSpawn) {
                this.allowedNearSpawn = allowedNearSpawn;
                return this;
            }

            public Builder popPlacement() {
                return Builder.this;
            }
        }

        public final class SettingsBuilder {
            @Nullable
            private List<String> biomes;
            private final Map<MobCategory, StructureSpawnOverride> spawns = new HashMap<MobCategory, StructureSpawnOverride>();
            @Nullable
            private List<String> dimensions;

            private SettingsBuilder() {
            }

            public SettingsBuilder biomes(Collection<String> biomes) {
                this.biomes = List.copyOf(biomes);
                return this;
            }

            public SettingsBuilder biomes(String ... biomes) {
                return this.biomes(List.of(biomes));
            }

            public SettingsBuilder biomes(BiomeType biomes) {
                return this.biomes(biomes.toFilterStrings(true));
            }

            public SettingsBuilder biomes(BiomeType included, BiomeType excluded) {
                return this.biomes(GelCollectors.merge(included.toFilterStrings(true), excluded.toFilterStrings(false)));
            }

            public SettingsBuilder biomes(TagKey<Biome> biomeTag) {
                return this.biomes(List.of("#" + biomeTag.f_203868_()));
            }

            public SettingsBuilder spawns(MobCategory category, StructureSpawnOverride.BoundingBoxType boundingBoxType, MobSpawnSettings.SpawnerData ... spawns) {
                this.spawns.put(category, new StructureSpawnOverride(boundingBoxType, WeightedRandomList.m_146330_((WeightedEntry[])spawns)));
                return this;
            }

            public SettingsBuilder dimensions(Collection<String> dimensions) {
                this.dimensions = List.copyOf(dimensions);
                return this;
            }

            public SettingsBuilder dimensions(String ... dimensions) {
                return this.dimensions(List.of(dimensions));
            }

            @SafeVarargs
            public final SettingsBuilder dimensions(ResourceKey<Level> ... dimensions) {
                return this.dimensions(Arrays.stream(dimensions).map(ResourceKey::m_135782_).map(ResourceLocation::toString).toList());
            }

            public Builder popStructure() {
                return Builder.this;
            }
        }
    }

    public class PlacementConfig {
        @Nullable
        private ForgeConfigSpec.IntValue probability;
        @Nullable
        private ForgeConfigSpec.IntValue spacing;
        @Nullable
        private ForgeConfigSpec.IntValue offset;
        @Nullable
        private ForgeConfigSpec.BooleanValue allowedNearSpawn;

        private PlacementConfig() {
        }

        public Integer getSpacing(int defaultVal) {
            if (this.spacing != null) {
                return (Integer)this.spacing.get();
            }
            return defaultVal;
        }

        public Integer getOffset(int defaultVal) {
            if (this.offset != null) {
                Integer offset = (Integer)this.offset.get();
                Integer spacing = (Integer)this.spacing.get();
                if (spacing != null) {
                    return Math.max(offset, spacing);
                }
                return offset;
            }
            return defaultVal;
        }

        public Float getProbability(float defaultVal) {
            if (this.probability != null) {
                return Float.valueOf((float)((Integer)this.probability.get()).intValue() / 100.0f);
            }
            return Float.valueOf(defaultVal);
        }

        public Boolean isAllowedNearSpawn(boolean defaultVal) {
            if (this.allowedNearSpawn != null) {
                return (Boolean)this.allowedNearSpawn.get();
            }
            return defaultVal;
        }
    }

    public class SettingsConfig {
        @Nullable
        private ForgeConfigSpec.ConfigValue<List<? extends String>> biomes;
        @Nullable
        private ForgeConfigSpec.ConfigValue<String> spawns;
        @Nullable
        private ForgeConfigSpec.ConfigValue<List<? extends String>> dimensions;
        private static final SimpleMapCodec<MobCategory, StructureSpawnOverride> SPAWNS_CODEC = Codec.simpleMap((Codec)MobCategory.f_21584_, (Codec)StructureSpawnOverride.f_210042_, (Keyable)StringRepresentable.m_14357_((StringRepresentable[])MobCategory.values()));

        private SettingsConfig() {
        }

        @Nullable
        public HolderSet<Biome> getBiomes() {
            if (this.biomes != null) {
                BiomeType.Builder included = BiomeType.builder();
                BiomeType.Builder excluded = BiomeType.builder();
                for (String s : (List)this.biomes.get()) {
                    boolean isExcluded = s.startsWith("!");
                    String active = s.replace("!", "");
                    int mode = active.startsWith("#") ? 1 : 0;
                    if (ResourceLocation.m_135830_((String)(active = active.replace("#", "")))) {
                        BiomeType.Builder builder;
                        ResourceLocation location = new ResourceLocation(active);
                        BiomeType.Builder builder2 = builder = isExcluded ? excluded : included;
                        if (mode == 1) {
                            builder.tags(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)location));
                            continue;
                        }
                        builder.biomes(location);
                        continue;
                    }
                    String string = isExcluded ? "!" : "";
                    String format = string + (switch (mode) {
                        case 1 -> "#mod_name:biome_tag_name";
                        default -> "mod_name:biome_name";
                    });
                    StructureConfig.this.logResourceLocationError(s, "It should be formatted as \"" + format + "\"");
                }
                return new IBiomeFilter.IncludeExcludeBiomeFilter(included.build(), excluded.build());
            }
            return null;
        }

        @Nullable
        public Map<MobCategory, StructureSpawnOverride> getSpawns() {
            if (this.spawns != null) {
                try {
                    JsonElement json = JsonParser.parseString((String)((String)this.spawns.get()));
                    Map decoded = (Map)SPAWNS_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (MapLike)JsonOps.INSTANCE.getMap(json).getOrThrow(false, s -> {})).getOrThrow(false, s -> {});
                    return decoded;
                }
                catch (Exception e) {
                    StructureGelMod.LOGGER.error("Config based mob spawns could not be read for structure = {}", StructureConfig.this.name);
                    StructureGelMod.LOGGER.error(e, new Object[0]);
                }
            }
            return null;
        }

        @Nullable
        public Set<ResourceKey<Level>> getDimensions() {
            if (this.dimensions != null) {
                HashSet<ResourceKey<Level>> dims = new HashSet<ResourceKey<Level>>();
                for (String dim : (List)this.dimensions.get()) {
                    try {
                        if (ResourceLocation.m_135830_((String)dim)) {
                            ResourceKey levelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dim));
                            dims.add((ResourceKey<Level>)levelKey);
                            continue;
                        }
                        StructureConfig.this.logResourceLocationError(dim, "It should be formatted as \"#mod_name:dimension_name\"");
                    }
                    catch (Exception e) {
                        StructureGelMod.LOGGER.error("Dimension config could not be read for structure = {}", StructureConfig.this.name);
                        StructureGelMod.LOGGER.error(e, new Object[0]);
                    }
                }
                return dims;
            }
            return null;
        }
    }
}

