/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.biome_dictionary;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;

public interface IBiomeFilter<T, B extends IBiomeFilter<T, B>> {
    public boolean passesFilter(Holder<Biome> var1);

    public List<Holder<Biome>> getAllValues();

    public List<T> getData();

    public Codec<B> codec();

    public B bind(Registry<Biome> var1);

    public static HolderSet<Biome> rebuildFromRegistry(HolderSet<Biome> biomes, Registry<Biome> biomeRegistry) {
        return IBiomeFilter.rebuildFromRegistry(biomes.m_203614_().map(Holder::m_203543_).filter(Optional::isPresent).map(Optional::get).toList(), biomeRegistry);
    }

    public static HolderSet<Biome> rebuildFromRegistry(List<ResourceKey<Biome>> biomes, Registry<Biome> biomeRegistry) {
        return HolderSet.m_205800_(biomes.stream().map(arg_0 -> biomeRegistry.m_203636_(arg_0)).filter(Optional::isPresent).map(Optional::get).toList());
    }

    public static final class IncludeExcludeBiomeFilter
    implements HolderSetBiomeFilter<Holder<Biome>, IncludeExcludeBiomeFilter> {
        private final HolderSet<Biome> baseIncluded;
        private final HolderSet<Biome> baseExcluded;
        private HolderSet<Biome> included;
        private HolderSet<Biome> excluded;

        public IncludeExcludeBiomeFilter(HolderSet<Biome> baseIncluded, HolderSet<Biome> baseExcluded, HolderSet<Biome> included, HolderSet<Biome> excluded) {
            this.baseIncluded = baseIncluded;
            this.baseExcluded = baseExcluded;
            this.included = included;
            this.excluded = excluded;
        }

        public IncludeExcludeBiomeFilter(HolderSet<Biome> included, HolderSet<Biome> excluded) {
            this(included, excluded, (HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[0]), (HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[0]));
        }

        public boolean m_203333_(Holder<Biome> biome) {
            return this.included.m_203333_(biome) && !this.excluded.m_203333_(biome);
        }

        @Override
        public Stream<Holder<Biome>> m_203614_() {
            return this.included.m_203614_().filter(holder -> !this.excluded.m_203333_(holder));
        }

        @Override
        public List<Holder<Biome>> getAllValues() {
            return this.m_203614_().collect(Collectors.toList());
        }

        @Override
        public List<Holder<Biome>> getData() {
            return List.of();
        }

        @Override
        public Codec<IncludeExcludeBiomeFilter> codec() {
            return RecordCodecBuilder.create(instance -> {
                Codec codec;
                Codec codec2;
                HolderSet<Biome> holderSet = this.included;
                if (holderSet instanceof IBiomeFilter) {
                    IBiomeFilter biomeFilter = (IBiomeFilter)holderSet;
                    codec2 = biomeFilter.codec();
                } else {
                    codec2 = RegistryCodecs.m_206277_((ResourceKey)Registry.f_122885_);
                }
                Codec includeCodec = codec2;
                HolderSet<Biome> holderSet2 = this.excluded;
                if (holderSet2 instanceof IBiomeFilter) {
                    IBiomeFilter biomeFilter = (IBiomeFilter)holderSet2;
                    codec = biomeFilter.codec();
                } else {
                    codec = RegistryCodecs.m_206277_((ResourceKey)Registry.f_122885_);
                }
                Codec excludeCodec = codec;
                return instance.group((App)includeCodec.fieldOf("base_included").forGetter(o -> ((IncludeExcludeBiomeFilter)o).baseIncluded), (App)excludeCodec.fieldOf("base_excluded").forGetter(o -> ((IncludeExcludeBiomeFilter)o).baseExcluded), (App)includeCodec.fieldOf("included").forGetter(o -> ((IncludeExcludeBiomeFilter)o).included), (App)excludeCodec.fieldOf("excluded").forGetter(o -> ((IncludeExcludeBiomeFilter)o).excluded)).apply((Applicative)instance, (bin, bex, in, ex) -> new IncludeExcludeBiomeFilter((HolderSet<Biome>)((HolderSet)bin), (HolderSet<Biome>)((HolderSet)bex), (HolderSet<Biome>)((HolderSet)in), (HolderSet<Biome>)((HolderSet)ex)));
            });
        }

        @Override
        public IncludeExcludeBiomeFilter bind(Registry<Biome> registry) {
            HolderSet holderSet;
            HolderSet holderSet2;
            HolderSetBiomeFilter filter;
            HolderSet<Biome> holderSet3 = this.baseIncluded;
            if (holderSet3 instanceof HolderSetBiomeFilter) {
                filter = (HolderSetBiomeFilter)holderSet3;
                holderSet2 = (HolderSet)filter.bind(registry);
            } else {
                holderSet2 = IBiomeFilter.rebuildFromRegistry(this.baseIncluded, registry);
            }
            this.included = holderSet2;
            holderSet3 = this.baseExcluded;
            if (holderSet3 instanceof HolderSetBiomeFilter) {
                filter = (HolderSetBiomeFilter)holderSet3;
                holderSet = (HolderSet)filter.bind(registry);
            } else {
                holderSet = IBiomeFilter.rebuildFromRegistry(this.baseExcluded, registry);
            }
            this.excluded = holderSet;
            return this;
        }

        public String toString() {
            return String.format("IncludeExcludeBiomeFilter[included = %s, excluded = %s]", this.included, this.excluded);
        }

        public HolderSet<Biome> getIncluded() {
            return this.included;
        }

        public HolderSet<Biome> getExcluded() {
            return this.excluded;
        }
    }

    public static class BiomeTagFilter
    implements HolderSetBiomeFilter<TagKey<Biome>, BiomeTagFilter> {
        public static final BiomeTagFilter EMPTY = new BiomeTagFilter(List.of());
        public static final Codec<BiomeTagFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.m_203877_((ResourceKey)Registry.f_122885_).listOf().fieldOf("tag_keys").forGetter(filter -> filter.tagKeys), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122885_).listOf().fieldOf("biomes").forGetter(filter -> filter.sets)).apply((Applicative)instance, BiomeTagFilter::new));
        private final List<TagKey<Biome>> tagKeys;
        private List<HolderSet<Biome>> sets;

        private BiomeTagFilter(List<TagKey<Biome>> tagKeys, List<HolderSet<Biome>> sets) {
            this.tagKeys = Collections.unmodifiableList(tagKeys);
            this.sets = sets;
        }

        public BiomeTagFilter(List<TagKey<Biome>> tagKeys) {
            this(tagKeys, new ArrayList<HolderSet<Biome>>());
        }

        public boolean m_203333_(Holder<Biome> biome) {
            return this.sets.stream().anyMatch(h -> h.m_203333_(biome));
        }

        @Override
        public List<Holder<Biome>> getAllValues() {
            return this.m_203614_().toList();
        }

        @Override
        public List<TagKey<Biome>> getData() {
            return this.tagKeys;
        }

        @Override
        public Stream<Holder<Biome>> m_203614_() {
            return this.sets.stream().flatMap(HolderSet::m_203614_);
        }

        @Override
        public Codec<BiomeTagFilter> codec() {
            return CODEC;
        }

        @Override
        public BiomeTagFilter bind(Registry<Biome> registry) {
            this.sets = this.tagKeys.stream().map(arg_0 -> registry.m_203431_(arg_0)).filter(Optional::isPresent).map(Optional::get).map(named -> named).toList();
            return this;
        }

        public String toString() {
            return String.format("BiomeTagFilter[%s]", this.getData());
        }
    }

    public static class BiomeFilter
    implements HolderSetBiomeFilter<ResourceKey<Biome>, BiomeFilter> {
        public static final BiomeFilter EMPTY = new BiomeFilter(List.of());
        public static final Codec<BiomeFilter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registry.f_122885_).listOf().fieldOf("biome_keys").forGetter(filter -> filter.biomeKeys), (App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122885_).fieldOf("biomes").forGetter(filter -> filter.biomes)).apply((Applicative)instance, BiomeFilter::new));
        private List<ResourceKey<Biome>> biomeKeys;
        private HolderSet<Biome> biomes;

        private BiomeFilter(List<ResourceKey<Biome>> biomeKeys, HolderSet<Biome> biomes) {
            this.biomeKeys = Collections.unmodifiableList(biomeKeys);
            this.biomes = biomes;
        }

        public BiomeFilter(List<ResourceKey<Biome>> biomeKeys) {
            this(biomeKeys, (HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[0]));
        }

        public boolean m_203333_(Holder<Biome> biome) {
            return this.biomes.m_203333_(biome);
        }

        @Override
        public List<Holder<Biome>> getAllValues() {
            return this.m_203614_().toList();
        }

        @Override
        public List<ResourceKey<Biome>> getData() {
            return this.biomeKeys;
        }

        @Override
        public Stream<Holder<Biome>> m_203614_() {
            return this.biomes.m_203614_();
        }

        @Override
        public int m_203632_() {
            return this.biomes.m_203632_();
        }

        @Override
        public Codec<BiomeFilter> codec() {
            return CODEC;
        }

        @Override
        public BiomeFilter bind(Registry<Biome> biomeRegistry) {
            this.biomes = IBiomeFilter.rebuildFromRegistry(this.biomeKeys, biomeRegistry);
            return this;
        }

        public String toString() {
            return String.format("BiomeFilter[%s]", this.getAllValues());
        }
    }

    public static interface HolderSetBiomeFilter<T, B extends HolderSetBiomeFilter<T, B>>
    extends IBiomeFilter<T, B>,
    HolderSet<Biome> {
        default public Stream<Holder<Biome>> m_203614_() {
            return this.getAllValues().stream();
        }

        default public int m_203632_() {
            return this.getAllValues().size();
        }

        default public Either<TagKey<Biome>, List<Holder<Biome>>> m_203440_() {
            return Either.right(this.getAllValues());
        }

        default public Optional<Holder<Biome>> m_213653_(RandomSource rand) {
            return Util.m_214676_(this.getAllValues(), (RandomSource)rand);
        }

        default public Holder<Biome> m_203662_(int index) {
            return this.getAllValues().get(index);
        }

        default public boolean m_207277_(Registry<Biome> registry) {
            return true;
        }

        default public Iterator<Holder<Biome>> iterator() {
            return this.getAllValues().iterator();
        }

        @Override
        default public boolean passesFilter(Holder<Biome> biome) {
            return this.m_203333_(biome);
        }
    }
}

