/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.situational_ambience;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charmonium.annotation.ClientModule;
import svenhjol.charmonium.annotation.Config;
import svenhjol.charmonium.api.event.AddCaveAmbienceCheck;
import svenhjol.charmonium.handler.SoundHandler;
import svenhjol.charmonium.loader.CharmModule;
import svenhjol.charmonium.module.situational_ambience.SituationalSound;
import svenhjol.charmonium.module.situational_ambience.sounds.Alien;
import svenhjol.charmonium.module.situational_ambience.sounds.Bleak;
import svenhjol.charmonium.module.situational_ambience.sounds.CaveDepth;
import svenhjol.charmonium.module.situational_ambience.sounds.CaveDrone;
import svenhjol.charmonium.module.situational_ambience.sounds.Deepslate;
import svenhjol.charmonium.module.situational_ambience.sounds.Dry;
import svenhjol.charmonium.module.situational_ambience.sounds.Geode;
import svenhjol.charmonium.module.situational_ambience.sounds.Gravel;
import svenhjol.charmonium.module.situational_ambience.sounds.High;
import svenhjol.charmonium.module.situational_ambience.sounds.Mansion;
import svenhjol.charmonium.module.situational_ambience.sounds.Mineshaft;
import svenhjol.charmonium.module.situational_ambience.sounds.NightPlains;
import svenhjol.charmonium.module.situational_ambience.sounds.Snowstorm;
import svenhjol.charmonium.module.situational_ambience.sounds.UndergroundWater;
import svenhjol.charmonium.module.situational_ambience.sounds.Village;

@ClientModule(mod="charmonium", description="Plays specific ambient sound according to the situation or location.")
public class SituationalAmbience
extends CharmModule {
    public Handler handler;
    public static final int CAVE_LIGHT_LEVEL = 10;
    public static List<class_2960> VALID_CAVE_DIMENSIONS = new ArrayList<class_2960>();
    @Config(name="Volume scaling", description="Affects the volume of all situational ambient sounds. 1.0 is full volume.")
    public static float volumeScaling = 0.55f;
    @Config(name="Above ground for ambience silencing", description="Number of blocks above the ground that biome ambience will be silenced.\nSet to zero to disable.")
    public static int cullSoundAboveGround = 32;
    @Config(name="Alien ambience", description="If true, plays ambient sounds while anywhere in the End.")
    public static boolean alien = true;
    @Config(name="Bleak ambience", description="If true, plays ambient sounds in cold and/or barren overworld environments.")
    public static boolean bleak = true;
    @Config(name="Cave drone ambience", description="If true, plays a low drone sound when in a cave below Y 48.")
    public static boolean caveDrone = true;
    @Config(name="Cave depth ambience", description="If true, plays more intense cave sounds when below Y 0 and light level is lower than 10.")
    public static boolean caveDepth = true;
    @Config(name="Deepslate ambience", description="If true, plays ambient sounds when the player is underground and near deepslate blocks.")
    public static boolean deepslate = true;
    @Config(name="Dry ambience", description="If true, plays ambient sounds in dry and/or hot overworld environments.")
    public static boolean dry = true;
    @Config(name="Geode ambience", description="If true, plays ambient sounds from a nearby amethyst geode.")
    public static boolean geode = true;
    @Config(name="Gravel ambience", description="If true, plays ambient sounds when the player is underground and near gravel blocks.")
    public static boolean gravel = true;
    @Config(name="High ambience", description="If true, plays ambient sounds when high up in the overworld.")
    public static boolean high = true;
    @Config(name="Mansion ambience", description="If true, plays ambient sounds while inside a woodland mansion.")
    public static boolean mansion = true;
    @Config(name="Mineshaft ambience", description="If true, plays ambient sounds from a nearby mineshaft.")
    public static boolean mineshaft = true;
    @Config(name="Night plains ambience", description="If true, plays ambient sounds in plains environments at night.")
    public static boolean nightPlains = true;
    @Config(name="Snowstorm ambience", description="If true, plays ambient sounds when in a cold biome during a thunderstorm.")
    public static boolean snowstorm = true;
    @Config(name="Underground water ambience", description="If true, plays water sounds from a nearby water source when underground.")
    public static boolean undergroundWater = true;
    @Config(name="Village ambience", description="If true, plays ambient sounds when a player is inside a village.")
    public static boolean village = true;
    @Config(name="Valid cave drone dimensions", description="Dimensions in which cave drone and cave depth sounds will be played.")
    public static List<String> configCaveDimensions = Arrays.asList("minecraft:overworld");

    @Override
    public void register() {
        Alien.register();
        Bleak.register();
        CaveDepth.register();
        CaveDrone.register();
        UndergroundWater.register();
        Deepslate.register();
        Dry.register();
        Geode.register();
        Gravel.register();
        High.register();
        Mansion.register();
        Mineshaft.register();
        NightPlains.register();
        Snowstorm.register();
        Village.register();
    }

    @Override
    public void runWhenEnabled() {
        ClientEntityEvents.ENTITY_LOAD.register(this::handleEntityLoad);
        ClientEntityEvents.ENTITY_UNLOAD.register(this::handleEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
        configCaveDimensions.forEach(dim -> VALID_CAVE_DIMENSIONS.add(new class_2960(dim)));
    }

    private void handleEntityLoad(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1657) {
            boolean result = ((AddCaveAmbienceCheck)AddCaveAmbienceCheck.EVENT.invoker()).interact(level);
            class_2960 id = level.method_27983().method_29177();
            if (result && !VALID_CAVE_DIMENSIONS.contains(id)) {
                VALID_CAVE_DIMENSIONS.add(id);
            }
            this.trySetupSoundHandler((class_1657)entity);
        }
    }

    private void handleEntityUnload(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746 && this.handler != null) {
            this.handler.stop();
        }
    }

    private void handleClientTick(class_310 client) {
        if (this.handler != null && !client.method_1493()) {
            this.handler.tick();
        }
    }

    public void trySetupSoundHandler(class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (this.handler == null) {
            this.handler = new Handler(player);
        }
        this.handler.updatePlayer(player);
    }

    public static class Handler
    extends SoundHandler<SituationalSound> {
        public Handler(@NotNull class_1657 player) {
            super(player);
            if (alien) {
                Alien.init(this);
            }
            if (bleak) {
                Bleak.init(this);
            }
            if (caveDepth) {
                CaveDepth.init(this);
            }
            if (caveDrone) {
                CaveDrone.init(this);
            }
            if (undergroundWater) {
                UndergroundWater.init(this);
            }
            if (deepslate) {
                Deepslate.init(this);
            }
            if (dry) {
                Dry.init(this);
            }
            if (geode) {
                Geode.init(this);
            }
            if (gravel) {
                Gravel.init(this);
            }
            if (high) {
                High.init(this);
            }
            if (mansion) {
                Mansion.init(this);
            }
            if (mineshaft) {
                Mineshaft.init(this);
            }
            if (nightPlains) {
                NightPlains.init(this);
            }
            if (snowstorm) {
                Snowstorm.init(this);
            }
            if (village) {
                Village.init(this);
            }
        }
    }
}

