/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.biome_ambience.sounds;

import java.util.function.Predicate;
import net.minecraft.class_1959;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import svenhjol.charmonium.handler.SoundHandler;
import svenhjol.charmonium.helper.WorldHelper;
import svenhjol.charmonium.init.CharmoniumBiomes;
import svenhjol.charmonium.module.biome_ambience.BiomeSound;
import svenhjol.charmonium.module.biome_ambience.SurfaceBiomeSound;
import svenhjol.charmonium.registry.ClientRegistry;

public class Beach {
    public static class_3414 DAY;
    public static class_3414 NIGHT;
    public static final Predicate<class_5321<class_1959>> VALID_BIOME;

    public static void register() {
        DAY = ClientRegistry.sound("ambience.beach.day");
        NIGHT = ClientRegistry.sound("ambience.beach.night");
    }

    public static void init(SoundHandler<BiomeSound> handler) {
        handler.getSounds().add(new SurfaceBiomeSound(handler.getPlayer(), true){

            @Override
            @Nullable
            public class_3414 getSound() {
                return DAY;
            }

            @Override
            public boolean isValidPlayerCondition() {
                return super.isValidPlayerCondition() && WorldHelper.isDay(this.player);
            }

            @Override
            public boolean isValidBiomeCondition(class_5321<class_1959> biomeKey, class_1959 biome) {
                return VALID_BIOME.test(biomeKey);
            }
        });
        handler.getSounds().add(new SurfaceBiomeSound(handler.getPlayer(), true){

            @Override
            @Nullable
            public class_3414 getSound() {
                return NIGHT;
            }

            @Override
            public boolean isValidPlayerCondition() {
                return super.isValidPlayerCondition() && WorldHelper.isNight(this.player);
            }

            @Override
            public boolean isValidBiomeCondition(class_5321<class_1959> biomeKey, class_1959 biome) {
                return VALID_BIOME.test(biomeKey);
            }
        });
    }

    static {
        VALID_BIOME = key -> CharmoniumBiomes.BEACH.contains(key);
    }
}

