/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.biome_ambience;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import svenhjol.charmonium.annotation.ClientModule;
import svenhjol.charmonium.annotation.Config;
import svenhjol.charmonium.api.event.AddBiomeAmbienceCallback;
import svenhjol.charmonium.handler.SoundHandler;
import svenhjol.charmonium.init.CharmoniumBiomes;
import svenhjol.charmonium.loader.CharmModule;
import svenhjol.charmonium.module.biome_ambience.BiomeSound;
import svenhjol.charmonium.module.biome_ambience.sounds.Badlands;
import svenhjol.charmonium.module.biome_ambience.sounds.Beach;
import svenhjol.charmonium.module.biome_ambience.sounds.Caves;
import svenhjol.charmonium.module.biome_ambience.sounds.Desert;
import svenhjol.charmonium.module.biome_ambience.sounds.Forest;
import svenhjol.charmonium.module.biome_ambience.sounds.Icy;
import svenhjol.charmonium.module.biome_ambience.sounds.Jungle;
import svenhjol.charmonium.module.biome_ambience.sounds.Mountains;
import svenhjol.charmonium.module.biome_ambience.sounds.Ocean;
import svenhjol.charmonium.module.biome_ambience.sounds.Plains;
import svenhjol.charmonium.module.biome_ambience.sounds.River;
import svenhjol.charmonium.module.biome_ambience.sounds.Savanna;
import svenhjol.charmonium.module.biome_ambience.sounds.Swamp;
import svenhjol.charmonium.module.biome_ambience.sounds.Taiga;
import svenhjol.charmonium.module.biome_ambience.sounds.TheEnd;

@ClientModule(mod="charmonium", description="Plays ambient background sound according to the biome and time of day.")
public class BiomeAmbience
extends CharmModule {
    public Handler handler;
    public static List<class_2960> VALID_DIMENSIONS = new ArrayList<class_2960>();
    @Config(name="Volume scaling", description="Affects the volume of all biome ambient sounds. 1.0 is full volume.")
    public static float volumeScaling = 0.55f;
    @Config(name="Above ground for ambience silencing", description="Number of blocks above the ground that biome ambience will be silenced.\nSet to zero to disable.")
    public static int cullSoundAboveGround = 32;
    @Config(name="Biome sound blending", description="Number of blocks to check for neighbouring biomes.\nSet to zero to disable.")
    public static int biomeBlend = 32;
    @Config(name="Valid dimensions", description="Dimensions in which biome ambience will be played.")
    public static List<String> configDimensions = Arrays.asList("minecraft:overworld", "minecraft:the_end");
    @Config(name="Extra badlands biomes", description="Biomes that will have badlands ambient sounds.")
    public static List<String> extraBadlandsBiomes = new ArrayList<String>();
    @Config(name="Extra beach biomes", description="Biomes that will have beach ambient sounds.")
    public static List<String> extraBeachBiomes = new ArrayList<String>();
    @Config(name="Extra desert biomes", description="Biomes that will have desert ambient sounds.")
    public static List<String> extraDesertBiomes = new ArrayList<String>();
    @Config(name="Extra forest biomes", description="Biomes that will have forest ambient sounds.")
    public static List<String> extraForestBiomes = new ArrayList<String>();
    @Config(name="Extra icy biomes", description="Biomes that will have icy ambient sounds.")
    public static List<String> extraIcyBiomes = new ArrayList<String>();
    @Config(name="Extra jungle biomes", description="Biomes that will have jungle ambient sounds.")
    public static List<String> extraJungleBiomes = new ArrayList<String>();
    @Config(name="Extra mountain biomes", description="Biomes that will have mountain ambient sounds.")
    public static List<String> extraMountainBiomes = new ArrayList<String>();
    @Config(name="Extra ocean biomes", description="Biomes that will have ocean ambient sounds.")
    public static List<String> extraOceanBiomes = new ArrayList<String>();
    @Config(name="Extra plains biomes", description="Biomes that will have plains ambient sounds.")
    public static List<String> extraPlainsBiomes = new ArrayList<String>();
    @Config(name="Extra river biomes", description="Biomes that will have river ambient sounds.")
    public static List<String> extraRiverBiomes = new ArrayList<String>();
    @Config(name="Extra savanna biomes", description="Biomes that will have savanna ambient sounds.")
    public static List<String> extraSavannaBiomes = new ArrayList<String>();
    @Config(name="Extra swamp biomes", description="Biomes that will have swamp ambient sounds.")
    public static List<String> extraSwampBiomes = new ArrayList<String>();
    @Config(name="Extra taiga biomes", description="Biomes that will have taiga ambient sounds.")
    public static List<String> extraTaigaBiomes = new ArrayList<String>();
    @Config(name="Extra End biomes", description="Biomes that will have The End ambient sounds.")
    public static List<String> extraEndBiomes = new ArrayList<String>();

    @Override
    public void register() {
        Beach.register();
        Badlands.register();
        Caves.register();
        Desert.register();
        Forest.register();
        Icy.register();
        Jungle.register();
        Mountains.register();
        Ocean.register();
        Plains.register();
        River.register();
        Savanna.register();
        Swamp.register();
        Taiga.register();
        TheEnd.register();
    }

    @Override
    public void runWhenEnabled() {
        ClientEntityEvents.ENTITY_LOAD.register(this::handleEntityLoad);
        ClientEntityEvents.ENTITY_UNLOAD.register(this::handleEntityUnload);
        ClientTickEvents.END_CLIENT_TICK.register(this::handleClientTick);
        configDimensions.forEach(dim -> VALID_DIMENSIONS.add(new class_2960(dim)));
        extraBadlandsBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.BADLANDS));
        extraBeachBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.BEACH));
        extraDesertBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.DESERT));
        extraForestBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.FOREST));
        extraIcyBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.ICY));
        extraJungleBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.JUNGLE));
        extraMountainBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.MOUNTAIN));
        extraOceanBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.OCEAN));
        extraPlainsBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.PLAINS));
        extraRiverBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.RIVER));
        extraSavannaBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.SAVANNA));
        extraSwampBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.SWAMP));
        extraTaigaBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.TAIGA));
        extraEndBiomes.forEach(r -> CharmoniumBiomes.tryAddBiome(r, CharmoniumBiomes.THEEND));
    }

    private void handleEntityLoad(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1657) {
            boolean result = ((AddBiomeAmbienceCallback)AddBiomeAmbienceCallback.EVENT.invoker()).interact(level);
            class_2960 id = level.method_27983().method_29177();
            if (result && !VALID_DIMENSIONS.contains(id)) {
                VALID_DIMENSIONS.add(id);
            }
            this.trySetupSoundHandler((class_1657)entity);
        }
    }

    private void handleEntityUnload(class_1297 entity, class_1937 level) {
        if (entity instanceof class_746 && this.handler != null) {
            this.handler.stop();
        }
    }

    private void handleClientTick(class_310 client) {
        if (this.handler != null && !client.method_1493()) {
            this.handler.tick();
        }
    }

    public void trySetupSoundHandler(class_1657 player) {
        if (!(player instanceof class_746)) {
            return;
        }
        if (this.handler == null) {
            this.handler = new Handler(player);
        }
        this.handler.updatePlayer(player);
    }

    public static class Handler
    extends SoundHandler<BiomeSound> {
        private Handler(@NotNull class_1657 player) {
            super(player);
            Beach.init(this);
            Badlands.init(this);
            Caves.init(this);
            Desert.init(this);
            Forest.init(this);
            Icy.init(this);
            Jungle.init(this);
            Mountains.init(this);
            Ocean.init(this);
            Plains.init(this);
            River.init(this);
            Savanna.init(this);
            Swamp.init(this);
            Taiga.init(this);
            TheEnd.init(this);
        }
    }
}

