/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.module.biome_ambience.sounds;

import java.util.function.Predicate;
import net.minecraft.class_1959;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import svenhjol.charmonium.handler.SoundHandler;
import svenhjol.charmonium.helper.WorldHelper;
import svenhjol.charmonium.module.biome_ambience.BiomeSound;
import svenhjol.charmonium.module.biome_ambience.SurfaceBiomeSound;
import svenhjol.charmonium.registry.ClientRegistry;

public class Ocean {
    public static class_3414 DAY;
    public static class_3414 NIGHT;
    public static final Predicate<class_1959> VALID_BIOME;

    public static void register() {
        DAY = ClientRegistry.sound("ambience.ocean.day");
        NIGHT = ClientRegistry.sound("ambience.ocean.night");
    }

    public static void init(SoundHandler<BiomeSound> handler) {
        handler.getSounds().add(new SurfaceBiomeSound(handler.getPlayer(), true){

            @Override
            @Nullable
            public class_3414 getSound() {
                return DAY;
            }

            @Override
            public boolean isValidPlayerCondition() {
                return super.isValidPlayerCondition() && WorldHelper.isDay(this.player);
            }

            @Override
            public boolean isValidBiomeCondition(class_5321<class_1959> biomeKey, class_1959 biome) {
                return VALID_BIOME.test(biome);
            }
        });
        handler.getSounds().add(new SurfaceBiomeSound(handler.getPlayer(), true){

            @Override
            @Nullable
            public class_3414 getSound() {
                return NIGHT;
            }

            @Override
            public boolean isValidPlayerCondition() {
                return super.isValidPlayerCondition() && WorldHelper.isNight(this.player);
            }

            @Override
            public boolean isValidBiomeCondition(class_5321<class_1959> biomeKey, class_1959 biome) {
                return VALID_BIOME.test(biome);
            }
        });
    }

    static {
        VALID_BIOME = biome -> biome.method_8688() == class_1959.class_1961.field_9367;
    }
}

