/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charmonium.integration.modmenu;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import svenhjol.charmonium.annotation.Config;
import svenhjol.charmonium.helper.ConfigHelper;
import svenhjol.charmonium.helper.LogHelper;
import svenhjol.charmonium.helper.StringHelper;
import svenhjol.charmonium.loader.CharmModule;

public abstract class BaseModMenuPlugin<T extends CharmModule>
implements ModMenuApi {
    public abstract String getModId();

    public abstract List<T> getModules();

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)new class_2588("cloth." + this.getModId() + ".title"));
            LinkedList<T> modules = new LinkedList<T>(this.getModules());
            builder.setSavingRunnable(() -> ConfigHelper.writeConfig(this.getModId(), modules));
            ConfigCategory mainCategory = builder.getOrCreateCategory((class_2561)new class_2588("cloth." + this.getModId() + ".category.title"));
            for (CharmModule module : modules) {
                Map<Field, Object> properties = this.getModuleConfigProperties(module);
                SubCategoryBuilder subcategory = builder.entryBuilder().startSubCategory((class_2561)new class_2585(module.getName()));
                if (!module.isAlwaysEnabled()) {
                    BooleanToggleBuilder enabledValue = builder.entryBuilder().startBooleanToggle((class_2561)new class_2588("cloth." + this.getModId() + ".category.module_enabled"), module.isEnabledInConfig()).setDefaultValue(module.isEnabledByDefault()).setTooltip(new class_2561[]{new class_2588(StringHelper.splitOverLines(module.getDescription()))}).setSaveConsumer(module::setEnabledInConfig).requireRestart();
                    if (enabledValue != null) {
                        enabledValue.requireRestart(true);
                        subcategory.add(enabledValue.build());
                    }
                }
                properties.forEach((prop, value) -> {
                    ConfigEntryBuilder propBuilder = builder.entryBuilder();
                    BooleanToggleBuilder propValue = null;
                    Config annotation = prop.getDeclaredAnnotation(Config.class);
                    class_2585 name = new class_2585(annotation.name());
                    class_2585 desc = new class_2585(StringHelper.splitOverLines(annotation.description()));
                    if (value instanceof Boolean) {
                        propValue = propBuilder.startBooleanToggle((class_2561)name, ((Boolean)value).booleanValue()).setDefaultValue(() -> (Boolean)this.tryGetDefault((Field)prop)).setTooltip(new class_2561[]{desc}).setSaveConsumer(val -> this.trySetProp((Field)prop, val));
                    } else if (value instanceof Integer) {
                        propValue = propBuilder.startIntField((class_2561)name, ((Integer)value).intValue()).setDefaultValue(() -> (Integer)this.tryGetDefault((Field)prop)).setTooltip(new class_2561[]{desc}).setSaveConsumer(val -> this.trySetProp((Field)prop, val));
                    } else if (value instanceof Double) {
                        propValue = propBuilder.startDoubleField((class_2561)name, ((Double)value).doubleValue()).setDefaultValue(() -> (Double)this.tryGetDefault((Field)prop)).setTooltip(new class_2561[]{desc}).setSaveConsumer(val -> this.trySetProp((Field)prop, val));
                    } else if (value instanceof Float) {
                        propValue = propBuilder.startFloatField((class_2561)name, ((Float)value).floatValue()).setDefaultValue(() -> (Float)this.tryGetDefault((Field)prop)).setTooltip(new class_2561[]{desc}).setSaveConsumer(val -> this.trySetProp((Field)prop, val));
                    } else if (value instanceof String) {
                        propValue = propBuilder.startTextField((class_2561)name, (String)value).setDefaultValue(() -> (String)this.tryGetDefault((Field)prop)).setTooltip(new class_2561[]{desc}).setSaveConsumer(val -> this.trySetProp((Field)prop, val));
                    } else if (value instanceof List) {
                        propValue = propBuilder.startStrList((class_2561)name, (List)value).setDefaultValue(() -> (List)this.tryGetDefault((Field)prop)).setTooltip(new class_2561[]{desc}).setSaveConsumer(val -> this.trySetProp((Field)prop, val));
                    }
                    if (propValue != null) {
                        propValue.requireRestart(annotation.requireRestart());
                        subcategory.add(propValue.build());
                    }
                });
                if (subcategory.isEmpty()) continue;
                mainCategory.addEntry((AbstractConfigListEntry)subcategory.build());
            }
            return builder.build();
        };
    }

    private Map<Field, Object> getModuleConfigProperties(T module) {
        LinkedHashMap<Field, Object> properties = new LinkedHashMap<Field, Object>();
        ArrayList<Field> classFields = new ArrayList<Field>(Arrays.asList(module.getClass().getDeclaredFields()));
        classFields.forEach(prop -> {
            try {
                Config annotation = prop.getDeclaredAnnotation(Config.class);
                if (annotation == null) {
                    return;
                }
                Object value = prop.get(null);
                properties.put((Field)prop, value);
            }
            catch (Exception e) {
                LogHelper.error(this.getClass(), "Failed to read config property " + prop.getName() + " in " + module.getName(), new Object[0]);
            }
        });
        return properties;
    }

    private void trySetProp(Field prop, Object val) {
        try {
            prop.set(null, val);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private Object tryGetDefault(Field prop) {
        return ConfigHelper.getDefaultPropValues().getOrDefault(prop, null);
    }
}

