/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.env.pocket.AirPocket;
import team.creative.ambientsounds.env.pocket.AirPocketScanner;
import team.creative.creativecore.common.util.mc.TickUtils;

public class TerrainEnviroment {
    public double averageHeight = 60.0;
    public int minHeight = 60;
    public int maxHeight = 60;
    public AirPocket airPocket = new AirPocket();
    public AirPocketScanner scanner;

    public void analyze(AmbientEngine engine, AmbientDimension dimension, class_1657 player, class_1937 level) {
        this.analyzeHeight(engine, dimension, player, level);
        this.analyzeAirPocket(engine, player, level);
    }

    public void analyzeHeight(AmbientEngine engine, AmbientDimension dimension, class_1657 player, class_1937 level) {
        if (dimension.averageHeight != null) {
            this.averageHeight = dimension.averageHeight.intValue();
            this.minHeight = dimension.averageHeight;
            this.maxHeight = dimension.averageHeight;
            return;
        }
        int sum = 0;
        int count = 0;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2338 center = player.method_24515();
        for (int x = -engine.averageHeightScanCount; x <= engine.averageHeightScanCount; ++x) {
            for (int z = -engine.averageHeightScanCount; z <= engine.averageHeightScanCount; ++z) {
                pos.method_10103(center.method_10263() + engine.averageHeightScanDistance * x, center.method_10264(), center.method_10260() + engine.averageHeightScanDistance * z);
                int height = TerrainEnviroment.getHeightBlock(level, pos);
                min = Math.min(height, min);
                max = Math.max(height, max);
                sum += height;
                ++count;
            }
        }
        this.averageHeight = (double)sum / (double)count;
        this.minHeight = min;
        this.maxHeight = max;
    }

    public void analyzeAirPocket(AmbientEngine engine, class_1657 player, class_1937 level) {
        if (this.scanner == null) {
            this.scanner = new AirPocketScanner(engine, level, new class_2338(player.method_5836(TickUtils.getDeltaFrameTime((class_1937)level))), x -> {
                this.airPocket = x;
                this.scanner = null;
            });
        }
    }

    public static int getHeightBlock(class_1937 level, class_2338.class_2339 pos) {
        int heighest = 0;
        for (int y = level.method_8597().comp_652(); y > level.method_8597().comp_651(); --y) {
            pos.method_33098(y);
            class_2680 state = level.method_8320((class_2338)pos);
            if (!state.method_26216((class_1922)level, (class_2338)pos) && !state.method_26164(class_3481.field_15503) && !level.method_8316((class_2338)pos).method_15767(class_3486.field_15517)) continue;
            heighest = y;
            break;
        }
        return heighest;
    }
}

