/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1117;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import team.creative.ambientsounds.AmbientCondition;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientSelection;
import team.creative.ambientsounds.AmbientSoundProperties;
import team.creative.ambientsounds.env.AmbientEnviroment;
import team.creative.creativecore.common.config.api.CreativeConfig;

public class AmbientSound
extends AmbientCondition {
    private static Random rand = new Random();
    @CreativeConfig.DecimalRange(min=0.0, max=1.0)
    public transient double volumeSetting = 1.0;
    public String name;
    public transient String fullName;
    public class_2960[] files;
    public double[] chances;
    public transient SoundStream stream1;
    public transient SoundStream stream2;
    protected transient boolean active;
    protected transient float aimedVolume;
    protected transient float currentVolume;
    protected transient float aimedPitch;
    protected transient int transition;
    protected transient int transitionTime;
    protected transient int pauseTimer = -1;
    protected transient AmbientSoundProperties currentPropertries;
    protected transient AmbientEngine engine;

    @Override
    public void init(AmbientEngine engine) {
        if (this.files == null || this.files.length == 0) {
            throw new RuntimeException("Invalid sound " + this.name + " which does not contain any sound file");
        }
        this.engine = engine;
        if (this.chances == null) {
            this.chances = new double[this.files.length];
            Arrays.fill(this.chances, 1.0 / (double)this.files.length);
        } else if (this.chances.length != this.files.length) {
            double[] newChances = new double[this.files.length];
            for (int i = 0; i < newChances.length; ++i) {
                newChances[i] = this.chances.length > i ? this.chances[i] : 1.0 / (double)this.files.length;
            }
            this.chances = newChances;
        }
    }

    protected int getRandomFile() {
        if (this.files.length == 1) {
            return 0;
        }
        return rand.nextInt(this.files.length);
    }

    protected int getRandomFileExcept(int i) {
        if (this.files.length == 2) {
            return i == 0 ? 1 : 0;
        }
        int index = rand.nextInt(this.files.length - 1);
        if (index >= i) {
            ++index;
        }
        return index;
    }

    public boolean fastTick(AmbientEnviroment env) {
        if (this.currentVolume < this.aimedVolume) {
            this.currentVolume = (float)((double)this.currentVolume + Math.min(this.currentPropertries.getFadeInVolume(this.engine), (double)(this.aimedVolume - this.currentVolume)));
        } else if (this.currentVolume > this.aimedVolume) {
            this.currentVolume = (float)((double)this.currentVolume - Math.min(this.currentPropertries.getFadeOutVolume(this.engine), (double)(this.currentVolume - this.aimedVolume)));
        }
        if (this.isPlaying()) {
            if (this.inTransition()) {
                this.stream1.volume = Math.max(0.0, Math.min(this.stream1.volume, this.getCombinedVolume(env) * (1.0 - (double)this.transition / (double)this.transitionTime)));
                this.stream2.volume = Math.min(this.getCombinedVolume(env), this.getCombinedVolume(env) * ((double)this.transition / (double)this.transitionTime));
                if (this.transition >= this.transitionTime) {
                    this.engine.soundEngine.stop(this.stream1);
                    this.stream1 = this.stream2;
                    this.stream2 = null;
                }
                ++this.transition;
            } else {
                if (this.stream1.duration == -1 && this.currentPropertries.length != null) {
                    this.stream1.duration = (int)this.currentPropertries.length.randomValue();
                } else if (this.stream1.duration > 0 && this.currentPropertries.length == null) {
                    this.stream1.duration = -1;
                }
                this.stream1.volume = this.getCombinedVolume(env);
                if (this.currentPropertries.length != null) {
                    if (this.currentPropertries.pause == null && this.files.length > 1) {
                        if (this.stream1.remaining() <= 0) {
                            this.transition = 0;
                            this.stream2 = this.play(this.getRandomFileExcept(this.stream1.index), env);
                            this.stream2.volume = 0.0;
                            this.transitionTime = this.currentPropertries.transition != null ? this.currentPropertries.transition : 60;
                        }
                    } else {
                        int fadeOutTime = (int)Math.ceil((double)this.aimedVolume / this.currentPropertries.getFadeOutVolume(this.engine));
                        if (this.stream1.remaining() <= 0) {
                            this.engine.soundEngine.stop(this.stream1);
                            this.stream1 = null;
                            this.pauseTimer = -1;
                        } else if (fadeOutTime > this.stream1.remaining()) {
                            this.stream1.volume = this.getCombinedVolume(env) * (double)this.stream1.remaining() / (double)fadeOutTime;
                        }
                    }
                }
            }
            if (this.stream1 != null) {
                if (this.stream1.pitch < (double)this.aimedPitch) {
                    this.stream1.pitch += Math.min(this.currentPropertries.getFadeInPitch(this.engine), (double)this.aimedPitch - this.stream1.pitch);
                } else if (this.stream1.pitch > (double)this.aimedPitch) {
                    this.stream1.pitch -= Math.min(this.currentPropertries.getFadeOutPitch(this.engine), this.stream1.pitch - (double)this.aimedPitch);
                }
                ++this.stream1.ticksPlayed;
            }
            if (this.stream2 != null) {
                if (this.stream2.pitch < (double)this.aimedPitch) {
                    this.stream2.pitch += Math.min(this.currentPropertries.getFadeInPitch(this.engine), (double)this.aimedPitch - this.stream2.pitch);
                } else if (this.stream2.pitch > (double)this.aimedPitch) {
                    this.stream2.pitch -= Math.min(this.currentPropertries.getFadeOutPitch(this.engine), this.stream2.pitch - (double)this.aimedPitch);
                }
                ++this.stream2.ticksPlayed;
            }
        } else {
            if (this.stream2 != null) {
                this.engine.soundEngine.stop(this.stream2);
                this.stream2 = null;
            }
            if (this.pauseTimer == -1 && this.currentPropertries.pause != null) {
                this.pauseTimer = (int)this.currentPropertries.pause.randomValue();
            }
            if (this.pauseTimer <= 0) {
                this.stream1 = this.play(this.getRandomFile(), env);
            } else {
                --this.pauseTimer;
            }
        }
        return this.aimedVolume > 0.0f || this.currentVolume > 0.0f;
    }

    @Override
    public AmbientSelection value(AmbientEnviroment env) {
        if (this.volumeSetting == 0.0) {
            return null;
        }
        return super.value(env);
    }

    public boolean tick(AmbientEnviroment env, AmbientSelection selection) {
        if (selection != null) {
            AmbientSelection soundSelection = this.value(env);
            if (soundSelection != null) {
                AmbientSelection last = selection.getLast();
                last.subSelection = soundSelection;
                this.aimedVolume = (float)selection.getEntireVolume();
                this.currentPropertries = selection.getProperties();
                last.subSelection = null;
                this.aimedPitch = class_3532.method_15363((float)this.currentPropertries.getPitch(env), (float)0.5f, (float)2.0f);
            } else {
                this.aimedVolume = 0.0f;
            }
        } else {
            this.aimedVolume = 0.0f;
        }
        return this.aimedVolume > 0.0f || this.currentVolume > 0.0f;
    }

    protected SoundStream play(int index, AmbientEnviroment env) {
        SoundStream stream = new SoundStream(index, env);
        stream.pitch = this.aimedPitch;
        if (this.currentPropertries.length != null) {
            stream.duration = (int)this.currentPropertries.length.randomValue();
        }
        this.engine.soundEngine.play(stream);
        return stream;
    }

    public boolean isPlaying() {
        return this.stream1 != null;
    }

    public boolean inTransition() {
        return this.stream1 != null && this.stream2 != null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
        if (this.stream1 != null) {
            this.engine.soundEngine.stop(this.stream1);
            this.stream1 = null;
        }
        if (this.stream2 != null) {
            this.engine.soundEngine.stop(this.stream2);
            this.stream2 = null;
        }
    }

    public void onSoundFinished() {
        if (this.stream1 != null && this.stream1.finished) {
            this.stream1 = null;
            this.pauseTimer = -1;
        } else {
            this.stream2 = null;
        }
    }

    public boolean loop() {
        return this.currentPropertries.length != null || this.currentPropertries.pause == null && this.files.length == 1;
    }

    public double getCombinedVolume(AmbientEnviroment env) {
        return (double)this.currentVolume * this.volumeSetting * env.dimension.volumeSetting;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name);
        if (this.stream1 != null) {
            builder.append("[" + this.stream1 + "]");
        }
        if (this.stream2 != null) {
            builder.append("[" + this.stream2 + "]");
        }
        if (this.inTransition()) {
            builder.append("t: " + this.transition + "/" + this.transitionTime);
        }
        return builder.toString();
    }

    public static class_3419 getSoundSource(String name) {
        if (name == null) {
            return class_3419.field_15256;
        }
        for (int i = 0; i < class_3419.values().length; ++i) {
            if (!class_3419.values()[i].method_14840().equals(name)) continue;
            return class_3419.values()[i];
        }
        return class_3419.field_15256;
    }

    public class SoundStream
    implements class_1117 {
        private static final class_5819 rand = class_5819.method_43047();
        public final int index;
        public final class_2960 location;
        public float generatedVoume;
        public class_1146 soundeventaccessor;
        public double volume;
        public double pitch;
        public int duration = -1;
        public int ticksPlayed = 0;
        private boolean finished = false;
        private boolean playedOnce;
        public final class_3419 category;

        public SoundStream(int index, AmbientEnviroment env) {
            this.index = index;
            this.location = AmbientSound.this.files[index];
            this.volume = AmbientSound.this.getCombinedVolume(env);
            this.category = AmbientSound.getSoundSource(AmbientSound.this.currentPropertries.category);
            this.generatedVoume = (float)this.volume;
        }

        public boolean loop() {
            return AmbientSound.this.loop();
        }

        public int remaining() {
            return this.duration - this.ticksPlayed;
        }

        public double mute() {
            return AmbientSound.this.currentPropertries.mute * this.volume;
        }

        public void onStart() {
            this.finished = false;
            this.playedOnce = false;
        }

        public void onFinished() {
            this.finished = true;
            AmbientSound.this.onSoundFinished();
        }

        public boolean hasPlayedOnce() {
            return this.playedOnce;
        }

        public void setPlayedOnce() {
            this.playedOnce = true;
        }

        public boolean hasFinished() {
            return this.finished;
        }

        public String toString() {
            return "l:" + this.location + ",v:" + (double)Math.round(this.volume * 100.0) / 100.0 + ",i:" + this.index + ",p:" + this.pitch + ",t:" + this.ticksPlayed + ",d:" + this.duration;
        }

        public boolean method_4786() {
            return this.loop();
        }

        public class_1146 method_4783(class_1144 sndHandler) {
            this.soundeventaccessor = sndHandler.method_4869(this.location);
            return this.soundeventaccessor;
        }

        public class_1113.class_1114 method_4777() {
            return class_1113.class_1114.field_5478;
        }

        public class_3419 method_4774() {
            return this.category;
        }

        public float method_4782() {
            return (float)this.pitch;
        }

        public int method_4780() {
            return 0;
        }

        public class_1111 method_4776() {
            return this.soundeventaccessor.method_4887(rand);
        }

        public class_2960 method_4775() {
            return this.location;
        }

        public float method_4781() {
            return this.generatedVoume;
        }

        public double method_4784() {
            return 0.0;
        }

        public double method_4779() {
            return 0.0;
        }

        public double method_4778() {
            return 0.0;
        }

        public boolean method_4793() {
            return false;
        }

        public void method_16896() {
        }

        public boolean method_4787() {
            return true;
        }
    }
}

