/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.world.storage;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class GeckoLibIdTracker
extends SavedData {
    private static final String NAME = "geckolib_ids";
    private final Object2IntMap<String> usedIds = new Object2IntOpenHashMap();

    public GeckoLibIdTracker() {
        this.usedIds.defaultReturnValue(-1);
    }

    public static GeckoLibIdTracker from(ServerLevel world) {
        return (GeckoLibIdTracker)world.m_7654_().m_129783_().m_8895_().m_164861_(GeckoLibIdTracker::load, GeckoLibIdTracker::new, NAME);
    }

    public static GeckoLibIdTracker load(CompoundTag tag) {
        GeckoLibIdTracker tracker = new GeckoLibIdTracker();
        tracker.usedIds.clear();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 99)) continue;
            tracker.usedIds.put((Object)key, tag.m_128451_(key));
        }
        return tracker;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        for (Object2IntMap.Entry id : this.usedIds.object2IntEntrySet()) {
            tag.m_128405_((String)id.getKey(), id.getIntValue());
        }
        return tag;
    }

    public int getNextId(Type type) {
        int id = this.usedIds.getInt((Object)type.key) + 1;
        this.usedIds.put((Object)type.key, id);
        this.m_77762_();
        return id;
    }

    public static enum Type {
        ITEM("Item");

        private final String key;

        private Type(String key) {
            this.key = key;
        }
    }
}

