/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.network;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import software.bernie.aoa3.geckolib3.GeckoLib;
import software.bernie.aoa3.geckolib3.network.ISyncable;
import software.bernie.aoa3.geckolib3.network.messages.SyncAnimationMsg;

public class GeckoLibNetwork {
    private static final Map<String, Supplier<ISyncable>> SYNCABLES = new HashMap<String, Supplier<ISyncable>>();
    private static final String PROTOCOL_VERSION = "0";
    private static final SimpleChannel CHANNEL = GeckoLibNetwork.fetchGeckoLibChannel("main");

    private static SimpleChannel fetchGeckoLibChannel(String name) {
        try {
            ResourceLocation key = new ResourceLocation("geckolib3", name);
            Method findTarget = NetworkRegistry.class.getDeclaredMethod("findTarget", ResourceLocation.class);
            findTarget.setAccessible(true);
            return ((Optional)findTarget.invoke(null, key)).map(SimpleChannel::new).orElseGet(() -> NetworkRegistry.newSimpleChannel((ResourceLocation)key, () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals));
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to fetch GeckoLib network channel", t);
        }
    }

    public static void initialize() {
        int id = -1;
        SyncAnimationMsg.register(CHANNEL, ++id);
    }

    public static void syncAnimation(PacketDistributor.PacketTarget target, ISyncable syncable, int id, int state) {
        if (!target.getDirection().getOriginationSide().isServer()) {
            throw new IllegalArgumentException("Only the server can request animation syncs!");
        }
        String key = syncable.getSyncKey();
        if (!SYNCABLES.containsKey(key)) {
            throw new IllegalArgumentException("Syncable not registered for " + key);
        }
        CHANNEL.send(target, (Object)new SyncAnimationMsg(key, id, state));
    }

    public static ISyncable getSyncable(String key) {
        Supplier<ISyncable> delegate = SYNCABLES.get(key);
        return delegate == null ? null : delegate.get();
    }

    public static void registerSyncable(ISyncable entry) {
        String key = entry.getSyncKey();
        if (SYNCABLES.putIfAbsent(key, () -> entry) != null) {
            throw new IllegalArgumentException("Syncable already registered for " + key);
        }
        GeckoLib.LOGGER.debug("Registered syncable for " + key);
    }
}

