/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.model;

import com.mojang.blaze3d.Blaze3D;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.aoa3.geckolib3.core.IAnimatable;
import software.bernie.aoa3.geckolib3.core.IAnimatableModel;
import software.bernie.aoa3.geckolib3.core.builder.Animation;
import software.bernie.aoa3.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.aoa3.geckolib3.core.manager.AnimationData;
import software.bernie.aoa3.geckolib3.core.processor.AnimationProcessor;
import software.bernie.aoa3.geckolib3.core.processor.IBone;
import software.bernie.aoa3.geckolib3.file.AnimationFile;
import software.bernie.aoa3.geckolib3.geo.exception.GeckoLibException;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoBone;
import software.bernie.aoa3.geckolib3.geo.render.built.GeoModel;
import software.bernie.aoa3.geckolib3.model.provider.GeoModelProvider;
import software.bernie.aoa3.geckolib3.model.provider.IAnimatableModelProvider;
import software.bernie.aoa3.geckolib3.resource.GeckoLibCache;
import software.bernie.aoa3.geckolib3.util.MolangUtils;
import software.bernie.aoa3.shadowed.eliotlash.molang.MolangParser;

public abstract class AnimatedGeoModel<T extends IAnimatable>
extends GeoModelProvider<T>
implements IAnimatableModel<T>,
IAnimatableModelProvider<T> {
    private final AnimationProcessor animationProcessor = new AnimationProcessor(this);
    private GeoModel currentModel;

    protected AnimatedGeoModel() {
    }

    public void registerBone(GeoBone bone) {
        this.registerModelRenderer(bone);
        for (GeoBone childBone : bone.childBones) {
            this.registerBone(childBone);
        }
    }

    @Override
    public void setLivingAnimations(T entity, Integer uniqueID, @Nullable AnimationEvent customPredicate) {
        AnimationData manager = entity.getFactory().getOrCreateAnimationData(uniqueID);
        if (manager.startTick == null) {
            manager.startTick = this.getCurrentTick();
        }
        if (!Minecraft.m_91087_().m_91104_() || manager.shouldPlayWhilePaused) {
            double gameTick = manager.tick = this.getCurrentTick() - manager.startTick;
            double deltaTicks = gameTick - this.lastGameTickTime;
            this.seekTime += deltaTicks;
            this.lastGameTickTime = gameTick;
        }
        AnimationEvent<T> predicate = customPredicate == null ? new AnimationEvent<T>(entity, 0.0f, 0.0f, 0.0f, false, Collections.emptyList()) : customPredicate;
        predicate.animationTick = this.seekTime;
        this.animationProcessor.preAnimationSetup((IAnimatable)predicate.getAnimatable(), this.seekTime);
        if (!this.animationProcessor.getModelRendererList().isEmpty()) {
            this.animationProcessor.tickAnimation((IAnimatable)entity, uniqueID, this.seekTime, predicate, GeckoLibCache.getInstance().parser, this.shouldCrashOnMissing);
        }
    }

    @Override
    public AnimationProcessor getAnimationProcessor() {
        return this.animationProcessor;
    }

    public void registerModelRenderer(IBone modelRenderer) {
        this.animationProcessor.registerModelRenderer(modelRenderer);
    }

    @Override
    public Animation getAnimation(String name, IAnimatable animatable) {
        AnimationFile animation = GeckoLibCache.getInstance().getAnimations().get(this.getAnimationResource(animatable));
        if (animation == null) {
            throw new GeckoLibException(this.getAnimationResource(animatable), "Could not find animation file. Please double check name.");
        }
        return animation.getAnimation(name);
    }

    @Override
    public GeoModel getModel(ResourceLocation location) {
        GeoModel model = super.getModel(location);
        if (model == null) {
            throw new GeckoLibException(location, "Could not find model. If you are getting this with a built mod, please just restart your game.");
        }
        if (model != this.currentModel) {
            this.animationProcessor.clearModelRendererList();
            for (GeoBone bone : model.topLevelBones) {
                this.registerBone(bone);
            }
            this.currentModel = model;
        }
        return model;
    }

    @Override
    public void setMolangQueries(IAnimatable animatable, double currentTick) {
        MolangParser parser = GeckoLibCache.getInstance().parser;
        Minecraft minecraftInstance = Minecraft.m_91087_();
        parser.setValue("query.actor_count", minecraftInstance.f_91073_.m_104813_());
        parser.setValue("query.time_of_day", MolangUtils.normalizeTime(minecraftInstance.f_91073_.m_46468_()));
        parser.setValue("query.moon_phase", minecraftInstance.f_91073_.m_46941_());
        if (animatable instanceof Entity) {
            parser.setValue("query.distance_from_camera", minecraftInstance.f_91063_.m_109153_().m_90583_().m_82554_(((Entity)animatable).m_20182_()));
            parser.setValue("query.is_on_ground", MolangUtils.booleanToFloat(((Entity)animatable).m_20096_()));
            parser.setValue("query.is_in_water", MolangUtils.booleanToFloat(((Entity)animatable).m_20069_()));
            parser.setValue("query.is_in_water_or_rain", MolangUtils.booleanToFloat(((Entity)animatable).m_20071_()));
            if (animatable instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)animatable;
                parser.setValue("query.health", livingEntity.m_21223_());
                parser.setValue("query.max_health", livingEntity.m_21233_());
                parser.setValue("query.is_on_fire", MolangUtils.booleanToFloat(livingEntity.m_6060_()));
                parser.setValue("query.on_fire_time", livingEntity.m_20094_());
                Vec3 velocity = livingEntity.m_20184_();
                float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
                parser.setValue("query.ground_speed", groundSpeed);
                float yawSpeed = livingEntity.m_5675_((float)currentTick) - livingEntity.m_5675_((float)(currentTick - 0.1));
                parser.setValue("query.yaw_speed", yawSpeed);
            }
        }
    }

    @Override
    public double getCurrentTick() {
        return Blaze3D.m_83640_() * 20.0;
    }
}

