/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.aoa3.geckolib3.file;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import software.bernie.aoa3.geckolib3.GeckoLib;
import software.bernie.aoa3.geckolib3.core.builder.Animation;
import software.bernie.aoa3.geckolib3.file.AnimationFile;
import software.bernie.aoa3.geckolib3.util.json.JsonAnimationUtils;
import software.bernie.aoa3.shadowed.eliotlash.molang.MolangParser;

public class AnimationFileLoader {
    public AnimationFile loadAllAnimations(MolangParser parser, ResourceLocation location, ResourceManager manager) {
        AnimationFile animationFile = new AnimationFile();
        JsonObject jsonRepresentation = this.loadFile(location, manager);
        Set<Map.Entry<String, JsonElement>> entrySet = JsonAnimationUtils.getAnimations(jsonRepresentation);
        for (Map.Entry<String, JsonElement> entry : entrySet) {
            String animationName = entry.getKey();
            try {
                Animation animation = JsonAnimationUtils.deserializeJsonToAnimation(JsonAnimationUtils.getAnimation(jsonRepresentation, animationName), parser);
                animationFile.putAnimation(animationName, animation);
            }
            catch (ChainedJsonException e) {
                GeckoLib.LOGGER.error("Could not load animation: {}", (Object)animationName, (Object)e);
                throw new RuntimeException(e);
            }
        }
        return animationFile;
    }

    private JsonObject loadFile(ResourceLocation location, ResourceManager manager) {
        String content = AnimationFileLoader.getResourceAsString(location, manager);
        Gson GSON = new Gson();
        return (JsonObject)GsonHelper.m_13794_((Gson)GSON, (String)content, JsonObject.class);
    }

    public static String getResourceAsString(ResourceLocation location, ResourceManager manager) {
        String string;
        block8: {
            InputStream inputStream = manager.m_215593_(location).m_215507_();
            try {
                string = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    String message = "Couldn't load " + location;
                    GeckoLib.LOGGER.error(message, (Throwable)e);
                    throw new RuntimeException(new FileNotFoundException(location.toString()));
                }
            }
            inputStream.close();
        }
        return string;
    }
}

