/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.ArrayList;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAGameRules;
import net.tslat.aoa3.content.entity.misc.CustomisableLightningBolt;
import net.tslat.aoa3.util.PlayerUtil;

public final class WorldUtil {
    public static boolean checkGameRule(Level world, GameRules.Key<GameRules.BooleanValue> gameRule) {
        return world.m_46469_().m_46207_(gameRule);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, BlockPos pos, float strength) {
        return WorldUtil.createExplosion(exploder, world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), strength, AoAGameRules.checkDestructiveWeaponPhysics(world) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE, false);
    }

    public static Explosion createExplosion(@Nonnull Entity exploder, Level world, float strength) {
        return WorldUtil.createExplosion(exploder, world, exploder.m_20185_(), exploder.m_20186_(), exploder.m_20189_(), strength, AoAGameRules.checkStrongerMobGriefing(world, exploder) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, @Nonnull Entity explodingEntity, float strength) {
        boolean doGriefing;
        if (exploder instanceof Player) {
            doGriefing = AoAGameRules.checkDestructiveWeaponPhysics(world);
        } else {
            if (exploder == null) {
                exploder = explodingEntity;
            }
            doGriefing = exploder instanceof LivingEntity || explodingEntity instanceof LivingEntity ? AoAGameRules.checkStrongerMobGriefing(world, exploder) : AoAGameRules.checkDestructiveWeaponPhysics(world);
        }
        return WorldUtil.createExplosion(exploder, world, explodingEntity.m_20185_(), explodingEntity.m_20186_(), explodingEntity.m_20189_(), strength, doGriefing ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, double posX, double posY, double posZ, float strength) {
        return WorldUtil.createExplosion(exploder, world, posX, posY, posZ, strength, AoAGameRules.checkDestructiveWeaponPhysics(world) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, double posX, double posY, double posZ, float strength, Explosion.BlockInteraction explosionType) {
        return WorldUtil.createExplosion(exploder, world, posX, posY, posZ, strength, explosionType, false);
    }

    public static Explosion createExplosion(@Nullable Entity exploder, Level world, double posX, double posY, double posZ, float strength, Explosion.BlockInteraction explosionType, boolean fieryExplosion) {
        return world.m_46518_(exploder, posX, posY, posZ, strength, fieryExplosion, explosionType);
    }

    public static int getLightLevel(ServerLevelAccessor world, BlockPos position, boolean ignoreSkyLight, boolean ignoreBlockLight) {
        if (ignoreBlockLight && ignoreSkyLight) {
            ignoreBlockLight = false;
            ignoreSkyLight = false;
        }
        if (position.m_123342_() > 255) {
            position = new BlockPos(position.m_123341_(), 255, position.m_123343_());
        } else if (position.m_123342_() < 0) {
            position = new BlockPos(position.m_123341_(), 0, position.m_123343_());
        }
        if (ignoreSkyLight) {
            return world.m_45517_(LightLayer.BLOCK, position);
        }
        if (ignoreBlockLight) {
            return world.m_45517_(LightLayer.SKY, position) - world.m_7445_();
        }
        return world.m_45524_(position, 0);
    }

    public static void spawnLightning(ServerLevel world, @Nullable ServerPlayer caster, double x, double y, double z, boolean destructive, boolean createFire) {
        CustomisableLightningBolt lightning = new CustomisableLightningBolt((Level)world, x, y, z);
        lightning.m_20874_(!destructive);
        if (!createFire) {
            lightning.noFire();
        }
        if (caster != null) {
            lightning.m_20879_(caster);
        }
        world.m_7967_((Entity)lightning);
    }

    public static boolean harvestAdditionalBlock(Level world, Player pl, BlockPos breakPos, boolean forceDropsInCreative) {
        BlockState blockState = world.m_8055_(breakPos);
        Block block = blockState.m_60734_();
        if (blockState.m_60795_() || !world.m_7966_(pl, breakPos)) {
            return false;
        }
        if (!world.m_5776_()) {
            ServerPlayer player = (ServerPlayer)pl;
            GameType gameMode = player.f_8941_.m_9290_();
            int blockXp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)gameMode, (ServerPlayer)player, (BlockPos)breakPos);
            if (blockXp == -1) {
                return false;
            }
            BlockEntity tileEntity = world.m_7702_(breakPos);
            if (!pl.m_36337_() && (block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock)) {
                world.m_7260_(breakPos, blockState, blockState, 3);
                return false;
            }
            if (pl.m_21205_().onBlockStartBreak(breakPos, pl) || pl.m_36187_(world, breakPos, gameMode)) {
                return false;
            }
            if (pl.m_7500_()) {
                boolean canHarvest = forceDropsInCreative && blockState.canHarvestBlock((BlockGetter)world, breakPos, pl);
                boolean removed = blockState.onDestroyedByPlayer(world, breakPos, (Player)player, false, world.m_6425_(breakPos));
                if (removed) {
                    blockState.m_60734_().m_6786_((LevelAccessor)world, breakPos, blockState);
                    if (canHarvest) {
                        block.m_6240_(world, pl, breakPos, blockState, tileEntity, pl.m_21205_().m_41777_());
                    }
                    if (forceDropsInCreative && blockXp > 0) {
                        blockState.m_60734_().m_49805_((ServerLevel)world, breakPos, blockXp);
                    }
                }
            } else {
                boolean removedBlock;
                ItemStack toolStack = pl.m_21205_();
                ItemStack toolStackCopy = toolStack.m_41777_();
                boolean canHarvest = blockState.canHarvestBlock((BlockGetter)world, breakPos, pl);
                if (toolStack.m_41619_() && !toolStackCopy.m_41619_()) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)pl, (ItemStack)toolStackCopy, (InteractionHand)InteractionHand.MAIN_HAND);
                }
                if (removedBlock = blockState.onDestroyedByPlayer(world, breakPos, (Player)player, false, world.m_6425_(breakPos))) {
                    blockState.m_60734_().m_6786_((LevelAccessor)world, breakPos, blockState);
                    if (canHarvest) {
                        block.m_6240_(world, pl, breakPos, blockState, tileEntity, toolStackCopy);
                    }
                    if (blockXp > 0) {
                        blockState.m_60734_().m_49805_((ServerLevel)world, breakPos, blockXp);
                    }
                }
            }
            return true;
        }
        return ClientOperations.harvestAdditionalBlock(breakPos);
    }

    public static float getAmbientTemperature(Level world, BlockPos pos) {
        Holder biome = world.m_204166_(pos);
        float temp = ((Biome)biome.m_203334_()).m_47505_(pos);
        if (world.m_45527_(pos)) {
            temp = world.m_46461_() ? (temp *= 1.35f) : (temp /= 1.35f);
            if (world.m_46471_()) {
                if (((Biome)biome.m_203334_()).m_47530_() == Biome.Precipitation.SNOW) {
                    temp /= 1.5f;
                } else if (((Biome)biome.m_203334_()).m_47530_() == Biome.Precipitation.RAIN) {
                    temp /= 1.25f;
                }
            }
        }
        return temp;
    }

    @Nonnull
    public static ArrayList<Player> getAllPlayersInRegion(Level world, AABB region) {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player player : world.m_6907_()) {
            if (!region.m_82390_(player.m_20182_())) continue;
            players.add(player);
        }
        return players;
    }

    public static int getTrueWorldHeight(Level world, int x, int z) {
        boolean headBlock = false;
        boolean feetBlock = false;
        try {
            int height = Math.max(world.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z), world.m_6042_().f_63865_());
            if (Math.abs(x) > 30000000 || Math.abs(z) > 30000000) {
                return 0;
            }
            for (int i = height; i > 0; --i) {
                if (world.m_8055_(new BlockPos(x, i, z)).m_60734_() == Blocks.f_50016_) {
                    if (headBlock) {
                        if (feetBlock) continue;
                        feetBlock = true;
                        continue;
                    }
                    headBlock = true;
                    continue;
                }
                if (headBlock && feetBlock) {
                    return i;
                }
                headBlock = false;
                feetBlock = false;
            }
        }
        catch (Exception e) {
            return 0;
        }
        return 0;
    }

    public static boolean canPlaceBlock(LevelAccessor world, BlockPos pos, @Nullable Entity entity, @Nullable ItemStack stack) {
        if (!(world instanceof Level)) {
            return true;
        }
        Level activeWorld = (Level)world;
        Player relevantPlayer = PlayerUtil.getPlayerOrOwnerIfApplicable(entity);
        if (WorldUtil.isWorld(activeWorld, AoADimensions.NOWHERE.key)) {
            return relevantPlayer != null && relevantPlayer.m_7500_();
        }
        if (relevantPlayer != null) {
            if (!relevantPlayer.m_36326_()) {
                return false;
            }
            GameType gameMode = PlayerUtil.getGameMode(relevantPlayer);
            if (gameMode == GameType.SPECTATOR) {
                return false;
            }
            if (gameMode == GameType.ADVENTURE && stack != null) {
                if (stack.m_41619_()) {
                    return false;
                }
                return stack.m_204121_(WorldUtil.getBlockRegistry(activeWorld), new BlockInWorld((LevelReader)activeWorld, pos, false));
            }
        }
        return true;
    }

    public static boolean canModifyBlock(LevelAccessor world, BlockPos pos, @Nullable Entity entity, @Nullable ItemStack stack) {
        if (!(world instanceof Level)) {
            return true;
        }
        Level activeWorld = (Level)world;
        Player relevantPlayer = PlayerUtil.getPlayerOrOwnerIfApplicable(entity);
        if (WorldUtil.isWorld(activeWorld, AoADimensions.NOWHERE.key)) {
            return relevantPlayer != null && relevantPlayer.m_7500_();
        }
        if (relevantPlayer != null) {
            if (!relevantPlayer.m_36326_()) {
                return false;
            }
            GameType gameMode = PlayerUtil.getGameMode(relevantPlayer);
            if (gameMode == GameType.SPECTATOR) {
                return false;
            }
            if (gameMode == GameType.ADVENTURE && stack != null) {
                if (stack.m_41619_()) {
                    return false;
                }
                return stack.m_204128_(WorldUtil.getBlockRegistry(activeWorld), new BlockInWorld((LevelReader)activeWorld, pos, false));
            }
        }
        return true;
    }

    public static void operateOnMultipleBlocksInRange(Level world, BlockPos center, int radius, Predicate<BlockState> test, Consumer<BlockPos> operation) {
        for (int x = center.m_123341_() - radius; x < center.m_123341_() + radius; ++x) {
            for (int y = center.m_123342_() - radius; y < center.m_123342_() + radius; ++y) {
                for (int z = center.m_123343_() - radius; z < center.m_123343_() + radius; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!test.test(world.m_8055_(pos))) continue;
                    operation.accept(pos);
                }
            }
        }
    }

    public static ArrayList<BlockPos> getBlocksWithinAABB(Level world, AABB aabb, @Nullable BiPredicate<BlockState, BlockPos.MutableBlockPos> predicate) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        ArrayList<BlockPos> matches = new ArrayList<BlockPos>();
        int x = (int)Math.floor(aabb.f_82288_);
        while ((double)x <= Math.ceil(aabb.f_82291_)) {
            int y = (int)Math.floor(aabb.f_82289_);
            while ((double)y <= Math.ceil(aabb.f_82292_)) {
                int z = (int)Math.floor(aabb.f_82290_);
                while ((double)z <= Math.ceil(aabb.f_82293_)) {
                    checkPos.m_122178_(x, y, z);
                    if (predicate == null || predicate.test(world.m_8055_((BlockPos)checkPos), checkPos)) {
                        matches.add(checkPos.m_7949_());
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return matches;
    }

    public static Registry<Block> getBlockRegistry(Level level) {
        return level.m_5962_().m_175515_(Registry.f_122901_);
    }

    public static boolean isWorld(ServerLevelAccessor world, ResourceKey<Level> ... keys) {
        for (ResourceKey<Level> key : keys) {
            if (world.m_6018_().m_46472_() != key) continue;
            return true;
        }
        return false;
    }

    public static boolean isWorld(Level world, ResourceKey<Level> ... keys) {
        for (ResourceKey<Level> key : keys) {
            if (world.m_46472_() != key) continue;
            return true;
        }
        return false;
    }

    public static MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }
}

