/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.util;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;

public final class RandomUtil {
    private static final char[] ALPHANUMERIC_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    public static final EasyRandom RANDOM = new EasyRandom(RandomSource.m_216327_());

    public static boolean fiftyFifty() {
        return RANDOM.fiftyFifty();
    }

    public static boolean oneInNChance(int n) {
        return RANDOM.oneInNChance(n);
    }

    public static boolean percentChance(double percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static boolean percentChance(float percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static int randomNumberUpTo(int upperBound) {
        return RANDOM.randomNumberUpTo(upperBound);
    }

    public static float randomValueUpTo(float upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomValueUpTo(double upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomGaussianValue() {
        return RANDOM.randomGaussianValue();
    }

    public static double randomScaledGaussianValue(double scale) {
        return RANDOM.randomScaledGaussianValue(scale);
    }

    public static int randomNumberBetween(int min, int max) {
        return RANDOM.randomNumberBetween(min, max);
    }

    public static double randomValueBetween(double min, double max) {
        return RANDOM.randomValueBetween(min, max);
    }

    public static <T> T getRandomSelection(T ... options) {
        return RANDOM.getRandomSelection(options);
    }

    public static <T> T getRandomSelection(@Nonnull List<T> options) {
        return RANDOM.getRandomSelection(options);
    }

    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius);
    }

    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, Level world) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, safeSurfacePlacement, world);
    }

    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, Level world, @Nullable Predicate<BlockState> statePredicate, int tries) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, safeSurfacePlacement, world, statePredicate, tries);
    }

    public static String getRandomAlphaNumeric(int length) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(ALPHANUMERIC_CHARACTERS[RANDOM.randomNumberUpTo(ALPHANUMERIC_CHARACTERS.length)]);
        }
        return builder.toString();
    }

    public static final class EasyRandom
    implements RandomSource {
        private final RandomSource random;

        public EasyRandom() {
            this(RandomSource.m_216327_());
        }

        public EasyRandom(@Nonnull RandomSource rand) {
            this.random = rand;
        }

        public RandomSource getSource() {
            return RandomSource.m_216327_();
        }

        public boolean fiftyFifty() {
            return this.random.m_188499_();
        }

        public boolean oneInNChance(int n) {
            if (n <= 0) {
                return false;
            }
            return this.random.m_188501_() < 1.0f / (float)n;
        }

        public boolean percentChance(double percentChance) {
            if (percentChance <= 0.0) {
                return false;
            }
            if (percentChance >= 1.0) {
                return true;
            }
            return this.random.m_188500_() < percentChance;
        }

        public boolean percentChance(float percentChance) {
            if (percentChance <= 0.0f) {
                return false;
            }
            if (percentChance >= 1.0f) {
                return true;
            }
            return this.random.m_188500_() < (double)percentChance;
        }

        public int randomNumberUpTo(int upperBound) {
            return this.random.m_188503_(upperBound);
        }

        public float randomValueUpTo(float upperBound) {
            return this.random.m_188501_() * upperBound;
        }

        public double randomValueUpTo(double upperBound) {
            return this.random.m_188500_() * upperBound;
        }

        public double randomGaussianValue() {
            return this.random.m_188583_();
        }

        public double randomScaledGaussianValue(double scale) {
            return this.random.m_188583_() * scale;
        }

        public int randomNumberBetween(int min, int max) {
            return min + (int)Math.floor(this.random.m_188500_() * (double)(1 + max - min));
        }

        public double randomValueBetween(double min, double max) {
            return min + this.random.m_188500_() * (max - min);
        }

        public <T> T getRandomSelection(T ... options) {
            return options[this.random.m_188503_(options.length)];
        }

        public <T> T getRandomSelection(@Nonnull List<T> options) {
            return options.get(this.random.m_188503_(options.size()));
        }

        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, false, null);
        }

        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, Level world) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, safeSurfacePlacement, world, null, 1);
        }

        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, Level world, @Nullable Predicate<BlockState> statePredicate, int tries) {
            BlockPos.MutableBlockPos mutablePos = centerPos.m_122032_();
            for (int i = 0; i < tries; ++i) {
                int newX = (int)Math.floor((float)mutablePos.m_123341_() + this.random.m_188501_() * (float)xRadius * 2.0f - (float)xRadius);
                int newY = (int)Math.floor((float)mutablePos.m_123342_() + this.random.m_188501_() * (float)yRadius * 2.0f - (float)yRadius);
                int newZ = (int)Math.floor((float)mutablePos.m_123343_() + this.random.m_188501_() * (float)zRadius * 2.0f - (float)zRadius);
                mutablePos.m_122178_(newX, newY, newZ);
                if (safeSurfacePlacement && world != null) {
                    mutablePos.m_122190_((Vec3i)world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutablePos));
                }
                if (statePredicate != null && !statePredicate.test(world.m_8055_((BlockPos)mutablePos))) continue;
                return mutablePos.m_7949_();
            }
            return centerPos;
        }

        public String getRandomAlphaNumeric(int length) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                builder.append((char[])this.getRandomSelection((T[])new char[][]{ALPHANUMERIC_CHARACTERS}));
            }
            return builder.toString();
        }

        public EasyRandom fork() {
            return new EasyRandom(this.random.m_213769_());
        }

        public PositionalRandomFactory m_188582_() {
            return this.random.m_188582_();
        }

        public void m_188584_(long seed) {
            this.random.m_188584_(seed);
        }

        public int m_188502_() {
            return this.random.m_188502_();
        }

        public int m_188503_(int upperLimit) {
            return this.random.m_188503_(upperLimit);
        }

        public long m_188505_() {
            return this.random.m_188505_();
        }

        public boolean m_188499_() {
            return this.random.m_188499_();
        }

        public float m_188501_() {
            return this.random.m_188501_();
        }

        public double m_188500_() {
            return this.random.m_188500_();
        }

        public double m_188583_() {
            return this.random.m_188583_();
        }
    }
}

