/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.resource;

import com.google.gson.JsonObject;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.Lazy;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.PlayerUtil;

public final class AoAResource {
    private final Lazy<MutableComponent> name = () -> Component.m_237115_((String)Util.m_137492_((String)"resource", (ResourceLocation)AoARegistries.AOA_RESOURCES.getId(this)));
    private final BiFunction<ServerPlayerDataManager, JsonObject, Instance> jsonFactory;
    private final Function<CompoundTag, Instance> clientFactory;

    public AoAResource(BiFunction<ServerPlayerDataManager, JsonObject, Instance> jsonFactory, Function<CompoundTag, Instance> clientFactory) {
        this.jsonFactory = jsonFactory;
        this.clientFactory = clientFactory;
    }

    public MutableComponent getName() {
        return (MutableComponent)this.name.get();
    }

    public Instance buildDefaultInstance(ServerPlayerDataManager plData, JsonObject resourceData) {
        return this.jsonFactory.apply(plData, resourceData);
    }

    public Instance buildClientInstance(CompoundTag resourceData) {
        return this.clientFactory.apply(resourceData);
    }

    public static abstract class Instance
    implements AoAPlayerEventListener {
        private final AoAResource resource;
        protected ServerPlayerDataManager playerDataManager;
        public boolean needsSync = true;

        protected Instance(AoAResource resource, ServerPlayerDataManager plData) {
            this.playerDataManager = plData;
            this.resource = resource;
        }

        public void changePlayerInstance(ServerPlayerDataManager plData) {
            this.playerDataManager = plData;
        }

        public abstract float getCurrentValue();

        public abstract void setValue(float var1);

        public abstract float getMaxValue();

        public float getPerTickRegen() {
            return 0.0f;
        }

        public AoAResource type() {
            return this.resource;
        }

        public MutableComponent getName() {
            return this.type().getName();
        }

        public ServerPlayerDataManager getPlayerDataManager() {
            return this.playerDataManager;
        }

        public boolean hasAmount(float amount) {
            return this.getCurrentValue() >= amount;
        }

        public void addValue(float amount) {
            this.setValue(this.getCurrentValue() + amount);
        }

        public boolean consume(float amount, boolean consumeIfInsufficient) {
            if (!PlayerUtil.shouldPlayerBeAffected((Player)this.playerDataManager.player())) {
                return true;
            }
            float current = this.getCurrentValue();
            if (current < amount && !consumeIfInsufficient) {
                PlayerUtil.notifyPlayerOfInsufficientResources(this.playerDataManager.player(), this.type(), amount);
                return false;
            }
            this.setValue(Math.max(0.0f, current - amount));
            this.needsSync = true;
            return !consumeIfInsufficient || current >= amount;
        }

        @Nonnull
        public CompoundTag saveToNbt() {
            return new CompoundTag();
        }

        public void loadFromNbt(CompoundTag resourceDataNbt) {
        }

        public CompoundTag getSyncData(boolean forClientSetup) {
            return new CompoundTag();
        }

        public void receiveSyncData(CompoundTag data) {
        }
    }
}

