/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.player.skill.ExtractionSkill;
import net.tslat.aoa3.util.LootUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class RareTableHarvestingChance
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.LOOT_MODIFICATION};

    public RareTableHarvestingChance(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.RARE_TABLE_HARVESTING_CHANCE.get(), skill, data);
    }

    public RareTableHarvestingChance(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.RARE_TABLE_HARVESTING_CHANCE.get(), skill, data);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleLootModification(List<ItemStack> loot, LootContext context) {
        if (!this.testAsChance()) {
            return;
        }
        BlockState state = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (state == null) {
            return;
        }
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (origin == null) {
            return;
        }
        if (!Block.m_49916_((VoxelShape)state.m_60812_((BlockGetter)context.m_78952_(), new BlockPos(origin)))) {
            return;
        }
        if (!ExtractionSkill.isApplicableBlock(state)) {
            return;
        }
        ServerPlayer player = this.getPlayer();
        ServerLevel world = context.m_78952_();
        loot.addAll(LootUtil.generateLoot(world, new ResourceLocation("aoa3", "misc/lotto_totem"), LootUtil.getGiftContext(world, origin, player.m_36336_(), (Entity)player)));
        PlayerUtil.giveXpToPlayer(player, this.getSkill().type(), PlayerUtil.getTimeBasedXpForLevel(PlayerUtil.getLevel((Player)player, (AoASkill)AoASkills.FARMING.get()), 10.0f), false);
    }
}

