/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.data.server.AoASkillReqReloadListener;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class LevelRestriction
extends AoAAbility.Instance {
    private final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[0];
    private final ResourceLocation restrictedId;

    public LevelRestriction(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.LEVEL_RESTRICTION.get(), skill, data);
        this.restrictedId = this.generateRestrictionHandlers(data);
    }

    public LevelRestriction(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.LEVEL_RESTRICTION.get(), skill, data);
        this.restrictedId = new ResourceLocation(data.m_128461_("restriction_id"));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return this.LISTENERS;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        MutableComponent targetName;
        Map<String, List<Pair<ResourceLocation, Integer>>> restrictions = AoASkillReqReloadListener.getParsedReqDataFor(this.restrictedId);
        if (restrictions.isEmpty()) {
            super.updateDescription(Component.m_237110_((String)((TranslatableContents)defaultDescription.m_214077_()).m_237508_(), (Object[])new Object[]{"??"}));
            return;
        }
        if (this.isForBlock(restrictions)) {
            targetName = ((Block)ForgeRegistries.BLOCKS.getValue(this.restrictedId)).m_49954_();
        } else {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(this.restrictedId);
            targetName = item.m_7626_(item.m_7968_());
        }
        MutableComponent description = Component.m_237110_((String)((TranslatableContents)defaultDescription.m_214077_()).m_237508_(), (Object[])new Object[]{targetName});
        boolean comma = false;
        for (Map.Entry<String, List<Pair<ResourceLocation, Integer>>> restriction : restrictions.entrySet()) {
            if (comma) {
                description.m_130946_(", ");
            }
            description.m_7220_((Component)Component.m_237115_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + "." + restriction.getKey())));
            comma = true;
        }
        super.updateDescription(description);
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128359_("restriction_id", this.restrictedId.toString());
        }
        return data;
    }

    protected ResourceLocation generateRestrictionHandlers(JsonObject json) {
        ResourceLocation restrictedId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"restricted_id"));
        JsonArray reqs = GsonHelper.m_13933_((JsonObject)json, (String)"restrictions");
        if (reqs.size() == 0) {
            throw new IllegalArgumentException("Invalid skill requirements for Level Restriction ability.");
        }
        HashMap<String, List<Pair<ResourceLocation, Integer>>> reqData = new HashMap<String, List<Pair<ResourceLocation, Integer>>>();
        for (JsonElement entry : reqs) {
            reqData.put(entry.getAsJsonPrimitive().getAsString(), Collections.singletonList(Pair.of((Object)AoARegistries.AOA_SKILLS.getId(this.skill.type()), (Object)this.getLevelReq())));
        }
        AoASkillReqReloadListener.addRequirements(restrictedId, reqData);
        return restrictedId;
    }

    private boolean isForBlock(Map<String, List<Pair<ResourceLocation, Integer>>> restrictions) {
        Iterator<String> iterator = restrictions.keySet().iterator();
        while (iterator.hasNext()) {
            String type;
            switch (type = iterator.next()) {
                case "break_block": 
                case "place_block": 
                case "interact_with": {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onGuiHover(int mouseX, int mouseY) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onGuiClick(int mouseX, int mouseY) {
        return false;
    }
}

