/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.tslat.aoa3.client.AoAKeybinds;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.NumberUtil;

public class HarvestSpeedBoost
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.BLOCK_BREAK_SPEED, AoAPlayerEventListener.ListenerType.PLAYER_TICK, AoAPlayerEventListener.ListenerType.KEY_INPUT};
    private final float energyDrainPerTick;
    private final float costReductionPerLevel;
    private final float speedBoostMod;
    private boolean active = false;

    public HarvestSpeedBoost(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.HARVEST_SPEED_BOOST.get(), skill, data);
        this.energyDrainPerTick = GsonHelper.m_13915_((JsonObject)data, (String)"energy_drain_per_tick");
        this.costReductionPerLevel = GsonHelper.m_13820_((JsonObject)data, (String)"cost_reduction_per_level", (float)0.0f);
        this.speedBoostMod = GsonHelper.m_13820_((JsonObject)data, (String)"speed_boost", (float)2.0f);
    }

    public HarvestSpeedBoost(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.HARVEST_SPEED_BOOST.get(), skill, data);
        this.energyDrainPerTick = data.m_128457_("energy_drain_per_tick");
        this.costReductionPerLevel = data.m_128457_("cost_reduction_per_level");
        this.speedBoostMod = data.m_128457_("speed_boost");
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        super.updateDescription(Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + (this.costReductionPerLevel != 0.0f ? ".scaling" : "")), (Object[])new Object[]{NumberUtil.roundToNthDecimalPlace(this.energyDrainPerTick * 20.0f, 2), NumberUtil.roundToNthDecimalPlace(this.costReductionPerLevel * 20.0f, 2)}));
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128350_("energy_drain_per_tick", this.energyDrainPerTick);
            data.m_128350_("cost_reduction_per_level", this.costReductionPerLevel);
            data.m_128350_("speed_boost", this.speedBoostMod);
        }
        data.m_128379_("active", this.active);
        return data;
    }

    @Override
    public void receiveSyncData(CompoundTag data) {
        super.receiveSyncData(data);
        this.active = data.m_128471_("active");
    }

    @Override
    public void handleHarvestSpeedCheck(PlayerEvent.BreakSpeed ev) {
        if (this.active) {
            ev.setNewSpeed(ev.getNewSpeed() * this.speedBoostMod);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public KeyMapping getKeybind() {
        return AoAKeybinds.ABILITY_ACTION;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldSendKeyPress() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_7500_()) {
            return false;
        }
        return Minecraft.m_91087_().f_91072_.m_105296_() || this.active;
    }

    @Override
    public void handleKeyInput() {
        ServerPlayer player = this.getPlayer();
        if (this.active) {
            this.active = false;
        } else {
            if (player.m_7500_() || !player.f_8941_.f_9249_) {
                return;
            }
            this.active = true;
        }
        this.activatedActionKey(player);
        this.markForClientSync();
    }

    @Override
    public void handlePlayerTick(TickEvent.PlayerTickEvent ev) {
        if (!this.active) {
            return;
        }
        AoAResource.Instance energy = this.skill.getPlayerDataManager().getResource((AoAResource)AoAResources.ENERGY.get());
        ServerPlayer player = this.getPlayer();
        if (!player.m_7500_() && !player.m_5833_() && energy.consume(energy.getPerTickRegen() + this.energyDrainPerTick - this.costReductionPerLevel * (float)this.skill.getLevel(true), true)) {
            if (player.f_19853_.m_46467_() % 10L == 0L) {
                this.activatedActionKey(player);
            }
        } else {
            this.active = false;
            this.markForClientSync();
        }
    }
}

