/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.entity.misc.HaulingFishingBobberEntity;
import net.tslat.aoa3.data.server.AoAHaulingFishReloadListener;
import net.tslat.aoa3.event.custom.events.HaulingItemFishedEvent;
import net.tslat.aoa3.event.custom.events.PlayerChangeXpEvent;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.ability.ScalableModAbility;
import net.tslat.aoa3.player.skill.AoASkill;

public class FishingTrapSpawn
extends ScalableModAbility {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.FISHED_ITEM, AoAPlayerEventListener.ListenerType.GAIN_SKILL_XP};

    public FishingTrapSpawn(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.FISHING_TRAP_SPAWN.get(), skill, data);
    }

    public FishingTrapSpawn(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.FISHING_TRAP_SPAWN.get(), skill, data);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleItemFished(ItemFishedEvent ev, boolean isHauling) {
        if (ev.getPlayer() instanceof ServerPlayer && this.testAsChance()) {
            Function<Level, Entity> trapEntityFunction;
            FishingHook bobber = ev.getHookEntity();
            Player player = ev.getPlayer();
            Level world = bobber.f_19853_;
            BlockPos pos = bobber.m_20183_();
            float luck = bobber.f_37096_;
            boolean isLava = false;
            if (isHauling) {
                luck = ((HaulingItemFishedEvent)ev).getLuck();
                isLava = Fluids.f_76195_.m_205067_(((HaulingFishingBobberEntity)ev.getHookEntity()).getApplicableFluid());
            }
            if ((trapEntityFunction = AoAHaulingFishReloadListener.getTrapListForBiome((Biome)world.m_204166_(pos).m_203334_(), isLava).getRandomElement((ServerPlayer)player, luck)) != null) {
                Entity trapEntity = trapEntityFunction.apply(world);
                double velX = player.m_20185_() - bobber.m_20185_();
                double velY = player.m_20186_() - bobber.m_20186_();
                double velZ = player.m_20189_() - bobber.m_20189_();
                trapEntity.m_20334_(velX * 0.1, velY * 0.1 + Math.sqrt(Math.sqrt(velX * velX + velY * velY + velZ * velZ)) * 0.15, velZ * 0.1);
                trapEntity.m_6034_(bobber.m_20185_(), bobber.m_20186_(), bobber.m_20189_());
                world.m_7967_(trapEntity);
            }
        }
    }

    @Override
    public void handleSkillXpGain(PlayerChangeXpEvent ev) {
        if (ev.getSkill().type() == AoASkills.HAULING.get()) {
            ev.setXpGain(ev.getNewXpGain() * 1.25f);
        }
    }
}

