/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.player.ability;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.custom.AoAAbilities;
import net.tslat.aoa3.player.AoAPlayerEventListener;
import net.tslat.aoa3.player.ability.AoAAbility;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.WorldUtil;

public class BlockConversion
extends AoAAbility.Instance {
    private static final AoAPlayerEventListener.ListenerType[] LISTENERS = new AoAPlayerEventListener.ListenerType[]{AoAPlayerEventListener.ListenerType.BLOCK_INTERACT};
    private final int radius;
    private final Block targetBlock;
    private final Block replacementBlock;
    @Nullable
    private final Item interactionItem;

    public BlockConversion(AoASkill.Instance skill, JsonObject data) {
        super((AoAAbility)AoAAbilities.BLOCK_CONVERSION.get(), skill, data);
        this.radius = GsonHelper.m_13824_((JsonObject)data, (String)"radius", (int)1);
        this.targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)data, (String)"target_block")));
        this.replacementBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)data, (String)"replacement_block")));
        this.interactionItem = data.has("interaction_item") ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)data, (String)"interaction_item"))) : null;
        if (this.radius < 0) {
            throw new IllegalArgumentException("Invalid radius value for BlockConversion ability: '" + this.radius + "'. Must be at least 0");
        }
    }

    public BlockConversion(AoASkill.Instance skill, CompoundTag data) {
        super((AoAAbility)AoAAbilities.BLOCK_CONVERSION.get(), skill, data);
        this.radius = data.m_128451_("radius");
        this.targetBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(data.m_128461_("target_block")));
        this.replacementBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(data.m_128461_("replacement_block")));
        this.interactionItem = data.m_128441_("interaction_item") ? (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(data.m_128461_("interaction_item"))) : null;
    }

    @Override
    protected void updateDescription(MutableComponent defaultDescription) {
        String suffix = this.radius > 0 ? "" : ".single";
        MutableComponent description = this.interactionItem != null ? Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + suffix), (Object[])new Object[]{this.radius, this.targetBlock.m_49954_(), this.replacementBlock.m_49954_(), this.interactionItem.m_7626_(this.interactionItem.m_7968_())}) : Component.m_237110_((String)(((TranslatableContents)defaultDescription.m_214077_()).m_237508_() + ".noItem" + suffix), (Object[])new Object[]{this.radius, this.targetBlock.m_49954_(), this.replacementBlock.m_49954_()});
        super.updateDescription(description);
    }

    @Override
    public AoAPlayerEventListener.ListenerType[] getListenerTypes() {
        return LISTENERS;
    }

    @Override
    public void handleBlockInteraction(PlayerInteractEvent.RightClickBlock ev) {
        if (ev.getWorld().m_8055_(ev.getPos()).m_60734_() == this.targetBlock) {
            ItemStack heldStack = ev.getPlayer().m_21120_(ev.getHand());
            if (this.interactionItem == null || heldStack.m_41720_() == this.interactionItem) {
                Level world = ev.getWorld();
                BlockPos pos = ev.getPos();
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                BlockState newState = this.replacementBlock.m_49966_();
                boolean success = false;
                switch (ev.getHitVec().m_82434_()) {
                    case EAST: 
                    case WEST: {
                        for (int y = -this.radius; y <= this.radius; ++y) {
                            for (int z = -this.radius; z <= this.radius; ++z) {
                                mutablePos.m_122178_(pos.m_123341_(), pos.m_123342_() + y, pos.m_123343_() + z);
                                if (world.m_8055_((BlockPos)mutablePos).m_60734_() != this.targetBlock || !WorldUtil.canModifyBlock((LevelAccessor)world, (BlockPos)mutablePos, (Entity)ev.getPlayer(), heldStack)) continue;
                                world.m_46597_((BlockPos)mutablePos, newState);
                                success = true;
                            }
                        }
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        for (int y = -this.radius; y <= this.radius; ++y) {
                            for (int x = -this.radius; x <= this.radius; ++x) {
                                mutablePos.m_122178_(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_());
                                if (world.m_8055_((BlockPos)mutablePos).m_60734_() != this.targetBlock || !WorldUtil.canModifyBlock((LevelAccessor)world, (BlockPos)mutablePos, (Entity)ev.getPlayer(), heldStack)) continue;
                                world.m_46597_((BlockPos)mutablePos, newState);
                                success = true;
                            }
                        }
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        for (int x = -this.radius; x <= this.radius; ++x) {
                            for (int z = -this.radius; z <= this.radius; ++z) {
                                mutablePos.m_122178_(pos.m_123341_() + x, pos.m_123342_(), pos.m_123343_() + z);
                                if (world.m_8055_((BlockPos)mutablePos).m_60734_() != this.targetBlock || !WorldUtil.canModifyBlock((LevelAccessor)world, (BlockPos)mutablePos, (Entity)ev.getPlayer(), heldStack)) continue;
                                world.m_46597_((BlockPos)mutablePos, newState);
                                success = true;
                            }
                        }
                        break;
                    }
                }
                if (success && this.interactionItem != null && !ev.getPlayer().m_7500_()) {
                    heldStack.m_41774_(1);
                }
            }
        }
    }

    @Override
    public CompoundTag getSyncData(boolean forClientSetup) {
        CompoundTag data = super.getSyncData(forClientSetup);
        if (forClientSetup) {
            data.m_128405_("radius", this.radius);
            data.m_128359_("target_block", ForgeRegistries.BLOCKS.getKey((Object)this.targetBlock).toString());
            data.m_128359_("replacement_block", ForgeRegistries.BLOCKS.getKey((Object)this.replacementBlock).toString());
            if (this.interactionItem != null) {
                data.m_128359_("interaction_item", ForgeRegistries.ITEMS.getKey((Object)this.interactionItem).toString());
            }
        }
        return data;
    }
}

