/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.world.genold.feature.features.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class LiquidDrainConfig
implements FeatureConfiguration {
    public static final Codec<LiquidDrainConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidState.f_76146_.optionalFieldOf("fluid", (Object)Fluids.f_76193_.m_75953_(8, true)).forGetter(config -> config.fluid), (App)Codec.BOOL.optionalFieldOf("fill_with_liquid", (Object)false).forGetter(config -> config.fill), (App)Codec.BOOL.optionalFieldOf("carves_upwards", (Object)false).forGetter(config -> config.inverseDirection), (App)BlockState.f_61039_.listOf().optionalFieldOf("stop_at_blocks", Collections.singletonList(Blocks.f_50016_.m_49966_())).forGetter(config -> config.stopBlocks)).apply((Applicative)instance, LiquidDrainConfig::new));
    public final FluidState fluid;
    public final boolean fill;
    public final boolean inverseDirection;
    public final List<BlockState> stopBlocks;

    public LiquidDrainConfig(FluidState fluid, boolean fill, boolean inverseDirection, List<BlockState> stopBlocks) {
        this.fluid = fluid;
        this.fill = fill;
        this.inverseDirection = inverseDirection;
        this.stopBlocks = stopBlocks;
    }

    public static class Builder {
        private FluidState fluid = Fluids.f_76193_.m_76145_();
        private boolean fill = false;
        private boolean inverseDirection = false;
        private List<BlockState> stopBlocks = Collections.singletonList(Blocks.f_50016_.m_49966_());

        public Builder fluid(FluidState fluid) {
            this.fluid = fluid;
            return this;
        }

        public Builder fillWithFluid() {
            this.fill = true;
            return this;
        }

        public Builder carveUpwards() {
            this.inverseDirection = true;
            return this;
        }

        public Builder stopAt(BlockState ... states) {
            this.stopBlocks = Arrays.asList(states);
            return this;
        }

        public LiquidDrainConfig build() {
            return new LiquidDrainConfig(this.fluid, this.fill, this.inverseDirection, this.stopBlocks);
        }
    }
}

