/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.container.InfusionTableContainer;
import net.tslat.aoa3.common.registration.AoARecipes;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.util.LocaleUtil;

public class InfusionRecipe
implements Recipe<InfusionTableContainer.InfusionInventory> {
    private static final InfusionRecipe EMPTY_RECIPE = new InfusionRecipe(new ResourceLocation("aoa3", "infusion_empty"), "", ItemStack.f_41583_, Ingredient.f_43901_, (NonNullList<Ingredient>)NonNullList.m_122779_(), 1, 0, 0);
    private final ResourceLocation id;
    private final String group;
    private final ItemStack output;
    private final Ingredient input;
    protected final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;
    private final int minXp;
    private final int maxXp;
    private final boolean isEnchanting;
    private final Enchantment enchantment;
    private final int enchantmentLevel;
    private final int infusionReq;

    public InfusionRecipe(ResourceLocation id, String group, ItemStack output, Ingredient input, NonNullList<Ingredient> ingredients, int infusionLevelReq, int minXp, int maxXp) {
        this.id = id;
        this.isEnchanting = false;
        this.output = output;
        this.input = input;
        this.ingredients = ingredients;
        this.group = group;
        this.infusionReq = Mth.m_14045_((int)infusionLevelReq, (int)1, (int)1000);
        boolean simple = true;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isSimple()) continue;
            simple = false;
            break;
        }
        this.isSimple = simple;
        this.enchantment = null;
        this.enchantmentLevel = -1;
        this.minXp = minXp;
        this.maxXp = maxXp;
    }

    public InfusionRecipe(ResourceLocation id, String group, Enchantment enchantment, int level, NonNullList<Ingredient> ingredients, int infusionLevelReq, int minXp, int maxXp) {
        this.id = id;
        this.isEnchanting = true;
        this.group = group;
        this.enchantment = enchantment;
        this.ingredients = ingredients;
        this.enchantmentLevel = level;
        this.infusionReq = Mth.m_14045_((int)infusionLevelReq, (int)1, (int)1000);
        boolean simple = true;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isSimple()) continue;
            simple = false;
            break;
        }
        this.isSimple = simple;
        this.output = ItemStack.f_41583_;
        this.input = Ingredient.f_43901_;
        this.minXp = minXp;
        this.maxXp = maxXp;
    }

    public boolean matches(InfusionTableContainer.InfusionInventory inv, Level world) {
        if (this != EMPTY_RECIPE) {
            int ingredientCount = 0;
            StackedContents recipeItemHelper = new StackedContents();
            ArrayList<ItemStack> inputIngredients = new ArrayList<ItemStack>();
            ItemStack inputStack = inv.m_8020_(0);
            if (inputStack.m_41619_() || !this.isEnchanting && !this.input.test(inputStack)) {
                return false;
            }
            for (int i = 1; i < 10; ++i) {
                ItemStack stack = inv.m_8020_(i);
                if (stack.m_41619_()) continue;
                ++ingredientCount;
                if (this.isSimple) {
                    recipeItemHelper.m_36468_(stack, 1);
                    continue;
                }
                inputIngredients.add(stack);
            }
            if (ingredientCount != this.ingredients.size()) {
                return false;
            }
            if (this.isEnchanting && EnchantmentHelper.m_44843_((Enchantment)this.enchantment, (ItemStack)inputStack) >= this.enchantmentLevel) {
                return false;
            }
            if (this.isSimple) {
                return recipeItemHelper.m_36475_((Recipe)this, null);
            }
            return RecipeMatcher.findMatches(inputIngredients, this.ingredients) != null;
        }
        return false;
    }

    public ItemStack assemble(InfusionTableContainer.InfusionInventory inv) {
        if (this.isEnchanting) {
            return this.provideEmptyOrCompatibleStackForEnchanting(inv.m_8020_(0).m_41777_());
        }
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)AoABlocks.INFUSION_TABLE.get());
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public ItemStack m_8043_() {
        return this.isEnchanting ? ItemStack.f_41583_ : this.output;
    }

    public Ingredient getRecipeInput() {
        return this.input;
    }

    public boolean isEnchanting() {
        return this.isEnchanting;
    }

    public int getInfusionReq() {
        return this.infusionReq;
    }

    public int getMinXp() {
        return this.minXp;
    }

    public int getMaxXp() {
        return this.maxXp;
    }

    @Nullable
    public EnchantmentInstance getEnchantment() {
        if (this.enchantment == null) {
            return null;
        }
        return new EnchantmentInstance(this.enchantment, this.enchantmentLevel);
    }

    public ItemStack getEnchantmentAsBook() {
        if (!this.isEnchanting || this == EMPTY_RECIPE) {
            return ItemStack.f_41583_;
        }
        ItemStack bookStack = new ItemStack((ItemLike)Items.f_42690_);
        EnchantedBookItem.m_41153_((ItemStack)bookStack, (EnchantmentInstance)new EnchantmentInstance(this.enchantment, this.enchantmentLevel));
        return bookStack;
    }

    public NonNullList<ItemStack> getRemainingItems(InfusionTableContainer.InfusionInventory inv) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        remainingItems.set(0, (Object)ItemStack.f_41583_);
        for (int i = 1; i < remainingItems.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return remainingItems;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public String m_6076_() {
        return this.group;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AoARecipes.INFUSION.serializer().get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)AoARecipes.INFUSION.type().get();
    }

    public ItemStack provideEmptyOrCompatibleStackForEnchanting(ItemStack inputStack) {
        if (this == EMPTY_RECIPE || !this.enchantment.m_6081_(inputStack) || !((Boolean)AoAConfig.SERVER.allowUnsafeInfusion.get()).booleanValue() && this.enchantment.m_6586_() < this.enchantmentLevel) {
            return ItemStack.f_41583_;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)inputStack);
        for (Enchantment enchantment : enchantments.keySet()) {
            if (this.enchantment == enchantment || enchantment.m_44695_(this.enchantment) && this.enchantment.m_44695_(enchantment)) continue;
            return ItemStack.f_41583_;
        }
        enchantments.put(this.enchantment, this.enchantmentLevel);
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)inputStack);
        return inputStack;
    }

    public static class Factory
    implements RecipeSerializer<InfusionRecipe> {
        public InfusionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            if (GsonHelper.m_13900_((JsonObject)json, (String)"infusion")) {
                String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
                int level = 1;
                int infusionReq = 1;
                int minXp = 0;
                int maxXp = 0;
                NonNullList ingredients = NonNullList.m_122779_();
                JsonObject enchantmentJson = GsonHelper.m_13930_((JsonObject)json, (String)"infusion");
                if (!enchantmentJson.has("enchantment")) {
                    throw new JsonParseException("No valid enchantment for Infusion recipe");
                }
                String enchantmentString = GsonHelper.m_13906_((JsonObject)enchantmentJson, (String)"enchantment");
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentString));
                if (json.has("infusion_level")) {
                    infusionReq = GsonHelper.m_13927_((JsonObject)json, (String)"infusion_level");
                }
                if (json.has("infusion_xp")) {
                    JsonObject xpJson = GsonHelper.m_13930_((JsonObject)json, (String)"infusion_xp");
                    if (xpJson.isJsonPrimitive()) {
                        minXp = maxXp = xpJson.getAsInt();
                    } else if (xpJson.has("min")) {
                        if (!xpJson.has("max")) {
                            throw new JsonParseException("No max set for min/max xp amount for infusion recipe");
                        }
                        minXp = Math.max(0, GsonHelper.m_13927_((JsonObject)xpJson, (String)"min"));
                        maxXp = Math.max(minXp, GsonHelper.m_13927_((JsonObject)xpJson, (String)"max"));
                    }
                }
                if (enchantment == null) {
                    throw new JsonParseException("Invalid enchantment for infusion recipe: " + enchantmentString);
                }
                if (enchantmentJson.has("level")) {
                    level = GsonHelper.m_13927_((JsonObject)enchantmentJson, (String)"level");
                }
                if (!((Boolean)AoAConfig.SERVER.allowUnsafeInfusion.get()).booleanValue() && enchantment.m_6586_() < level) {
                    throw new JsonParseException("Unsafe enchantment level for recipe, Enchantment: " + LocaleUtil.getLocaleString(enchantment.m_44704_()) + ", Lvl: " + level + ", and Allow Unsafe Infusion not enabled in config");
                }
                for (JsonElement element : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
                    try {
                        ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element));
                    }
                    catch (JsonSyntaxException ex) {
                        if (ex.getMessage().startsWith("Unknown item") && !ModList.get().isLoaded(ex.getMessage().split("'")[1].split(":")[0])) {
                            return EMPTY_RECIPE;
                        }
                        throw ex;
                    }
                }
                if (ingredients.isEmpty()) {
                    throw new JsonParseException("No ingredients for infusion table recipe");
                }
                if (ingredients.size() > 9) {
                    throw new JsonParseException("Too many ingredients for infusion table recipe");
                }
                return new InfusionRecipe(recipeId, group, enchantment, level, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
            }
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient input = CraftingHelper.getIngredient((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            NonNullList ingredients = NonNullList.m_122779_();
            int infusionReq = 1;
            int minXp = 0;
            int maxXp = 0;
            if (json.has("infusion_level")) {
                infusionReq = GsonHelper.m_13927_((JsonObject)json, (String)"infusion_level");
            }
            if (json.has("infusion_xp")) {
                JsonObject xpJson = GsonHelper.m_13930_((JsonObject)json, (String)"infusion_xp");
                if (xpJson.isJsonPrimitive()) {
                    minXp = maxXp = xpJson.getAsInt();
                } else if (xpJson.has("min")) {
                    if (!xpJson.has("max")) {
                        throw new JsonParseException("No max set for min/max xp amount for infusion recipe");
                    }
                    minXp = Math.max(0, GsonHelper.m_13927_((JsonObject)xpJson, (String)"min"));
                    maxXp = Math.max(minXp, GsonHelper.m_13927_((JsonObject)xpJson, (String)"max"));
                }
            }
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for infusion table recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for infusion table recipe");
            }
            return new InfusionRecipe(recipeId, group, output, input, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
        }

        @Nullable
        public InfusionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            if (buffer.readBoolean()) {
                Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.m_130281_());
                int lvl = buffer.readInt();
                NonNullList ingredients = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
                for (int i = 0; i < ingredients.size(); ++i) {
                    ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
                }
                int infusionReq = buffer.readInt();
                int minXp = buffer.readInt();
                int maxXp = buffer.readInt();
                return new InfusionRecipe(recipeId, group, ench, lvl, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
            }
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            NonNullList ingredients = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            int infusionReq = buffer.readInt();
            int minXp = buffer.readInt();
            int maxXp = buffer.readInt();
            return new InfusionRecipe(recipeId, group, output, input, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
        }

        public void toNetwork(FriendlyByteBuf buffer, InfusionRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            if (recipe.isEnchanting()) {
                buffer.writeBoolean(true);
                buffer.m_130085_(ForgeRegistries.ENCHANTMENTS.getKey((Object)recipe.getEnchantment().f_44947_));
                buffer.writeInt(recipe.getEnchantment().f_44948_);
                buffer.writeInt(recipe.m_7527_().size());
                for (Ingredient ing : recipe.m_7527_()) {
                    ing.m_43923_(buffer);
                }
            } else {
                buffer.writeBoolean(false);
                recipe.getRecipeInput().m_43923_(buffer);
                buffer.writeItemStack(recipe.m_8043_(), false);
                buffer.writeInt(recipe.m_7527_().size());
                for (Ingredient ing : recipe.m_7527_()) {
                    ing.m_43923_(buffer);
                }
            }
            buffer.writeInt(recipe.getInfusionReq());
            buffer.writeInt(recipe.getMinXp());
            buffer.writeInt(recipe.getMaxXp());
        }
    }
}

