/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tslat.aoa3.util.ObjectUtil;

public class AddItemsLootModifier
extends LootModifier {
    private final List<ItemStack> additionalStacks;

    public AddItemsLootModifier(LootItemCondition[] conditions, List<ItemStack> additionalStacks) {
        super(conditions);
        this.additionalStacks = additionalStacks;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        generatedLoot.addAll(this.additionalStacks);
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddItemsLootModifier> {
        public AddItemsLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] lootConditions) {
            JsonArray items = GsonHelper.m_13933_((JsonObject)object, (String)"items");
            ArrayList<ItemStack> extraItems = new ArrayList<ItemStack>(items.size());
            for (JsonElement element : items) {
                if (element.isJsonObject()) {
                    extraItems.add(CraftingHelper.getItemStack((JsonObject)element.getAsJsonObject(), (boolean)true));
                    continue;
                }
                if (!element.isJsonPrimitive()) continue;
                extraItems.add(new ItemStack((ItemLike)Registry.f_122827_.m_6612_(new ResourceLocation(element.getAsString())).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + element.getAsString() + "'"))));
            }
            return new AddItemsLootModifier(lootConditions, extraItems);
        }

        public JsonObject write(AddItemsLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            JsonArray items = new JsonArray();
            for (ItemStack stack : instance.additionalStacks) {
                items.add((JsonElement)ObjectUtil.stackToJson(stack));
            }
            json.add("items", (JsonElement)items);
            json.addProperty("type", ((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS.get()).getKey((Object)this).toString());
            return json;
        }
    }
}

