/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoATags;
import net.tslat.aoa3.common.registration.AoATiers;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class RunicSword
extends BaseSword {
    public RunicSword() {
        super(AoATiers.RUNIC);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
        ItemStack offhandStack;
        if (!attacker.f_19853_.f_46443_ && (double)attackCooldown > 0.75 && attacker instanceof Player && (offhandStack = attacker.m_21206_()).m_204117_(AoATags.Items.ADVENT_RUNE) && offhandStack.m_41613_() >= 5) {
            Item rune = offhandStack.m_41720_();
            if (rune == AoAItems.POISON_RUNE.get()) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 72, 1, false, true));
            } else if (rune == AoAItems.WITHER_RUNE.get()) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 40, 2, false, true));
            } else if (rune == AoAItems.FIRE_RUNE.get()) {
                target.m_20254_(5);
            } else if (rune == AoAItems.WIND_RUNE.get()) {
                DamageUtil.doScaledKnockback(target, (Entity)attacker, 0.5f, attacker.m_20185_() - target.m_20185_(), attacker.m_20189_() - target.m_20189_());
            } else if (rune == AoAItems.WATER_RUNE.get()) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0, false, true));
            } else if (rune == AoAItems.CHARGED_RUNE.get()) {
                ((ServerLevel)target.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123792_, target.m_20185_() + (double)(RandomUtil.randomValueUpTo(1.0f) * target.m_20205_() * 2.0f) - (double)target.m_20205_(), target.m_20186_() + 1.0 + (double)(RandomUtil.randomValueUpTo(1.0f) * target.m_20206_()), target.m_20189_() + (double)(RandomUtil.randomValueUpTo(1.0f) * target.m_20205_() * 2.0f) - (double)target.m_20205_(), 3, 0.0, 0.0, 0.0, 0.0);
            } else {
                return;
            }
            if (!((Player)attacker).m_7500_()) {
                offhandStack.m_41774_(5);
                ItemUtil.damageItem(stack, attacker, 1, EquipmentSlot.MAINHAND);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.HARMFUL, 2, new Component[0]));
    }
}

