/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.common.registration.AoATiers;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityProvider;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class GuardiansSword
extends BaseSword {
    public GuardiansSword() {
        super(AoATiers.GUARDIAN);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(heldStack, null);
        if (cap.getValue() <= 0.0f && ItemUtil.findInventoryItem(player, new ItemStack((ItemLike)AoAItems.CRYSTALLITE.get()), true, 1)) {
            cap.setValue(world.m_46467_());
            if (world instanceof ServerLevel) {
                double xOffset = -Mth.m_14031_((float)(player.m_146908_() * (float)Math.PI / 140.0f));
                double zOffset = Mth.m_14089_((float)(player.m_146908_() * (float)Math.PI / 140.0f));
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123810_, player.m_20185_() + xOffset, player.m_20186_() + (double)player.m_20206_() * 0.5, player.m_20189_() + zOffset, 5, xOffset, 0.0, zOffset, 0.0);
            }
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        return super.m_7203_(world, player, hand);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        PersistentStackCapabilityProvider.getOrDefault(stack, Direction.NORTH).setValue(player.m_36403_(0.0f));
        return false;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag tag = super.getShareTag(stack);
        if (tag == null) {
            tag = new CompoundTag();
        }
        tag.m_128350_("AdventMiscStackCapability", PersistentStackCapabilityProvider.getOrDefault(stack, null).getValue());
        return tag;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_("AdventMiscStackCapability")) {
            PersistentStackCapabilityProvider.getOrDefault(stack, null).setValue(nbt.m_128457_("AdventMiscStackCapability"));
        }
        super.readShareTag(stack, nbt);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        PersistentStackCapabilityHandles cap;
        if (world.m_46467_() % 10L == 0L && (cap = PersistentStackCapabilityProvider.getOrDefault(stack, null)).getValue() > 0.0f && cap.getValue() < (float)(world.m_46467_() - 2400L)) {
            cap.setValue(0.0f);
        }
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ItemUtil.damageItem(stack, attacker, 1, EquipmentSlot.MAINHAND);
        return true;
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PersistentStackCapabilityProvider(null);
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> attributeMap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlot.MAINHAND) {
            int buff = 0;
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            if (cap.getValue() > 0.0f) {
                buff = 3;
            }
            ItemUtil.setAttribute(attributeMap, Attributes.f_22281_, f_41374_, this.m_43299_() + (float)buff);
        }
        return attributeMap;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

