/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public class CrystalStaff
extends BaseStaff<List<Player>> {
    public CrystalStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CRYSTEVIA_STAFF_CAST.get();
    }

    @Override
    public List<Player> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List playerList = caster.f_19853_.m_6443_(Player.class, caster.m_20191_().m_82400_(20.0), PlayerUtil::shouldPlayerBeAffected);
        if (playerList.isEmpty()) {
            return null;
        }
        for (Player pl : playerList) {
            if (pl.m_21223_() == pl.m_21233_()) continue;
            return playerList;
        }
        return null;
    }

    @Override
    protected void populateRunes(HashMap<Item, Integer> runes) {
        runes.put((Item)AoAItems.DISTORTION_RUNE.get(), 2);
        runes.put((Item)AoAItems.LIFE_RUNE.get(), 5);
    }

    @Override
    public void cast(Level world, ItemStack staff, LivingEntity caster, List<Player> args) {
        float currentTotalHealth = 0.0f;
        float currentMaxHealth = 0.0f;
        for (Player pl : args) {
            currentMaxHealth += pl.m_21233_();
            currentTotalHealth += pl.m_21223_();
        }
        float healthPerPlayer = currentMaxHealth * (currentTotalHealth / currentMaxHealth * 1.25f) / (float)args.size();
        for (Player pl : args) {
            pl.m_21153_(healthPerPlayer);
        }
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

