/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.ShoeShotEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class ShoeFlinger
extends BaseGun {
    double dmg;
    int firingDelay;

    public ShoeFlinger(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(AoAItemGroups.GUNS, dmg, durability, firingDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_AIR_CANNON_FIRE.get();
    }

    @Override
    protected float getFiringSoundPitchAdjust() {
        return 0.85f;
    }

    @Override
    public Item getAmmoItem() {
        return Items.f_42463_;
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new ShoeShotEntity(shooter, this, hand, 120, 0);
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            DamageUtil.doScaledKnockback(livingTarget, (Entity)shooter, 1.35f, shooter.m_20185_() - target.m_20185_(), shooter.m_20189_() - target.m_20189_());
            if (shooter instanceof ServerPlayer && livingTarget.m_21223_() == 0.0f && !target.m_6072_()) {
                AdvancementUtil.completeAdvancement((ServerPlayer)shooter, new ResourceLocation("aoa3", "overworld/la_chancla"), "shoe_flinger_boss_kill");
            }
            if (!livingTarget.m_21033_(EquipmentSlot.FEET)) {
                livingTarget.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42463_));
            }
        }
    }

    @Override
    protected void doFiringSound(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        shooter.f_19853_.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 1.0f, this.getFiringSoundPitchAdjust() + (float)RandomUtil.randomScaledGaussianValue(0.01f));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

