/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class FlamingFury
extends BaseGun {
    public FlamingFury(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(AoAItemGroups.GUNS, dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_GENERIC_FIRE_2.get();
    }

    @Override
    protected void doFiringEffects(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        if (this.getFiringSound() != null) {
            shooter.f_19853_.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        for (int i = 0; i < 6; ++i) {
            ((ServerLevel)shooter.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123799_, bullet.m_20185_() + RandomUtil.randomScaledGaussianValue(0.2f), bullet.m_20186_() + RandomUtil.randomScaledGaussianValue(0.2f), bullet.m_20189_() + RandomUtil.randomScaledGaussianValue(0.2f), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        AreaEffectCloud cloud = new AreaEffectCloud(bullet.f_19853_, (target.m_20185_() + bullet.m_20185_()) / 2.0, (target.m_20186_() + bullet.m_20186_()) / 2.0, (target.m_20189_() + bullet.m_20189_()) / 2.0);
        cloud.m_19718_(shooter);
        cloud.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
        cloud.m_19712_(1.0f);
        cloud.m_19734_(20);
        cloud.m_19738_((5.0f - cloud.m_19743_()) / (float)cloud.m_19748_());
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 0));
        bullet.f_19853_.m_7967_((Entity)cloud);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        super.m_7373_(stack, world, tooltip, flag);
    }
}

