/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.GunRecoilPacket;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.enchantment.BraceEnchantment;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.content.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.content.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.content.item.weapon.thrown.BaseThrownWeapon;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public abstract class BaseGun
extends Item {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers = HashMultimap.create();
    protected static final UUID ATTACK_SPEED_MAINHAND = UUID.fromString("99fdc256-279e-4c8e-b1c6-9209571f134e");
    protected static final UUID ATTACK_SPEED_OFFHAND = UUID.fromString("63f030a6-7269-444d-b26c-ae3514b36e1b");
    protected final double dmg;
    protected final int firingDelay;
    protected final float recoilMod;
    protected double holsterMod;

    public BaseGun(Item.Properties properties, double dmg, int fireDelayTicks, float recoilMod) {
        super(properties);
        this.dmg = dmg;
        this.firingDelay = fireDelayTicks;
        this.recoilMod = recoilMod;
        this.holsterMod = this.getDamage() == 0.0 ? 0.85 : (this instanceof BaseThrownWeapon ? 0.5 : 0.8 + 0.17 * Math.min(20.0 / (double)this.getFiringDelay() * this.getDamage() / 55.0, 0.85));
        this.attributeModifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(ATTACK_SPEED_MAINHAND, "AoAGunMainHand", -this.getHolsterSpeed(), AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public BaseGun(CreativeModeTab itemGroup, double dmg, int durability, int fireDelayTicks, float recoilMod) {
        this(new Item.Properties().m_41491_(itemGroup).m_41503_(durability), dmg, fireDelayTicks, recoilMod);
    }

    public double getDamage() {
        return this.dmg;
    }

    public float getRecoilModifier() {
        return 0.35f;
    }

    public int getFiringDelay() {
        return this.firingDelay;
    }

    private double getHolsterSpeed() {
        return this.holsterMod;
    }

    @Nullable
    public SoundEvent getFiringSound() {
        return null;
    }

    protected float getFiringSoundPitchAdjust() {
        return 1.0f;
    }

    public float getRecoilForShot(ItemStack stack, LivingEntity shooter) {
        return (this.getDamage() == 0.0 ? 1.0f : (float)Math.pow(this.dmg, 1.4f)) * this.getRecoilModifier();
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public int m_6473_() {
        return 8;
    }

    public Item getAmmoItem() {
        return (Item)AoAItems.LIMONITE_BULLET.get();
    }

    public InteractionHand getGunHand(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.BRACE.get()), (ItemStack)stack) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean isFullAutomatic() {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        Item mainItem;
        ItemStack stack = player.m_21120_(hand);
        if (hand != this.getGunHand(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player.m_6117_() && player.m_21254_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_36403_(0.0f) < 1.0f) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (hand == InteractionHand.OFF_HAND && player.m_6144_() && ((mainItem = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_()) instanceof BaseSniper || mainItem instanceof BaseStaff)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity shooter, int count) {
        if (!this.isFullAutomatic() && count < this.m_8105_(stack)) {
            return;
        }
        ServerPlayer player = shooter instanceof ServerPlayer ? (ServerPlayer)shooter : null;
        int nextFireDelay = this.getFiringDelay();
        if (player == null || player.m_36335_().m_41521_((Item)this, 0.0f) == 0.0f) {
            InteractionHand hand = this.getGunHand(stack);
            if (this.fireGun(shooter, stack, hand)) {
                if (hand == InteractionHand.MAIN_HAND) {
                    ItemStack offhand = shooter.m_21120_(InteractionHand.OFF_HAND);
                    if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.BRACE.get()), (ItemStack)offhand) > 0) {
                        offhand.onUsingTick(shooter, count);
                    }
                }
                ItemUtil.damageItem(stack, shooter, 1, hand == InteractionHand.OFF_HAND ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND);
                if (player != null) {
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    player.m_36335_().m_41524_((Item)this, nextFireDelay);
                    this.doRecoil(player, stack, hand);
                }
            } else {
                shooter.m_21253_();
            }
        }
    }

    protected boolean fireGun(LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        BaseBullet bullet = this.findAndConsumeAmmo(shooter, stack, hand);
        if (bullet == null) {
            return false;
        }
        shooter.f_19853_.m_7967_((Entity)bullet);
        if (!shooter.f_19853_.m_5776_()) {
            this.doFiringEffects(shooter, bullet, stack, hand);
        }
        return true;
    }

    public void doRecoil(ServerPlayer player, ItemStack stack, InteractionHand hand) {
        int control = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.CONTROL.get()), (ItemStack)stack);
        float recoilAmount = this.getRecoilForShot(stack, (LivingEntity)player) * 2.0f * (1.0f - (float)control * 0.15f);
        AoAPackets.messagePlayer(player, new GunRecoilPacket(hand == InteractionHand.OFF_HAND ? recoilAmount * 1.25f : recoilAmount, this.getFiringDelay()));
    }

    protected void doFiringEffects(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        this.doFiringSound(shooter, bullet, stack, hand);
        ((ServerLevel)shooter.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, bullet.m_20185_(), bullet.m_20186_(), bullet.m_20189_(), 2, 0.0, 0.0, 0.0, (double)0.025f);
        if (this.dmg > 15.0) {
            if (this.dmg > 20.0) {
                ((ServerLevel)shooter.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123744_, bullet.m_20185_(), bullet.m_20186_(), bullet.m_20189_(), 2, 0.0, 0.0, 0.0, (double)0.025f);
            }
            ((ServerLevel)shooter.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, bullet.m_20185_(), bullet.m_20186_(), bullet.m_20189_(), 2, 0.0, 0.0, 0.0, (double)0.025f);
        }
    }

    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            float shellMod = 1.0f;
            if (bullet.getHand() != null) {
                shellMod = (float)((double)shellMod + 0.1 * (double)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.SHELL.get()), (ItemStack)shooter.m_21120_(bullet.getHand())));
            }
            if (DamageUtil.dealGunDamage(target, shooter, bullet, (float)this.getDamage() * bulletDmgMultiplier * shellMod)) {
                this.doImpactEffect(target, shooter, bullet, bulletDmgMultiplier);
            } else if (!(target instanceof LivingEntity)) {
                target.m_6469_(new IndirectEntityDamageSource("gun", (Entity)bullet, (Entity)shooter).m_19366_(), (float)this.getDamage() * bulletDmgMultiplier * shellMod);
            }
        }
    }

    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
    }

    protected void doFiringSound(LivingEntity shooter, BaseBullet bullet, ItemStack stack, InteractionHand hand) {
        if (this.getFiringSound() != null) {
            new SoundBuilder(this.getFiringSound()).isPlayer().pitch(this.getFiringSoundPitchAdjust()).varyPitch(0.075f).followEntity((Entity)shooter).play();
        }
    }

    @Nullable
    public BaseBullet findAndConsumeAmmo(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        if (shooter.m_6095_() != EntityType.f_20532_ || ItemUtil.findInventoryItem((Player)shooter, new ItemStack((ItemLike)this.getAmmoItem()), !shooter.f_19853_.m_5776_(), 1 + EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            return this.createProjectileEntity(shooter, gunStack, hand);
        }
        return null;
    }

    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new LimoniteBulletEntity(shooter, this, hand, 120, 0);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        stack.m_41784_().m_128405_("HideFlags", ItemStack.TooltipPart.MODIFIERS.m_41809_());
        return null;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return HashMultimap.create(this.attributeModifiers);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            HashMultimap multimap = HashMultimap.create(this.attributeModifiers);
            multimap.put((Object)Attributes.f_22279_, (Object)BraceEnchantment.BRACE_DEBUFF);
            return multimap;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.gun", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.m_237113_((String)NumberUtil.roundToNthDecimalPlace((float)this.getDamage() * (1.0f + 0.1f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.SHELL.get()), (ItemStack)stack)), 2))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.m_237113_((String)NumberUtil.roundToNthDecimalPlace(20.0f / (float)this.getFiringDelay(), 2))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, this.getAmmoItem().m_41466_()));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this.isFullAutomatic() ? "items.description.gun.fully_automatic" : "items.description.gun.semi_automatic", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
    }
}

