/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.crossbow;

import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class BaseCrossbow
extends CrossbowItem {
    protected double damage;

    public BaseCrossbow(double damage, int durability) {
        super(new Item.Properties().m_41491_(AoAItemGroups.CROSSBOWS).m_41503_(durability));
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack crossbowStack = player.m_21120_(hand);
        if (BaseCrossbow.m_40932_((ItemStack)crossbowStack)) {
            this.fireProjectiles((LivingEntity)player, hand, crossbowStack, this.getShotVelocity(crossbowStack), 1.0f);
            BaseCrossbow.m_40884_((ItemStack)crossbowStack, (boolean)false);
            return InteractionResultHolder.m_19096_((Object)crossbowStack);
        }
        if (!this.findAmmo(crossbowStack, (LivingEntity)player, player.m_7500_()).m_41619_()) {
            if (!BaseCrossbow.m_40932_((ItemStack)crossbowStack)) {
                this.f_40847_ = false;
                this.f_40848_ = false;
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)crossbowStack);
        }
        return InteractionResultHolder.m_19100_((Object)crossbowStack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void m_5929_(Level world, LivingEntity shooter, ItemStack stack, int count) {
        if (!world.f_46443_) {
            int quickCharge = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            SoundEvent chargeSound = this.getChargeSound(quickCharge);
            SoundEvent middleChargeSound = quickCharge == 0 ? SoundEvents.f_11842_ : null;
            float chargePercent = (float)(stack.m_41779_() - count) / (float)BaseCrossbow.m_40939_((ItemStack)stack);
            if (chargePercent < 0.2f) {
                this.f_40847_ = false;
                this.f_40848_ = false;
            }
            if (chargePercent >= 0.2f && !this.f_40847_) {
                this.f_40847_ = true;
                world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), chargeSound, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (chargePercent >= 0.5f && middleChargeSound != null && !this.f_40848_) {
                this.f_40848_ = true;
                world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), middleChargeSound, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack crossbowStack, Level world, LivingEntity shooter, int timeLeft) {
        int useTicks = this.m_8105_(crossbowStack) - timeLeft;
        float charge = this.getCharge(crossbowStack, useTicks);
        if (charge >= 1.0f && !BaseCrossbow.m_40932_((ItemStack)crossbowStack) && this.hasAmmo(shooter, crossbowStack)) {
            BaseCrossbow.m_40884_((ItemStack)crossbowStack, (boolean)true);
            world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11841_, shooter instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 1.0f / (float)RandomUtil.randomValueBetween(1.0, 1.5) + 0.2f);
        }
    }

    protected ItemStack findAmmo(ItemStack crossbowStack, LivingEntity player, boolean infiniteAmmo) {
        return player.m_6298_(crossbowStack);
    }

    protected boolean hasAmmo(LivingEntity user, ItemStack crossbowStack) {
        int multishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbowStack);
        boolean infiniteAmmo = user instanceof Player && ((Player)user).m_7500_();
        ItemStack ammoStack = this.findAmmo(crossbowStack, user, infiniteAmmo);
        ItemStack ammoStackCopy = ammoStack.m_41777_();
        for (int i = 0; i < 1 + multishot * 2; ++i) {
            if (i > 0) {
                ammoStack = ammoStackCopy.m_41777_();
            }
            if (ammoStack.m_41619_() && infiniteAmmo) {
                ammoStack = new ItemStack((ItemLike)Items.f_42412_);
                ammoStackCopy = ammoStack.m_41777_();
            }
            if (this.chargeShot(user, crossbowStack, ammoStack, i > 0, infiniteAmmo)) continue;
            return false;
        }
        return true;
    }

    protected boolean chargeShot(LivingEntity shooter, ItemStack crossbowStack, ItemStack ammoStack, boolean isMultishotProjectile, boolean infiniteAmmo) {
        ItemStack itemstack;
        boolean canUseAmmo;
        if (ammoStack.m_41619_()) {
            return false;
        }
        boolean bl = canUseAmmo = infiniteAmmo && ammoStack.m_41720_() instanceof ArrowItem;
        if (!(canUseAmmo || infiniteAmmo || isMultishotProjectile)) {
            itemstack = ammoStack.m_41620_(1);
            if (ammoStack.m_41619_() && shooter instanceof Player) {
                ((Player)shooter).m_150109_().m_36057_(ammoStack);
            }
        } else {
            itemstack = ammoStack.m_41777_();
        }
        this.m_40928_(crossbowStack, itemstack);
        return true;
    }

    protected void m_40928_(ItemStack crossbow, ItemStack projectile) {
        CompoundTag tag = crossbow.m_41784_();
        ListTag projectilesNbt = tag.m_128425_("ChargedProjectiles", 9) ? tag.m_128437_("ChargedProjectiles", 10) : new ListTag();
        CompoundTag projectileTag = new CompoundTag();
        projectile.m_41739_(projectileTag);
        projectilesNbt.add((Object)projectileTag);
        tag.m_128365_("ChargedProjectiles", (Tag)projectilesNbt);
    }

    protected void fireProjectiles(LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, float baseVelocity, float baseInaccuracy) {
        List<ItemStack> projectiles = this.m_40941_(crossbowStack);
        if (projectiles.isEmpty()) {
            return;
        }
        float[] soundPitches = this.getRandomSoundPitches(RandomUtil.RANDOM.getSource(), projectiles.size());
        boolean creativeMode = shooter instanceof Player && ((Player)shooter).m_7500_();
        float spreadModifier = -10.0f;
        this.fireProjectile(shooter, hand, crossbowStack, projectiles.get(0), soundPitches[0], creativeMode, baseVelocity, baseInaccuracy, 0.0f);
        for (int i = 1; i < projectiles.size(); ++i) {
            ItemStack projectile = projectiles.get(i);
            this.fireProjectile(shooter, hand, crossbowStack, projectile, soundPitches[i], creativeMode, baseVelocity, baseInaccuracy, spreadModifier);
            spreadModifier = spreadModifier < 0.0f ? spreadModifier * -1.0f : spreadModifier / -2.0f;
        }
        if (shooter instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)shooter;
            CriteriaTriggers.f_10555_.m_65462_(player, crossbowStack);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)crossbowStack.m_41720_()));
        }
        this.clearProjectiles(crossbowStack);
    }

    protected void fireProjectile(LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, ItemStack projectileStack, float soundPitch, boolean isCreative, float velocity, float inaccuracy, float projectileAngle) {
        Level world = shooter.m_20193_();
        if (!world.f_46443_) {
            CustomArrowEntity projectile;
            boolean isFirework;
            boolean bl = isFirework = projectileStack.m_41720_() == Items.f_42688_;
            if (isFirework) {
                projectile = new FireworkRocketEntity(world, projectileStack, (Entity)shooter, shooter.m_20185_(), shooter.m_20188_() - (double)0.15f, shooter.m_20189_(), true);
            } else {
                projectile = this.createArrow(shooter, crossbowStack, projectileStack);
                if (isCreative || projectileAngle != 0.0f) {
                    ((AbstractArrow)projectile).f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowUser = (CrossbowAttackMob)shooter;
                crossbowUser.m_5811_(crossbowUser.m_5448_(), crossbowStack, (Projectile)projectile, projectileAngle);
            } else {
                Vec3 vecUp = shooter.m_20289_(1.0f);
                Quaternion angle = new Quaternion(new Vector3f(vecUp), projectileAngle, true);
                Vector3f lookVec = new Vector3f(shooter.m_20252_(1.0f));
                lookVec.m_122251_(angle);
                projectile.m_6686_(lookVec.m_122239_(), lookVec.m_122260_(), lookVec.m_122269_(), velocity, inaccuracy);
            }
            if (projectile instanceof CustomArrowEntity) {
                this.doArrowMods(projectile, (Entity)shooter, 0);
            }
            world.m_7967_((Entity)projectile);
            crossbowStack.m_41622_(isFirework ? 3 : 1, shooter, user -> user.m_21190_(hand));
            world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    protected CustomArrowEntity createArrow(LivingEntity shooter, ItemStack crossbowStack, ItemStack ammoStack) {
        ArrowItem arrowItem = (ArrowItem)(ammoStack.m_41720_() instanceof ArrowItem ? ammoStack.m_41720_() : Items.f_42412_);
        CustomArrowEntity arrow = CustomArrowEntity.fromArrow(arrowItem.m_6394_(shooter.f_19853_, ammoStack, shooter), this, shooter, this.getDamage());
        if (shooter instanceof Player) {
            arrow.m_36762_(true);
        }
        arrow.m_36740_(SoundEvents.f_11840_);
        arrow.m_36793_(true);
        int piercing = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbowStack);
        if (piercing > 0) {
            arrow.m_36767_((byte)piercing);
        }
        return arrow;
    }

    protected float getShotVelocity(ItemStack crossbowStack) {
        return crossbowStack.m_41720_() instanceof BaseCrossbow && BaseCrossbow.m_40871_((ItemStack)crossbowStack, (Item)Items.f_42688_) ? 1.6f : 3.15f;
    }

    protected float getCharge(ItemStack crossbowStack, int useTime) {
        return Math.min((float)useTime / (float)BaseCrossbow.m_40939_((ItemStack)crossbowStack), 1.0f);
    }

    protected List<ItemStack> m_40941_(ItemStack crossbowStack) {
        ArrayList projectiles = Lists.newArrayList();
        CompoundTag tag = crossbowStack.m_41783_();
        if (tag != null && tag.m_128425_("ChargedProjectiles", 9)) {
            ListTag projectileNbt = tag.m_128437_("ChargedProjectiles", 10);
            for (int i = 0; i < projectileNbt.size(); ++i) {
                projectiles.add(ItemStack.m_41712_((CompoundTag)projectileNbt.m_128728_(i)));
            }
        }
        return projectiles;
    }

    protected void clearProjectiles(ItemStack crossbowStack) {
        CompoundTag tag = crossbowStack.m_41783_();
        if (tag != null) {
            ListTag projectilesNbt = tag.m_128437_("ChargedProjectiles", 9);
            projectilesNbt.clear();
            tag.m_128365_("ChargedProjectiles", (Tag)projectilesNbt);
        }
    }

    protected float[] getRandomSoundPitches(RandomSource rand, int amount) {
        float[] pitches = new float[amount];
        for (int i = 0; i < amount; ++i) {
            pitches[i] = 1.0f / (rand.m_188501_() * 0.5f + 1.8f) + (rand.m_188499_() ? 0.63f : 0.43f);
        }
        return pitches;
    }

    protected SoundEvent getChargeSound(int quickCharge) {
        return switch (quickCharge) {
            case 1 -> SoundEvents.f_11844_;
            case 2 -> SoundEvents.f_11845_;
            case 3 -> SoundEvents.f_11846_;
            default -> SoundEvents.f_11843_;
        };
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    public void doArrowMods(CustomArrowEntity arrow, Entity shooter, int useTicksRemaining) {
    }

    public void onEntityHit(CustomArrowEntity arrow, Entity target, Entity shooter, double damage, float drawStrength) {
    }

    public void onBlockHit(CustomArrowEntity arrow, BlockHitResult rayTrace, Entity shooter) {
    }

    public void onArrowTick(CustomArrowEntity arrow, Entity shooter) {
    }

    public double getArrowDamage(CustomArrowEntity arrow, Entity target, double currentDamage, float drawStrength, boolean isCritical) {
        double damage = currentDamage * 0.5 * (double)(drawStrength / 3.0f);
        if (isCritical) {
            damage += damage + damage * RandomUtil.randomScaledGaussianValue(0.35f);
        }
        return damage;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.arrows", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.m_237113_((String)Double.toString(this.getDamage()))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{Component.m_237115_((String)Items.f_42412_.m_5524_())}));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

