/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.blaster;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.custom.AoAResources;
import net.tslat.aoa3.content.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.content.item.EnergyProjectileWeapon;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.library.constant.AttackSpeed;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.player.resource.AoAResource;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PlayerUtil;

public abstract class BaseBlaster
extends Item
implements EnergyProjectileWeapon {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers = HashMultimap.create();
    protected final double baseDmg;
    protected final int firingDelay;
    protected final float energyCost;

    public BaseBlaster(Item.Properties properties, double dmg, int fireDelayTicks, float energyCost) {
        super(properties);
        this.baseDmg = dmg;
        this.firingDelay = fireDelayTicks;
        this.energyCost = energyCost;
        this.attributeModifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)AttackSpeed.forAttacksPerSecond(1.2f), AttributeModifier.Operation.ADDITION));
    }

    public BaseBlaster(double dmg, int durability, int fireDelayTicks, float energyCost) {
        this(new Item.Properties().m_41491_(AoAItemGroups.BLASTERS).m_41503_(durability), dmg, fireDelayTicks, energyCost);
    }

    public double getDamage() {
        return this.baseDmg;
    }

    public int getFiringDelay() {
        return this.firingDelay;
    }

    public float getEnergyCost() {
        return this.energyCost;
    }

    @Nullable
    public SoundEvent getFiringSound() {
        return null;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (hand != this.getWeaponHand((LivingEntity)player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player.m_36403_(0.0f) < 1.0f) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayer)player);
            int recharge = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.RECHARGE.get()), (ItemStack)stack);
            int greed = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)stack);
            float energyConsumption = (1.0f + 0.3f * (float)greed) * this.energyCost * Math.max(0.0f, 1.0f - 0.07f * (float)recharge);
            if (plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.GHOULISH) {
                energyConsumption *= 0.7f;
            }
            if (!player.m_7500_() && plData.getResource((AoAResource)AoAResources.SPIRIT.get()).getCurrentValue() < energyConsumption) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            player.m_6672_(hand);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (player instanceof ServerPlayer) {
            float energyConsumption;
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayer)player);
            int recharge = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.RECHARGE.get()), (ItemStack)stack);
            int greed = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)stack);
            float f = energyConsumption = ((Player)player).m_7500_() ? 0.0f : (1.0f + 0.3f * (float)greed) * this.energyCost * Math.max(0.0f, 1.0f - 0.07f * (float)recharge);
            if (plData.equipment().getCurrentFullArmourSet() == AdventArmour.Type.GHOULISH) {
                energyConsumption *= 0.7f;
            }
            if (((ServerPlayer)player).m_7500_() || plData.getResource((AoAResource)AoAResources.SPIRIT.get()).hasAmount(energyConsumption)) {
                if (count + this.firingDelay <= 72000 && count % this.firingDelay == 0) {
                    if (this.consumeEnergy(plData, stack, energyConsumption)) {
                        if (this.getFiringSound() != null) {
                            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getFiringSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        this.fire(stack, player);
                        ((Player)player).m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        if ((72000 - count) / this.firingDelay >= this.getMaxDamage(stack) - stack.m_41773_()) {
                            ItemUtil.damageItem(stack, player, (72000 - count) / this.firingDelay, EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.BRACE.get()), (ItemStack)stack) > 0 ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND);
                        }
                    } else {
                        player.m_21253_();
                    }
                }
            } else {
                if (player.m_21211_() != ItemStack.f_41583_) {
                    PlayerUtil.notifyPlayerOfInsufficientResources((ServerPlayer)player, (AoAResource)AoAResources.SPIRIT.get(), energyConsumption);
                }
                player.m_21253_();
            }
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity player, int useTicksRemaining) {
        ItemUtil.damageItem(stack, player, (72000 - useTicksRemaining - 1) / this.firingDelay, EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.BRACE.get()), (ItemStack)stack) > 0 ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND);
    }

    public abstract void fire(ItemStack var1, LivingEntity var2);

    public boolean consumeEnergy(ServerPlayerDataManager plData, ItemStack stack, float cost) {
        return plData.getResource((AoAResource)AoAResources.SPIRIT.get()).consume(cost, false);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        stack.m_41784_().m_128405_("HideFlags", ItemStack.TooltipPart.MODIFIERS.m_41809_());
        return null;
    }

    @Override
    public InteractionHand getWeaponHand(LivingEntity holder) {
        return InteractionHand.MAIN_HAND;
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3 hitPos, LivingEntity shooter) {
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.dealBlasterDamage(shooter, target, (Entity)shot, (float)this.baseDmg, false)) {
            this.doImpactEffect(shot, target, shooter);
            return true;
        }
        return false;
    }

    protected void doImpactEffect(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
    }

    public int m_6473_() {
        return 8;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return this.attributeModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.getDamage() > 0.0) {
            tooltip.add(1, (Component)LocaleUtil.getLocaleMessage("items.description.damage.blaster", ChatFormatting.DARK_RED, new Component[]{Component.m_237113_((String)NumberUtil.roundToNthDecimalPlace((float)this.getDamage(), 1))}));
        }
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.fire", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.effect", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.m_237113_((String)NumberUtil.roundToNthDecimalPlace(20.0f / (float)this.getFiringDelay(), 2))}));
        float energyConsumption = (1.0f + 0.3f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)stack)) * this.getEnergyCost() * Math.max(0.0f, 1.0f - 0.07f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.RECHARGE.get()), (ItemStack)stack));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.resource", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{Component.m_237113_((String)NumberUtil.roundToNthDecimalPlace(energyConsumption, 2)), ((AoAResource)AoAResources.SPIRIT.get()).getName()}));
    }
}

